/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ssh;

import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.SshSession;
import java.io.IOException;

public class CommandExecutor {
    SshSession session;
    String eol;
    String prompt;
    String encoding;

    public CommandExecutor(SshSession session, String eol, String promptCmd, String prompt, String encoding) throws SshException, IOException {
        this.session = session;
        this.eol = eol;
        this.prompt = prompt;
        this.encoding = encoding;
        this.executeCommand(promptCmd);
    }

    public String executeCommand(String cmd) throws SshException, IOException {
        try {
            int ch;
            this.session.getOutputStream().write(cmd.getBytes());
            this.session.getOutputStream().write(this.eol.getBytes());
            StringBuffer buf = new StringBuffer();
            while ((ch = this.session.getInputStream().read()) != -1) {
                buf.append((char)ch);
                if (!buf.toString().endsWith(this.prompt)) continue;
            }
            return buf.toString().substring(0, buf.length() - this.prompt.length()).trim();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
    }
}

