/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sftp;

import com.sshtools.events.Event;
import com.sshtools.events.EventServiceImplementation;
import com.sshtools.logging.Log;
import com.sshtools.sftp.DirectoryOperation;
import com.sshtools.sftp.FileTransferProgress;
import com.sshtools.sftp.GlobRegExpMatching;
import com.sshtools.sftp.NoRegExpMatching;
import com.sshtools.sftp.Perl5RegExpMatching;
import com.sshtools.sftp.RegularExpressionMatching;
import com.sshtools.sftp.SftpFile;
import com.sshtools.sftp.SftpFileAttributes;
import com.sshtools.sftp.SftpFileInputStream;
import com.sshtools.sftp.SftpFileOutputStream;
import com.sshtools.sftp.SftpStatusException;
import com.sshtools.sftp.SftpSubsystemChannel;
import com.sshtools.sftp.TransferCancelledException;
import com.sshtools.ssh.ChannelOpenException;
import com.sshtools.ssh.Client;
import com.sshtools.ssh.SshClient;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.SshSession;
import com.sshtools.ssh2.Ssh2Session;
import com.sshtools.util.EOLProcessor;
import com.sshtools.util.IOUtil;
import com.sshtools.util.UnsignedInteger32;
import com.sshtools.util.UnsignedInteger64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient
implements Client {
    SftpSubsystemChannel sftp;
    String cwd;
    String lcwd;
    private int blocksize = 4096;
    private int asyncRequests = 100;
    private int buffersize = -1;
    int umask = 18;
    public static final int MODE_BINARY = 1;
    public static final int MODE_TEXT = 2;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final int EOL_CR = 3;
    private int eolMode = 1;
    private int transferMode = 1;
    private Vector<String> customRoots = new Vector();
    public static final int NoSyntax = 0;
    public static final int GlobSyntax = 1;
    public static final int Perl5Syntax = 2;
    private int RegExpSyntax = 1;

    public SftpClient(SshClient ssh) throws SftpStatusException, SshException, ChannelOpenException {
        this(ssh, SftpSubsystemChannel.MAX_VERSION);
    }

    public SftpClient(SshSession session) throws SftpStatusException, SshException {
        this(session, SftpSubsystemChannel.MAX_VERSION);
    }

    public SftpClient(SshSession session, int Max_Version) throws SftpStatusException, SshException {
        this.initSftp(session, Max_Version);
    }

    public SftpClient(SshClient ssh, int Max_Version) throws SftpStatusException, SshException, ChannelOpenException {
        SshSession session = ssh.openSessionChannel();
        Ssh2Session ssh2 = (Ssh2Session)session;
        if (!ssh2.startSubsystem("sftp")) {
            if (Log.isDebugEnabled()) {
                Log.debug(this, "The SFTP subsystem failed to start, attempting to execute provider " + ssh.getContext().getSFTPProvider());
            }
            if (!ssh2.executeCommand(ssh.getContext().getSFTPProvider())) {
                ssh2.close();
                throw new SshException("Failed to start SFTP subsystem or SFTP provider " + ssh.getContext().getSFTPProvider(), 6);
            }
        }
        this.initSftp(session, Max_Version);
    }

    private void initSftp(SshSession session, int Max_Version) throws SftpStatusException, SshException {
        this.sftp = new SftpSubsystemChannel(session, Max_Version);
        try {
            this.sftp.initialize();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.cwd = this.sftp.getDefaultDirectory();
        String homeDir = "";
        try {
            homeDir = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.lcwd = homeDir;
        EventServiceImplementation.getInstance().fireEvent(new Event(this, 22, true));
    }

    public void setBlockSize(int blocksize) {
        if (blocksize < 512) {
            throw new IllegalArgumentException("Block size must be greater than 512");
        }
        this.blocksize = blocksize;
    }

    public SftpSubsystemChannel getSubsystemChannel() {
        return this.sftp;
    }

    public void setTransferMode(int transferMode) {
        if (transferMode != 1 && transferMode != 2) {
            throw new IllegalArgumentException("Mode can only be either binary or text");
        }
        this.transferMode = transferMode;
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Transfer mode set to " + (transferMode == 1 ? "binary" : "text"));
        }
    }

    public void setRemoteEOL(int eolMode) {
        this.eolMode = eolMode;
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Remote EOL set to " + (eolMode == 1 ? "CRLF" : (eolMode == 3 ? "CR" : "LF")));
        }
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    public void setBufferSize(int buffersize) {
        this.buffersize = buffersize;
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Buffer size set to " + buffersize);
        }
    }

    public void setMaxAsyncRequests(int asyncRequests) {
        if (asyncRequests < 1) {
            throw new IllegalArgumentException("Maximum asynchronous requests must be greater or equal to 1");
        }
        this.asyncRequests = asyncRequests;
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Max async requests set to " + asyncRequests);
        }
    }

    public int umask(int umask) {
        int old = this.umask;
        this.umask = umask;
        if (Log.isDebugEnabled()) {
            Log.debug(this, "umask " + umask);
        }
        return old;
    }

    public SftpFile openFile(String fileName) throws SftpStatusException, SshException {
        if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
            return this.sftp.openFile(this.resolveRemotePath(fileName), 65);
        }
        return this.sftp.openFile(this.resolveRemotePath(fileName), 1);
    }

    public void cd(String dir) throws SftpStatusException, SshException {
        SftpFileAttributes attr;
        String actual;
        if (dir == null || dir.equals("")) {
            actual = this.sftp.getDefaultDirectory();
        } else {
            actual = this.resolveRemotePath(dir);
            actual = this.sftp.getAbsolutePath(actual);
        }
        if (!actual.equals("") && !(attr = this.sftp.getAttributes(actual)).isDirectory()) {
            throw new SftpStatusException(4, dir + " is not a directory");
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Changing dir from " + this.cwd + " to " + (actual.equals("") ? "user default dir" : actual));
        }
        this.cwd = actual;
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.sftp.getDefaultDirectory();
    }

    public void cdup() throws SftpStatusException, SshException {
        SftpFile cd = this.sftp.getFile(this.cwd);
        SftpFile parent = cd.getParent();
        if (parent != null) {
            this.cwd = parent.getAbsolutePath();
        }
    }

    private File resolveLocalPath(String path) {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(this.lcwd, path);
        }
        return f;
    }

    private boolean isWindowsRoot(String path) {
        return (path = path.trim()).length() > 2 && ((path.charAt(0) >= 'a' && path.charAt(0) <= 'z' || path.charAt(0) >= 'A' && path.charAt(0) <= 'Z') && path.charAt(1) == ':' && path.charAt(2) == '/' || path.charAt(2) == '\\');
    }

    public void addCustomRoot(String rootPath) {
        this.customRoots.addElement(rootPath);
    }

    public void removeCustomRoot(String rootPath) {
        this.customRoots.removeElement(rootPath);
    }

    private boolean startsWithCustomRoot(String path) {
        Enumeration<String> it = this.customRoots.elements();
        while (it != null && it.hasMoreElements()) {
            if (!path.startsWith(it.nextElement())) continue;
            return true;
        }
        return false;
    }

    private String resolveRemotePath(String path) throws SftpStatusException {
        this.verifyConnection();
        String actual = !path.startsWith("/") && !path.startsWith(this.cwd) && !this.isWindowsRoot(path) && !this.startsWithCustomRoot(path) ? this.cwd + (this.cwd.endsWith("/") ? "" : "/") + path : path;
        if (!actual.equals("/") && actual.endsWith("/")) {
            return actual.substring(0, actual.length() - 1);
        }
        return actual;
    }

    private void verifyConnection() throws SftpStatusException {
        if (this.sftp.isClosed()) {
            throw new SftpStatusException(7, "The SFTP connection has been closed");
        }
    }

    public void mkdir(String dir) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(dir);
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Creating dir " + dir);
        }
        try {
            this.sftp.getAttributes(actual);
        }
        catch (SftpStatusException ex) {
            SftpFileAttributes newattrs = new SftpFileAttributes(this.sftp, 2);
            newattrs.setPermissions(new UnsignedInteger32(0x1FF ^ this.umask));
            this.sftp.makeDirectory(actual, newattrs);
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug(this, "A file/folder with name " + dir + " already exists!");
        }
        throw new SftpStatusException(4, "File already exists named " + dir);
    }

    public void mkdirs(String dir) throws SftpStatusException, SshException {
        String path;
        StringTokenizer tokens = new StringTokenizer(dir, "/");
        String string = path = dir.startsWith("/") ? "/" : "";
        while (tokens.hasMoreElements()) {
            block5: {
                path = path + (String)tokens.nextElement();
                try {
                    this.stat(path);
                }
                catch (SftpStatusException ex) {
                    try {
                        this.mkdir(path);
                    }
                    catch (SftpStatusException ex2) {
                        if (ex2.getStatus() != 3) break block5;
                        throw ex2;
                    }
                }
            }
            path = path + "/";
        }
    }

    public boolean isDirectoryOrLinkedDirectory(SftpFile file) throws SftpStatusException, SshException {
        return file.isDirectory() || file.isLink() && this.stat(file.getAbsolutePath()).isDirectory();
    }

    public String pwd() {
        return this.cwd;
    }

    public SftpFile[] ls() throws SftpStatusException, SshException {
        return this.ls(this.cwd);
    }

    public SftpFile[] ls(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        if (Log.isDebugEnabled()) {
            Log.debug(this, "Listing files for " + actual);
        }
        SftpFile file = this.sftp.openDirectory(actual);
        Vector<SftpFile> children = new Vector<SftpFile>();
        while (this.sftp.listChildren(file, children) > -1) {
        }
        file.close();
        SftpFile[] files = new SftpFile[children.size()];
        int index = 0;
        Enumeration<SftpFile> e = children.elements();
        while (e.hasMoreElements()) {
            files[index++] = e.nextElement();
        }
        return files;
    }

    public void lcd(String path) throws SftpStatusException {
        File actual = !SftpClient.isLocalAbsolutePath(path) ? new File(this.lcwd, path) : new File(path);
        if (!actual.isDirectory()) {
            throw new SftpStatusException(4, path + " is not a directory");
        }
        try {
            this.lcwd = actual.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new SftpStatusException(4, "Failed to canonicalize path " + path);
        }
    }

    private static boolean isLocalAbsolutePath(String path) {
        return new File(path).isAbsolute();
    }

    public String lpwd() {
        return this.lcwd;
    }

    public SftpFileAttributes get(String path, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(path, progress, false);
    }

    public SftpFileAttributes get(String path, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String localfile = path.lastIndexOf("/") > -1 ? path.substring(path.lastIndexOf("/") + 1) : path;
        return this.get(path, localfile, progress, resume);
    }

    public SftpFileAttributes get(String path, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(path, (FileTransferProgress)null, resume);
    }

    public SftpFileAttributes get(String path) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(path, (FileTransferProgress)null);
    }

    public SftpFileAttributes get(String remote, String local, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, progress, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SftpFileAttributes get(String remote, String local, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        SftpFileAttributes inputStyle2;
        OutputStream out = null;
        SftpFileAttributes attrs = null;
        File localPath = this.resolveLocalPath(local);
        if (!localPath.exists()) {
            File parent = new File(localPath.getParent());
            parent.mkdirs();
        }
        if (localPath.isDirectory()) {
            int idx = remote.lastIndexOf(47);
            localPath = idx > -1 ? new File(localPath, remote.substring(idx)) : new File(localPath, remote);
        }
        this.stat(remote);
        long position = 0L;
        try {
            if (resume && localPath.exists()) {
                position = localPath.length();
                RandomAccessFile file = new RandomAccessFile(localPath, "rw");
                file.seek(position);
                out = new RandomAccessFileOutputStream(file);
            } else {
                out = new FileOutputStream(localPath);
            }
            if (this.transferMode == 2) {
                int inputStyle2 = this.eolMode;
                int outputStyle = 0;
                byte[] nl = null;
                if (this.sftp.getVersion() <= 3 && this.sftp.getExtension("newline@vandyke.com") != null) {
                    nl = this.sftp.getExtension("newline@vandyke.com");
                } else if (this.sftp.getVersion() > 3) {
                    nl = this.sftp.getCanonicalNewline();
                }
                if (nl != null) {
                    switch (nl.length) {
                        case 1: {
                            if (nl[0] == 13) {
                                inputStyle2 = 3;
                                break;
                            }
                            if (nl[0] != 10) throw new SftpStatusException(100, "Unsupported text mode: invalid newline character");
                            inputStyle2 = 2;
                            break;
                        }
                        case 2: {
                            if (nl[0] != 13) throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
                            if (nl[1] != 10) throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
                            inputStyle2 = 1;
                            break;
                        }
                        default: {
                            throw new SftpStatusException(100, "Unsupported text mode: newline length > 2");
                        }
                    }
                }
                out = EOLProcessor.createOutputStream(inputStyle2, outputStyle, out);
            }
            inputStyle2 = attrs = this.get(remote, out, progress, position);
        }
        catch (IOException ex) {
            try {
                throw new SftpStatusException(4, "Failed to open outputstream to " + local);
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (attrs == null) throw throwable;
                    Method m = localPath.getClass().getMethod("setLastModified", Long.TYPE);
                    m.invoke((Object)localPath, new Long(attrs.getModifiedTime().longValue() * 1000L));
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (out != null) {
                out.close();
            }
            if (attrs == null) return inputStyle2;
            Method m = localPath.getClass().getMethod("setLastModified", Long.TYPE);
            m.invoke((Object)localPath, new Long(attrs.getModifiedTime().longValue() * 1000L));
            return inputStyle2;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return inputStyle2;
    }

    public SftpFileAttributes get(String remote, String local, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, null, resume);
    }

    public SftpFileAttributes get(String remote, String local) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, false);
    }

    public SftpFileAttributes get(String remote, OutputStream local, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, progress, 0L);
    }

    public void setRegularExpressionSyntax(int syntax) {
        this.RegExpSyntax = syntax;
    }

    public SftpFile[] matchRemoteFiles(String remote) throws SftpStatusException, SshException {
        SftpFile[] files;
        RegularExpressionMatching matcher;
        String actualSearch;
        String actualDir;
        int fileSeparatorIndex = remote.lastIndexOf("/");
        if (fileSeparatorIndex > -1) {
            actualDir = remote.substring(0, fileSeparatorIndex);
            actualSearch = remote.length() > fileSeparatorIndex + 1 ? remote.substring(fileSeparatorIndex + 1) : "";
        } else {
            actualDir = this.cwd;
            actualSearch = remote;
        }
        switch (this.RegExpSyntax) {
            case 1: {
                matcher = new GlobRegExpMatching();
                files = this.ls(actualDir);
                break;
            }
            case 2: {
                matcher = new Perl5RegExpMatching();
                files = this.ls(actualDir);
                break;
            }
            default: {
                matcher = new NoRegExpMatching();
                files = new SftpFile[1];
                String actual = this.resolveRemotePath(remote);
                files[0] = this.getSubsystemChannel().getFile(actual);
            }
        }
        return matcher.matchFilesWithPattern(files, actualSearch);
    }

    private SftpFile[] getFileMatches(String remote, String local, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        SftpFile[] matchedFiles = this.matchRemoteFiles(remote);
        Vector<SftpFile> retrievedFiles = new Vector<SftpFile>();
        for (int i = 0; i < matchedFiles.length; ++i) {
            this.get(matchedFiles[i].getAbsolutePath(), local, progress, resume);
            retrievedFiles.addElement(matchedFiles[i]);
        }
        Object[] retrievedSftpFiles = new SftpFile[retrievedFiles.size()];
        retrievedFiles.copyInto(retrievedSftpFiles);
        return retrievedSftpFiles;
    }

    private String[] matchLocalFiles(String local) throws SftpStatusException, SshException {
        File[] files;
        RegularExpressionMatching matcher;
        String actualSearch;
        String actualDir;
        int fileSeparatorIndex = local.lastIndexOf(System.getProperty("file.separator"));
        if (fileSeparatorIndex > -1 || (fileSeparatorIndex = local.lastIndexOf(47)) > -1) {
            actualDir = this.resolveLocalPath(local.substring(0, fileSeparatorIndex)).getAbsolutePath();
            actualSearch = fileSeparatorIndex < local.length() - 1 ? local.substring(fileSeparatorIndex + 1) : "";
        } else {
            actualDir = this.lcwd;
            actualSearch = local;
        }
        switch (this.RegExpSyntax) {
            case 1: {
                File f = new File(actualDir);
                matcher = new GlobRegExpMatching();
                files = this.listFiles(f);
                break;
            }
            case 2: {
                File f = new File(actualDir);
                matcher = new Perl5RegExpMatching();
                files = this.listFiles(f);
                break;
            }
            default: {
                matcher = new NoRegExpMatching();
                files = new File[]{new File(local)};
            }
        }
        return matcher.matchFileNamesWithPattern(files, actualSearch);
    }

    private File[] listFiles(File f) {
        String parentDir = f.getAbsolutePath();
        String[] fileNames = f.list();
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new File(parentDir, fileNames[i]);
        }
        return files;
    }

    private void putFileMatches(String local, String remote, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = null;
        try {
            attrs = this.stat(remotePath);
        }
        catch (SftpStatusException ex) {
            throw new SftpStatusException(ex.getStatus(), "Remote path '" + remote + "' does not exist. It must be a valid directory and must already exist!");
        }
        if (!attrs.isDirectory()) {
            throw new SftpStatusException(10, "Remote path '" + remote + "' is not a directory!");
        }
        String[] matchedFiles = this.matchLocalFiles(local);
        for (int i = 0; i < matchedFiles.length; ++i) {
            try {
                this.put(matchedFiles[i], remotePath, progress, resume);
                continue;
            }
            catch (SftpStatusException ex) {
                throw new SftpStatusException(ex.getStatus(), "Failed to put " + matchedFiles[i] + " to " + remote + " [" + ex.getMessage() + "]");
            }
        }
    }

    public SftpFileAttributes get(String remote, OutputStream local, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = this.sftp.getAttributes(remotePath);
        if (position > attrs.getSize().longValue()) {
            throw new SftpStatusException(101, "The local file size is greater than the remote file");
        }
        if (progress != null) {
            progress.started(attrs.getSize().longValue() - position, remotePath);
        }
        SftpFile file = this.transferMode == 2 && this.sftp.getVersion() > 3 ? this.sftp.openFile(remotePath, 65) : this.sftp.openFile(remotePath, 1);
        try {
            this.sftp.performOptimizedRead(file.getHandle(), attrs.getSize().longValue(), this.blocksize, local, this.asyncRequests, progress, position);
        }
        catch (TransferCancelledException tce) {
            throw tce;
        }
        finally {
            try {
                local.close();
            }
            catch (Throwable throwable) {}
            try {
                this.sftp.closeFile(file);
            }
            catch (SftpStatusException sftpStatusException) {}
        }
        if (progress != null) {
            progress.completed();
        }
        return attrs;
    }

    public InputStream getInputStream(String remotefile, long position) throws SftpStatusException, SshException {
        String remotePath = this.resolveRemotePath(remotefile);
        this.sftp.getAttributes(remotePath);
        return new SftpFileInputStream(this.sftp.openFile(remotePath, 1), position);
    }

    public InputStream getInputStream(String remotefile) throws SftpStatusException, SshException {
        return this.getInputStream(remotefile, 0L);
    }

    public SftpFileAttributes get(String remote, OutputStream local, long position) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, null, position);
    }

    public SftpFileAttributes get(String remote, OutputStream local) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, null, 0L);
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void put(String local, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        File f = new File(local);
        this.put(local, f.getName(), progress, resume);
    }

    public void put(String local, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(local, progress, false);
    }

    public void put(String local) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(local, false);
    }

    public void put(String local, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(local, (FileTransferProgress)null, resume);
    }

    public void put(String local, String remote, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(local, remote, progress, false);
    }

    public void put(String local, String remote, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        long position;
        FileInputStream in;
        block10: {
            File localPath = this.resolveLocalPath(local);
            in = new FileInputStream(localPath);
            position = 0L;
            try {
                SftpFileAttributes attrs = this.stat(remote);
                if (attrs.isDirectory()) {
                    remote = remote + (remote.endsWith("/") ? "" : "/") + localPath.getName();
                    attrs = this.stat(remote);
                }
                if (!resume) break block10;
                if (localPath.length() <= attrs.getSize().longValue()) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new SftpStatusException(101, "The remote file size is greater than the local file");
                }
                try {
                    position = attrs.getSize().longValue();
                    ((InputStream)in).skip(position);
                }
                catch (IOException ex) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new SftpStatusException(2, ex.getMessage());
                }
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
        }
        this.put(in, remote, progress, position);
    }

    public void put(String local, String remote, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(local, remote, null, resume);
    }

    public void put(String local, String remote) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.put(local, remote, null, false);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, progress, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(InputStream in, String remote, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        SftpFile file;
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = null;
        if (this.transferMode == 2) {
            int inputStyle = 0;
            int outputStyle = this.eolMode;
            byte[] nl = null;
            if (this.sftp.getVersion() <= 3 && this.sftp.getExtension("newline@vandyke.com") != null) {
                nl = this.sftp.getExtension("newline@vandyke.com");
            } else if (this.sftp.getVersion() > 3) {
                nl = this.sftp.getCanonicalNewline();
            }
            if (nl != null) {
                switch (nl.length) {
                    case 1: {
                        if (nl[0] == 13) {
                            outputStyle = 3;
                            break;
                        }
                        if (nl[0] == 10) {
                            outputStyle = 2;
                            break;
                        }
                        throw new SftpStatusException(100, "Unsupported text mode: invalid newline character");
                    }
                    case 2: {
                        if (nl[0] == 13 && nl[1] == 10) {
                            outputStyle = 1;
                            break;
                        }
                        throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
                    }
                    default: {
                        throw new SftpStatusException(100, "Unsupported text mode: newline length > 2");
                    }
                }
            }
            try {
                in = EOLProcessor.createInputStream(inputStyle, outputStyle, in);
            }
            catch (IOException ex) {
                throw new SshException("Failed to create EOL processing stream", 5);
            }
        }
        attrs = new SftpFileAttributes(this.sftp, 1);
        attrs.setPermissions(new UnsignedInteger32(0x1B6 ^ this.umask));
        if (position > 0L) {
            if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
                throw new SftpStatusException(8, "Resume on text mode files is not supported");
            }
            file = this.sftp.openFile(remotePath, 6, attrs);
        } else {
            file = this.transferMode == 2 && this.sftp.getVersion() > 3 ? this.sftp.openFile(remotePath, 90, attrs) : this.sftp.openFile(remotePath, 26, attrs);
        }
        if (progress != null) {
            try {
                progress.started(in.available(), remotePath);
            }
            catch (IOException ex1) {
                throw new SshException("Failed to determine local file size", 5);
            }
        }
        try {
            this.sftp.performOptimizedWrite(file.getHandle(), this.blocksize, this.asyncRequests, in, this.buffersize, progress, position);
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
            this.sftp.closeFile(file);
        }
        if (progress != null) {
            progress.completed();
        }
    }

    public OutputStream getOutputStream(String remotefile) throws SftpStatusException, SshException {
        String remotePath = this.resolveRemotePath(remotefile);
        return new SftpFileOutputStream(this.sftp.openFile(remotePath, 26));
    }

    public void put(InputStream in, String remote, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, position);
    }

    public void put(InputStream in, String remote) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, 0L);
    }

    public void chown(String uid, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        attrs.setUID(uid);
        this.sftp.setAttributes(actual, attrs);
    }

    public void chgrp(String gid, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        attrs.setGID(gid);
        this.sftp.setAttributes(actual, attrs);
    }

    public void chmod(int permissions, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        this.sftp.changePermissions(actual, permissions);
    }

    public void umask(String umask) throws SshException {
        try {
            this.umask = Integer.parseInt(umask, 8);
        }
        catch (NumberFormatException ex) {
            throw new SshException("umask must be 4 digit octal number e.g. 0022", 4);
        }
    }

    public void rename(String oldpath, String newpath) throws SftpStatusException, SshException {
        String from = this.resolveRemotePath(oldpath);
        String to = this.resolveRemotePath(newpath);
        SftpFileAttributes attrs = null;
        try {
            attrs = this.sftp.getAttributes(to);
        }
        catch (SftpStatusException ex) {
            this.sftp.renameFile(from, to);
            return;
        }
        if (attrs == null || !attrs.isDirectory()) {
            throw new SftpStatusException(11, newpath + " already exists on the remote filesystem");
        }
        this.sftp.renameFile(from, to);
    }

    public void rm(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void rm(String path, boolean force, boolean recurse) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = null;
        attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            SftpFile[] list = this.ls(path);
            if (!force && list.length > 0) {
                throw new SftpStatusException(4, "You cannot delete non-empty directory, use force=true to overide");
            }
            for (int i = 0; i < list.length; ++i) {
                SftpFile file = list[i];
                if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                    if (recurse) {
                        this.rm(file.getAbsolutePath(), force, recurse);
                        continue;
                    }
                    throw new SftpStatusException(4, "Directory has contents, cannot delete without recurse=true");
                }
                if (!file.isFile()) continue;
                this.sftp.removeFile(file.getAbsolutePath());
            }
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void symlink(String path, String link) throws SftpStatusException, SshException {
        String actualPath = this.resolveRemotePath(path);
        String actualLink = this.resolveRemotePath(link);
        this.sftp.createSymbolicLink(actualLink, actualPath);
    }

    public SftpFileAttributes stat(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAttributes(actual);
    }

    public SftpFileAttributes statLink(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getLinkAttributes(actual);
    }

    public String getAbsolutePath(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAbsolutePath(actual);
    }

    public void quit() throws SshException {
        try {
            this.sftp.close();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex1) {
            throw new SshException(ex1.getMessage(), 6);
        }
    }

    public void exit() throws SshException {
        try {
            this.sftp.close();
        }
        catch (SshIOException ex) {
            throw ex.getRealException();
        }
        catch (IOException ex1) {
            throw new SshException(ex1.getMessage(), 6);
        }
    }

    public DirectoryOperation copyLocalDirectory(String localdir, String remotedir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String[] ls;
        DirectoryOperation op = new DirectoryOperation();
        File local = this.resolveLocalPath(localdir);
        remotedir = this.resolveRemotePath(remotedir);
        remotedir = remotedir + (remotedir.endsWith("/") ? "" : "/");
        if (commit) {
            try {
                this.sftp.getAttributes(remotedir);
            }
            catch (SftpStatusException ex) {
                this.mkdirs(remotedir);
            }
        }
        if ((ls = local.list()) != null) {
            for (int i = 0; i < ls.length; ++i) {
                SftpFileAttributes attrs;
                File source = new File(local, ls[i]);
                if (source.isDirectory() && !source.getName().equals(".") && !source.getName().equals("..")) {
                    if (!recurse) continue;
                    op.addDirectoryOperation(this.copyLocalDirectory(source.getAbsolutePath(), remotedir + source.getName(), recurse, sync, commit, progress), source);
                    continue;
                }
                if (!source.isFile()) continue;
                boolean newFile = false;
                boolean unchangedFile = false;
                try {
                    attrs = this.sftp.getAttributes(remotedir + source.getName());
                    unchangedFile = source.length() == attrs.getSize().longValue() && source.lastModified() / 1000L == attrs.getModifiedTime().longValue();
                }
                catch (SftpStatusException ex) {
                    newFile = true;
                }
                try {
                    if (commit && !unchangedFile) {
                        this.put(source.getAbsolutePath(), remotedir + source.getName(), progress);
                        attrs = this.sftp.getAttributes(remotedir + source.getName());
                        attrs.setTimes(new UnsignedInteger64(source.lastModified() / 1000L), new UnsignedInteger64(source.lastModified() / 1000L));
                        this.sftp.setAttributes(remotedir + source.getName(), attrs);
                    }
                    if (unchangedFile) {
                        op.addUnchangedFile(source);
                        continue;
                    }
                    if (!newFile) {
                        op.addUpdatedFile(source);
                        continue;
                    }
                    op.addNewFile(source);
                    continue;
                }
                catch (SftpStatusException ex) {
                    op.addFailedTransfer(source, ex);
                }
            }
        }
        if (sync) {
            try {
                SftpFile[] files = this.ls(remotedir);
                for (int i = 0; i < files.length; ++i) {
                    SftpFile file = files[i];
                    File f = new File(local, file.getFilename());
                    if (op.containsFile(f) || file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
                    op.addDeletedFile(file);
                    if (!commit) continue;
                    if (file.isDirectory()) {
                        this.recurseMarkForDeletion(file, op);
                        if (!commit) continue;
                        this.rm(file.getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    this.rm(file.getAbsolutePath());
                }
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
        }
        return op;
    }

    private void recurseMarkForDeletion(SftpFile file, DirectoryOperation op) throws SftpStatusException, SshException {
        SftpFile[] list = this.ls(file.getAbsolutePath());
        op.addDeletedFile(file);
        for (int i = 0; i < list.length; ++i) {
            file = list[i];
            if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                this.recurseMarkForDeletion(file, op);
                continue;
            }
            if (!file.isFile()) continue;
            op.addDeletedFile(file);
        }
    }

    private void recurseMarkForDeletion(File file, DirectoryOperation op) throws SftpStatusException, SshException {
        String[] list = file.list();
        op.addDeletedFile(file);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                file = new File(list[i]);
                if (file.isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.recurseMarkForDeletion(file, op);
                    continue;
                }
                if (!file.isFile()) continue;
                op.addDeletedFile(file);
            }
        }
    }

    public static String formatLongname(SftpFile file) throws SftpStatusException, SshException {
        return SftpClient.formatLongname(file.getAttributes(), file.getFilename());
    }

    public static String formatLongname(SftpFileAttributes attrs, String filename) {
        StringBuffer str = new StringBuffer();
        str.append(SftpClient.pad(10 - attrs.getPermissionsString().length()) + attrs.getPermissionsString());
        str.append("    1 ");
        str.append(attrs.getUID() + SftpClient.pad(8 - attrs.getUID().length()));
        str.append(" ");
        str.append(attrs.getGID() + SftpClient.pad(8 - attrs.getGID().length()));
        str.append(" ");
        str.append(SftpClient.pad(8 - attrs.getSize().toString().length()) + attrs.getSize().toString());
        str.append(" ");
        str.append(SftpClient.pad(12 - SftpClient.getModTimeString(attrs.getModifiedTime()).length()) + SftpClient.getModTimeString(attrs.getModifiedTime()));
        str.append(" ");
        str.append(filename);
        return str.toString();
    }

    private static String getModTimeString(UnsignedInteger64 mtime) {
        if (mtime == null) {
            return "";
        }
        long mt = mtime.longValue() * 1000L;
        long now = System.currentTimeMillis();
        SimpleDateFormat df = now - mt > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return df.format(new Date(mt));
    }

    private static String pad(int num) {
        StringBuffer strBuf = new StringBuffer("");
        if (num > 0) {
            for (int i = 0; i < num; ++i) {
                strBuf.append(" ");
            }
        }
        return strBuf.toString();
    }

    public DirectoryOperation copyRemoteDirectory(String remotedir, String localdir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        String[] contents;
        File local;
        int idx;
        DirectoryOperation op = new DirectoryOperation();
        String pwd = this.pwd();
        this.cd(remotedir);
        String base = remotedir;
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        if ((idx = base.lastIndexOf(47)) != -1) {
            base = base.substring(idx + 1);
        }
        if (!(local = new File(localdir)).isAbsolute()) {
            local = new File(this.lpwd(), localdir);
        }
        if (!local.exists() && commit) {
            local.mkdir();
        }
        SftpFile[] files = this.ls();
        for (int i = 0; i < files.length; ++i) {
            File f;
            SftpFile file = files[i];
            if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                if (!recurse) continue;
                f = new File(local, file.getFilename());
                op.addDirectoryOperation(this.copyRemoteDirectory(file.getFilename(), local.getAbsolutePath() + "/" + file.getFilename(), recurse, sync, commit, progress), f);
                continue;
            }
            if (!file.isFile()) continue;
            f = new File(local, file.getFilename());
            if (f.exists() && f.length() == file.getAttributes().getSize().longValue() && f.lastModified() / 1000L == file.getAttributes().getModifiedTime().longValue()) {
                if (commit) {
                    op.addUnchangedFile(f);
                    continue;
                }
                op.addUnchangedFile(file);
                continue;
            }
            try {
                if (f.exists()) {
                    if (commit) {
                        op.addUpdatedFile(f);
                    } else {
                        op.addUpdatedFile(file);
                    }
                } else if (commit) {
                    op.addNewFile(f);
                } else {
                    op.addNewFile(file);
                }
                if (!commit) continue;
                this.get(file.getFilename(), f.getAbsolutePath(), progress);
                continue;
            }
            catch (SftpStatusException ex) {
                op.addFailedTransfer(f, ex);
            }
        }
        if (sync && (contents = local.list()) != null) {
            for (int i = 0; i < contents.length; ++i) {
                File f2 = new File(local, contents[i]);
                if (op.containsFile(f2)) continue;
                op.addDeletedFile(f2);
                if (f2.isDirectory() && !f2.getName().equals(".") && !f2.getName().equals("..")) {
                    this.recurseMarkForDeletion(f2, op);
                    if (!commit) continue;
                    IOUtil.recurseDeleteDirectory(f2);
                    continue;
                }
                if (!commit) continue;
                f2.delete();
            }
        }
        this.cd(pwd);
        return op;
    }

    public SftpFile[] getFiles(String remote) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(remote, (FileTransferProgress)null);
    }

    public SftpFile[] getFiles(String remote, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(remote, (FileTransferProgress)null, resume);
    }

    public SftpFile[] getFiles(String remote, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(remote, progress, false);
    }

    public SftpFile[] getFiles(String remote, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(remote, this.lcwd, progress, resume);
    }

    public SftpFile[] getFiles(String remote, String local) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(remote, local, false);
    }

    public SftpFile[] getFiles(String remote, String local, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFiles(remote, local, null, resume);
    }

    public SftpFile[] getFiles(String remote, String local, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        return this.getFileMatches(remote, local, progress, resume);
    }

    public void putFiles(String local) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(local, false);
    }

    public void putFiles(String local, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(local, (FileTransferProgress)null, resume);
    }

    public void putFiles(String local, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(local, progress, false);
    }

    public void putFiles(String local, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(local, this.pwd(), progress, resume);
    }

    public void putFiles(String local, String remote) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(local, remote, null, false);
    }

    public void putFiles(String local, String remote, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(local, remote, null, resume);
    }

    public void putFiles(String local, String remote, FileTransferProgress progress) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFiles(local, remote, progress, false);
    }

    public void putFiles(String local, String remote, FileTransferProgress progress, boolean resume) throws FileNotFoundException, SftpStatusException, SshException, TransferCancelledException {
        this.putFileMatches(local, remote, progress, resume);
    }

    static class RandomAccessFileOutputStream
    extends OutputStream {
        RandomAccessFile file;

        RandomAccessFileOutputStream(RandomAccessFile file) {
            this.file = file;
        }

        public void write(int b) throws IOException {
            this.file.write(b);
        }

        public void write(byte[] buf, int off, int len) throws IOException {
            this.file.write(buf, off, len);
        }

        public void close() throws IOException {
            this.file.close();
        }
    }
}

