/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.sftp;

import com.sshtools.sftp.RegularExpressionMatching;
import com.sshtools.sftp.SftpFile;
import com.sshtools.sftp.SftpStatusException;
import com.sshtools.ssh.SshException;
import java.io.File;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class Perl5RegExpMatching
implements RegularExpressionMatching {
    public String[] matchFileNamesWithPattern(File[] files, String fileNameRegExp) throws SshException {
        Pattern mpattern = null;
        Perl5Compiler aPCompiler = new Perl5Compiler();
        Perl5Matcher aPerl5Matcher = new Perl5Matcher();
        try {
            mpattern = aPCompiler.compile(fileNameRegExp);
        }
        catch (MalformedPatternException e) {
            throw new SshException("Invalid regular expression:" + e.getMessage(), 4);
        }
        Vector<String> matchedNames = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".") || files[i].getName().equals("..") || files[i].isDirectory() || !aPerl5Matcher.matches(files[i].getName(), mpattern)) continue;
            matchedNames.addElement(files[i].getName());
        }
        Object[] matchedNamesStrings = new String[matchedNames.size()];
        matchedNames.copyInto(matchedNamesStrings);
        return matchedNamesStrings;
    }

    public SftpFile[] matchFilesWithPattern(SftpFile[] files, String fileNameRegExp) throws SftpStatusException, SshException {
        Pattern mpattern = null;
        Perl5Compiler aPCompiler = new Perl5Compiler();
        Perl5Matcher aPerl5Matcher = new Perl5Matcher();
        try {
            mpattern = aPCompiler.compile(fileNameRegExp);
        }
        catch (MalformedPatternException e) {
            throw new SshException("Invalid regular expression:" + e.getMessage(), 4);
        }
        Vector<SftpFile> matchedNames = new Vector<SftpFile>();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getFilename().equals(".") || files[i].getFilename().equals("..") || files[i].isDirectory() || !aPerl5Matcher.matches(files[i].getFilename(), mpattern)) continue;
            matchedNames.addElement(files[i]);
        }
        Object[] matchedNamesSftpFiles = new SftpFile[matchedNames.size()];
        matchedNames.copyInto(matchedNamesSftpFiles);
        return matchedNamesSftpFiles;
    }
}

