/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.sshtools.publickey.Base64EncodedFileFormat;
import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.OpenSSHPrivateKeyFile;
import com.sshtools.publickey.PuTTYPrivateKeyFile;
import com.sshtools.publickey.SSHCOMPrivateKeyFile;
import com.sshtools.publickey.SshPrivateKeyFile;
import com.sshtools.publickey.SshtoolsPrivateKeyFile;
import com.sshtools.ssh.components.SshKeyPair;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPrivateKeyFileFactory {
    public static final int OPENSSH_FORMAT = 0;
    public static final int SSHTOOLS_FORMAT = 1;

    public static SshPrivateKeyFile parse(byte[] formattedkey) throws IOException {
        try {
            if (OpenSSHPrivateKeyFile.isFormatted(formattedkey)) {
                return new OpenSSHPrivateKeyFile(formattedkey);
            }
            if (Base64EncodedFileFormat.isFormatted(formattedkey, SshtoolsPrivateKeyFile.BEGIN, SshtoolsPrivateKeyFile.END)) {
                return new SshtoolsPrivateKeyFile(formattedkey);
            }
            if (PuTTYPrivateKeyFile.isFormatted(formattedkey)) {
                return new PuTTYPrivateKeyFile(formattedkey);
            }
            if (SSHCOMPrivateKeyFile.isFormatted(formattedkey)) {
                return new SSHCOMPrivateKeyFile(formattedkey);
            }
            throw new IOException("A suitable key format could not be found!");
        }
        catch (OutOfMemoryError ex) {
            throw new IOException("An error occurred parsing a private key file! Is the file corrupt?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPrivateKeyFile parse(InputStream in) throws IOException {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((read = in.read()) > -1) {
                out.write(read);
            }
            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFileFactory.parse(out.toByteArray());
            return sshPrivateKeyFile;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static SshPrivateKeyFile create(SshKeyPair pair, String passphrase, String comment, int format) throws IOException {
        switch (format) {
            case 0: {
                return new OpenSSHPrivateKeyFile(pair, passphrase);
            }
            case 1: {
                return new SshtoolsPrivateKeyFile(pair, passphrase, comment);
            }
        }
        throw new IOException("Invalid key format!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(SshKeyPair key, String passphrase, String comment, int format, File toFile) throws IOException {
        SshPrivateKeyFile pub = SshPrivateKeyFileFactory.create(key, passphrase, comment, format);
        FileOutputStream out = new FileOutputStream(toFile);
        try {
            out.write(pub.getFormattedKey());
            out.flush();
        }
        finally {
            out.close();
        }
    }

    public static void convertFile(File keyFile, String passphrase, String comment, int toFormat, File toFile) throws IOException, InvalidPassphraseException {
        SshPrivateKeyFile pub = SshPrivateKeyFileFactory.parse(new FileInputStream(keyFile));
        SshPrivateKeyFileFactory.createFile(pub.toKeyPair(passphrase), passphrase, comment, toFormat, toFile);
    }
}

