/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.sshtools.publickey.SshPublicKeyFile;
import com.sshtools.publickey.SshPublicKeyFileFactory;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.components.SshPublicKey;
import com.sshtools.util.Base64;
import java.io.IOException;

public class OpenSSHPublicKeyFile
implements SshPublicKeyFile {
    byte[] formattedkey;
    String comment;

    OpenSSHPublicKeyFile(byte[] formattedkey) throws IOException {
        this.formattedkey = formattedkey;
        this.toPublicKey();
    }

    OpenSSHPublicKeyFile(SshPublicKey key, String comment) throws IOException {
        try {
            String formatted = key.getAlgorithm() + " " + Base64.encodeBytes(key.getEncoded(), true);
            if (comment != null) {
                formatted = formatted + " " + comment;
            }
            this.formattedkey = formatted.getBytes();
        }
        catch (SshException ex) {
            throw new IOException("Failed to encode public key");
        }
    }

    public String toString() {
        return new String(this.formattedkey);
    }

    public byte[] getFormattedKey() {
        return this.formattedkey;
    }

    public SshPublicKey toPublicKey() throws IOException {
        String temp = new String(this.formattedkey);
        int i = temp.indexOf(" ");
        if (i > 0) {
            String algorithm = temp.substring(0, i);
            int i2 = temp.indexOf(" ", i + 1);
            if (i2 != -1) {
                String encoded = temp.substring(i + 1, i2);
                if (temp.length() > i2) {
                    this.comment = temp.substring(i2 + 1).trim();
                }
                return SshPublicKeyFileFactory.decodeSSH2PublicKey(algorithm, Base64.decode(encoded));
            }
            String encoded = temp.substring(i + 1);
            return SshPublicKeyFileFactory.decodeSSH2PublicKey(algorithm, Base64.decode(encoded));
        }
        throw new IOException("Key format not supported!");
    }

    public String getComment() {
        return this.comment;
    }
}

