/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.PEMReader;
import com.sshtools.publickey.PEMWriter;
import com.sshtools.publickey.SshPrivateKeyFile;
import com.sshtools.ssh.SshException;
import com.sshtools.ssh.SshIOException;
import com.sshtools.ssh.components.ComponentManager;
import com.sshtools.ssh.components.SshDsaPrivateKey;
import com.sshtools.ssh.components.SshDsaPublicKey;
import com.sshtools.ssh.components.SshKeyPair;
import com.sshtools.ssh.components.SshRsaPrivateCrtKey;
import com.sshtools.util.SimpleASNReader;
import com.sshtools.util.SimpleASNWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;

class OpenSSHPrivateKeyFile
implements SshPrivateKeyFile {
    byte[] formattedkey;

    OpenSSHPrivateKeyFile(byte[] formattedkey) throws IOException {
        if (!OpenSSHPrivateKeyFile.isFormatted(formattedkey)) {
            throw new IOException("Formatted key data is not a valid OpenSSH key format");
        }
        this.formattedkey = formattedkey;
    }

    OpenSSHPrivateKeyFile(SshKeyPair pair, String passphrase) throws IOException {
        this.formattedkey = this.encryptKey(pair, passphrase);
    }

    public boolean isPassphraseProtected() {
        try {
            StringReader r = new StringReader(new String(this.formattedkey, "US-ASCII"));
            PEMReader pem = new PEMReader(r);
            return pem.getHeader().containsKey("DEK-Info");
        }
        catch (IOException e) {
            return true;
        }
    }

    public String getType() {
        return "OpenSSH";
    }

    public boolean supportsPassphraseChange() {
        return true;
    }

    public SshKeyPair toKeyPair(String passphrase) throws IOException, InvalidPassphraseException {
        StringReader r = new StringReader(new String(this.formattedkey, "US-ASCII"));
        PEMReader pem = new PEMReader(r);
        byte[] payload = pem.decryptPayload(passphrase);
        SimpleASNReader asn = new SimpleASNReader(payload);
        try {
            if ("DSA PRIVATE KEY".equals(pem.getType())) {
                return this.getDSAKeyPair(asn);
            }
            if ("RSA PRIVATE KEY".equals(pem.getType())) {
                return this.getRSAKeyPair(asn);
            }
            throw new IOException("Unsupported type: " + pem.getType());
        }
        catch (IOException ex) {
            throw new InvalidPassphraseException(ex);
        }
    }

    SshKeyPair getRSAKeyPair(SimpleASNReader asn) throws IOException {
        try {
            asn.assertByte(48);
            asn.getLength();
            asn.assertByte(2);
            asn.getData();
            asn.assertByte(2);
            BigInteger modulus = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger publicExponent = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger privateExponent = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger primeP = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger primeQ = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger primeExponentP = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger primeExponentQ = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger crtCoefficient = new BigInteger(asn.getData());
            SshKeyPair pair = new SshKeyPair();
            pair.setPublicKey(ComponentManager.getInstance().createRsaPublicKey(modulus, publicExponent));
            pair.setPrivateKey(ComponentManager.getInstance().createRsaPrivateCrtKey(modulus, publicExponent, privateExponent, primeP, primeQ, primeExponentP, primeExponentQ, crtCoefficient));
            return pair;
        }
        catch (SshException e) {
            throw new SshIOException(e);
        }
    }

    SshKeyPair getDSAKeyPair(SimpleASNReader asn) throws IOException {
        try {
            asn.assertByte(48);
            asn.getLength();
            asn.assertByte(2);
            asn.getData();
            asn.assertByte(2);
            BigInteger p = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger q = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger g = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger y = new BigInteger(asn.getData());
            asn.assertByte(2);
            BigInteger x = new BigInteger(asn.getData());
            SshKeyPair pair = new SshKeyPair();
            SshDsaPublicKey pub = ComponentManager.getInstance().createDsaPublicKey(p, q, g, y);
            pair.setPublicKey(pub);
            pair.setPrivateKey(ComponentManager.getInstance().createDsaPrivateKey(p, q, g, x, pub.getY()));
            return pair;
        }
        catch (SshException e) {
            throw new SshIOException(e);
        }
    }

    void writeDSAKeyPair(SimpleASNWriter asn, SshDsaPrivateKey privatekey, SshDsaPublicKey publickey) {
        SimpleASNWriter asn2 = new SimpleASNWriter();
        asn2.writeByte(2);
        byte[] version = new byte[1];
        asn2.writeData(version);
        asn2.writeByte(2);
        asn2.writeData(publickey.getP().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(publickey.getQ().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(publickey.getG().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(publickey.getY().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getX().toByteArray());
        byte[] dsaKeyEncoded = asn2.toByteArray();
        asn.writeByte(48);
        asn.writeData(dsaKeyEncoded);
    }

    void writeRSAKeyPair(SimpleASNWriter asn, SshRsaPrivateCrtKey privatekey) {
        SimpleASNWriter asn2 = new SimpleASNWriter();
        asn2.writeByte(2);
        byte[] version = new byte[1];
        asn2.writeData(version);
        asn2.writeByte(2);
        asn2.writeData(privatekey.getModulus().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getPublicExponent().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getPrivateExponent().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getPrimeP().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getPrimeQ().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getPrimeExponentP().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getPrimeExponentQ().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(privatekey.getCrtCoefficient().toByteArray());
        byte[] rsaKeyEncoded = asn2.toByteArray();
        asn.writeByte(48);
        asn.writeData(rsaKeyEncoded);
    }

    public byte[] encryptKey(SshKeyPair pair, String passphrase) throws IOException {
        byte[] payload;
        PEMWriter pem = new PEMWriter();
        SimpleASNWriter asn = new SimpleASNWriter();
        if (pair.getPublicKey() instanceof SshDsaPublicKey) {
            this.writeDSAKeyPair(asn, (SshDsaPrivateKey)pair.getPrivateKey(), (SshDsaPublicKey)pair.getPublicKey());
            payload = asn.toByteArray();
            pem.setType("DSA PRIVATE KEY");
        } else if (pair.getPrivateKey() instanceof SshRsaPrivateCrtKey) {
            this.writeRSAKeyPair(asn, (SshRsaPrivateCrtKey)pair.getPrivateKey());
            payload = asn.toByteArray();
            pem.setType("RSA PRIVATE KEY");
        } else {
            throw new IOException(pair.getPublicKey().getAlgorithm() + " is not supported");
        }
        pem.encryptPayload(payload, passphrase);
        StringWriter w = new StringWriter();
        pem.write(w);
        return w.toString().getBytes("UTF-8");
    }

    public void changePassphrase(String oldpassphrase, String newpassphrase) throws IOException, InvalidPassphraseException {
        SshKeyPair pair = this.toKeyPair(oldpassphrase);
        this.formattedkey = this.encryptKey(pair, newpassphrase);
    }

    public byte[] getFormattedKey() {
        return this.formattedkey;
    }

    public static boolean isFormatted(byte[] formattedkey) {
        try {
            StringReader r = new StringReader(new String(formattedkey, "UTF-8"));
            new PEMReader(r);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

