/*
 * Decompiled with CFR 0.152.
 */
package com.quec.until;

import com.quec.client.ClientHelper;
import com.quec.model.OkHttpRequest;
import com.quec.model.OkRequestBody;
import com.quec.until.Common;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClientUtil {
    private static String composeUrl(OkHttpRequest request) {
        Map<String, String> queries = request.query;
        String host = request.headers.get("host");
        String protocol = null == request.protocol ? "https" : request.protocol;
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(protocol);
        urlBuilder.append("://").append(host);
        if (null != request.parth) {
            String pathname = request.pathname;
            Map<String, String> parthMap = request.parth;
            for (Map.Entry<String, String> m : parthMap.entrySet()) {
                pathname = pathname.replaceAll("\\{" + m.getKey() + "}", m.getValue());
            }
            urlBuilder.append(pathname);
        }
        if (queries != null && queries.size() > 0) {
            if (urlBuilder.indexOf("?") >= 1) {
                urlBuilder.append("&");
            } else {
                urlBuilder.append("?");
            }
            try {
                for (Map.Entry<String, String> entry : queries.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue() + "";
                    if (val == null || "null".equals(val)) continue;
                    urlBuilder.append(URLEncoder.encode(key, "UTF-8"));
                    urlBuilder.append("=");
                    urlBuilder.append(URLEncoder.encode(val, "UTF-8"));
                    urlBuilder.append("&");
                }
            }
            catch (Exception var9) {
                throw new RuntimeException(var9.getMessage(), var9);
            }
            int strIndex = urlBuilder.length();
            urlBuilder.deleteCharAt(strIndex - 1);
        }
        return urlBuilder.toString();
    }

    private static Request getOkRequest(OkHttpRequest request, URL url) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        Map<String, String> headers = request.headers;
        for (String headerName : headers.keySet()) {
            requestBuilder.header(headerName, headers.get(headerName));
        }
        switch (request.method) {
            case "GET": {
                requestBuilder.get();
                break;
            }
            case "POST": {
                OkRequestBody requestBody = new OkRequestBody(request);
                requestBuilder.post((RequestBody)requestBody);
                break;
            }
            case "PUT": {
                OkRequestBody requestBody = new OkRequestBody(request);
                requestBuilder.put((RequestBody)requestBody);
                break;
            }
            case "DELETE": {
                OkRequestBody requestBody = new OkRequestBody(request);
                requestBuilder.delete((RequestBody)requestBody);
                break;
            }
            default: {
                requestBuilder.get();
            }
        }
        return requestBuilder.build();
    }

    public static String doAction(OkHttpRequest request, Map<String, Object> runtimeOptions) {
        Response response = null;
        try {
            String rep;
            String urlString = HttpClientUtil.composeUrl(request);
            URL url = new URL(urlString);
            OkHttpClient okHttpClient = ClientHelper.getOkHttpClient(url.getHost(), url.getPort(), runtimeOptions);
            response = okHttpClient.newCall(HttpClientUtil.getOkRequest(request, url)).execute();
            String string = rep = response.body().string();
            return string;
        }
        catch (Exception var8) {
            throw new RuntimeException(var8);
        }
        finally {
            if (!Common.isNull(response)) {
                response.close();
            }
        }
    }
}

