/*
 * Decompiled with CFR 0.152.
 */
package com.quec.until;

import com.alibaba.fastjson.JSONObject;
import com.quec.annotation.KeyNameInMap;
import com.quec.annotation.ParameterMode;
import com.quec.annotation.RequestParamType;
import com.quec.exception.CommonUtilException;
import com.quec.exception.ValidateException;
import com.quec.model.BasicsModel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Common {
    public static boolean stringIsEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isEmpty(Object object) {
        return null != object ? Common.isEmpty(String.valueOf(object)) : true;
    }

    public static boolean isNull(Object object) {
        return null == object;
    }

    public static void validateModel(BasicsModel m) {
        if (null == m) {
            throw new ValidateException("parameter is not allowed as null");
        }
        try {
            m.validate();
        }
        catch (Exception var2) {
            throw new ValidateException(var2.getMessage(), var2);
        }
    }

    public static Map<String, Object> toMap(BasicsModel in) {
        try {
            return BasicsModel.toMap(in);
        }
        catch (Exception var2) {
            throw new CommonUtilException(var2.getMessage(), var2);
        }
    }

    public static <T> Map<String, T> buildMap(Map<String, Object> map, BasicsModel m) {
        HashMap<String, Object> allmap = new HashMap<String, Object>();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        Object bodyObj = null;
        HashMap<String, Object> parthMap = new HashMap<String, Object>();
        HashMap<String, Object> headMaps = new HashMap<String, Object>();
        if (m != null) {
            Field[] fields = m.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                String parameterMode;
                String key;
                String queryType;
                Field field = fields[i];
                KeyNameInMap anno = field.getAnnotation(KeyNameInMap.class);
                if (anno == null) {
                    queryType = RequestParamType.query.toString();
                    key = field.getName();
                    parameterMode = ParameterMode.object.toString();
                } else {
                    queryType = anno.queryType().toString();
                    key = anno.value();
                    parameterMode = anno.parameterMode().toString();
                }
                if (RequestParamType.query.toString().equals(queryType)) {
                    queryMap.put(key, map.get(key));
                    continue;
                }
                if (RequestParamType.body.toString().equals(queryType)) {
                    if (Common.equalString(parameterMode, ParameterMode.array.toString())) {
                        bodyObj = map.get(key);
                        continue;
                    }
                    bodyMap.put(key, map.get(key));
                    continue;
                }
                if (RequestParamType.parth.toString().equals(queryType)) {
                    parthMap.put(key, map.get(key));
                    continue;
                }
                if (RequestParamType.headers.toString().equals(queryType)) {
                    headMaps.put(key, map.get(key));
                    continue;
                }
                queryMap.put(key, map.get(key));
            }
        }
        allmap.put(RequestParamType.query.toString(), queryMap);
        if (bodyObj == null) {
            allmap.put(RequestParamType.body.toString(), bodyMap);
        } else {
            allmap.put(RequestParamType.body.toString(), bodyObj);
        }
        allmap.put(RequestParamType.parth.toString(), parthMap);
        allmap.put(RequestParamType.headers.toString(), headMaps);
        return allmap;
    }

    public static String defaultString(String str, String defaultStr) {
        return !Common.stringIsEmpty(str) ? str : defaultStr;
    }

    public static boolean equalString(String str, String val) {
        return str != null && val != null ? str.equals(val) : false;
    }

    public static Map<String, Object> assertAsMap(Object object) {
        if (null != object && Map.class.isAssignableFrom(object.getClass())) {
            return (Map)object;
        }
        throw new RuntimeException("The value is not a object");
    }

    public static InputStream toReadable(String string) {
        try {
            return Common.toReadable(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException var2) {
            throw new RuntimeException(var2.getMessage(), var2);
        }
    }

    public static InputStream toReadable(byte[] byteArray) {
        return new ByteArrayInputStream(byteArray);
    }

    public static String toJSONString(Object object) {
        return object instanceof String ? (String)object : JSONObject.toJSONString((Object)object);
    }

    public static Object toJavaBean(String json, Class clazz) {
        return JSONObject.parseObject((String)json, (Class)clazz);
    }

    public static String toForm(Map<String, ?> filter) throws Exception {
        return Common.toFormWithSymbol(filter, "&");
    }

    private static String toFormWithSymbol(Map<String, ?> filter, String symbol) throws Exception {
        Map<String, String> map = Common.query(filter);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (Common.isEmpty(entry.getValue())) continue;
            if (first) {
                first = false;
            } else {
                result.append(symbol);
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8"));
        }
        return result.toString();
    }

    public static Map<String, String> query(Map<String, ?> filter) throws Exception {
        HashMap<String, String> outMap = new HashMap<String, String>();
        if (null != filter) {
            Common.processObject(outMap, "", filter);
        }
        return outMap;
    }

    private static void processObject(Map<String, String> map, String key, Object value) throws UnsupportedEncodingException {
        if (null != value) {
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    Common.processObject(map, key + "." + (i + 1), list.get(i));
                }
            } else if (value instanceof BasicsModel) {
                Map<String, Object> subMap = ((BasicsModel)value).toMap();
                for (Map.Entry<String, Object> entry : subMap.entrySet()) {
                    Common.processObject(map, key + "." + entry.getKey(), entry.getValue());
                }
            } else if (value instanceof Map) {
                Map subMap = (Map)value;
                for (Map.Entry entry : subMap.entrySet()) {
                    Common.processObject(map, key + "." + (String)entry.getKey(), entry.getValue());
                }
            } else {
                if (key.startsWith(".")) {
                    key = key.substring(1);
                }
                if (value instanceof byte[]) {
                    map.put(key, new String((byte[])value, "UTF-8"));
                } else {
                    map.put(key, String.valueOf(value));
                }
            }
        }
    }

    public static Long getTimestamp() throws Exception {
        return new Date().getTime();
    }

    public static String getSHA256(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = Common.byte2Hex(messageDigest.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodeStr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String temp = null;
        for (byte aByte : bytes) {
            temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    public static String join(String delimiter, Iterable<? extends String> elements) {
        Objects.requireNonNull(delimiter);
        Objects.requireNonNull(elements);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : elements) {
            stringBuilder.append(string);
            stringBuilder.append(delimiter);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static Map<String, Object> responseConverterMap(String responseJson) {
        Map map = (Map)Common.toJavaBean(responseJson, Map.class);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("success", Common.equalString(map.get("code").toString(), "200"));
        responseMap.put("msg", map.get("msg"));
        responseMap.put("errorMsg", Common.equalString(map.get("code").toString(), "200") ? null : (map.get("data") == null ? (Object)map.get("msg") : (Object)map.get("data")));
        responseMap.put("total", map.get("total"));
        responseMap.put("pageNum", map.get("pageNum"));
        responseMap.put("pageSize", map.get("pageSize"));
        responseMap.put("pages", map.get("pages"));
        responseMap.put("body", !Common.equalString(map.get("code").toString(), "200") ? null : (Object)map.get("data"));
        return responseMap;
    }

    public static Map<String, Object> responseConverterMap2(String responseJson, String key) {
        Map map = (Map)Common.toJavaBean(responseJson, Map.class);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("success", Common.equalString(map.get("code").toString(), "200"));
        responseMap.put("msg", map.get("msg"));
        responseMap.put("errorMsg", Common.equalString(map.get("code").toString(), "200") ? null : (map.get("data") == null ? (Object)map.get("msg") : (Object)map.get("data")));
        responseMap.put("total", map.get("total"));
        responseMap.put("pageNum", map.get("pageNum"));
        responseMap.put("pageSize", map.get("pageSize"));
        responseMap.put("pages", map.get("pages"));
        if (!Common.equalString(map.get("code").toString(), "200")) {
            responseMap.put("body", null);
        } else {
            Object obj = map.get("data");
            if (Common.isNull(obj)) {
                responseMap.put("body", null);
            } else {
                String objString = Common.toJSONString(obj);
                responseMap.put("body", ((Map)Common.toJavaBean(objString, Map.class)).get(key));
            }
        }
        return responseMap;
    }
}

