/*
 * Decompiled with CFR 0.152.
 */
package com.quec.model;

import com.quec.model.OkHttpRequest;
import com.quec.until.Common;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class OkRequestBody
extends RequestBody {
    private InputStream inputStream;
    private String contentType;

    public OkRequestBody(OkHttpRequest teaRequest) {
        this.inputStream = teaRequest.body;
        this.contentType = teaRequest.headers.get("content-type");
    }

    public MediaType contentType() {
        if (Common.stringIsEmpty(this.contentType)) {
            if (null == this.inputStream) {
                return null;
            }
            MediaType type = MediaType.parse((String)"application/json; charset=UTF-8;");
            return type;
        }
        return MediaType.parse((String)this.contentType);
    }

    public long contentLength() throws IOException {
        return null != this.inputStream && this.inputStream.available() > 0 ? (long)this.inputStream.available() : super.contentLength();
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (null != this.inputStream) {
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                bufferedSink.write(buffer, 0, bytesRead);
            }
        }
    }
}

