/*
 * Decompiled with CFR 0.152.
 */
package com.quec.client;

import com.quec.config.InitClientProfile;
import com.quec.model.OkHttpRequest;
import com.quec.model.OpenApiRequest;
import com.quec.model.RuntimeOptions;
import com.quec.model.TokenInfo;
import com.quec.until.Common;
import com.quec.until.HttpClientUtil;
import java.util.Calendar;
import java.util.Map;

public class QuecDefaultClient {
    private Long refreshDate;
    private Long expiredDate;
    private String accessKey;
    private String accessSecret;
    private String securityToken;
    private String endpoint;
    private String tokenType;
    private RuntimeOptions runtime;
    private String protocol;

    public QuecDefaultClient(InitClientProfile initClientProfile) {
        this.accessKey = initClientProfile.getAccessKey();
        this.accessSecret = initClientProfile.getAccessSecret();
        this.endpoint = initClientProfile.getEndpoint();
        this.runtime = initClientProfile.getRuntime();
        this.protocol = initClientProfile.getProtocol();
    }

    public String doHTTPRequest(String actionMapping, String method, String authType, String bodyType, OpenApiRequest request) throws Exception {
        this.getSecurityToken(this.protocol);
        Map<String, Object> runMap = Common.toMap(this.runtime);
        OkHttpRequest okHttpRequest = new OkHttpRequest();
        okHttpRequest.protocol = this.protocol;
        okHttpRequest.method = method;
        okHttpRequest.pathname = actionMapping;
        okHttpRequest.query = request.query;
        okHttpRequest.headers = request.headers;
        okHttpRequest.headers.put("Authorization", this.securityToken);
        okHttpRequest.headers.put("host", this.endpoint);
        okHttpRequest.parth = request.parth;
        if (request.body != null) {
            if (Common.equalString(bodyType, "json")) {
                okHttpRequest.body = Common.toReadable(Common.toJSONString(request.body));
                okHttpRequest.headers.put("content-type", "application/json; charset=utf-8");
            } else if (Common.equalString(bodyType, "application/x-www-form-urlencoded")) {
                Map<String, Object> m = Common.assertAsMap(request.body);
                okHttpRequest.body = Common.toReadable(Common.toForm(m));
                okHttpRequest.headers.put("content-type", "application/x-www-form-urlencoded");
            }
        }
        String response = HttpClientUtil.doAction(okHttpRequest, runMap);
        return response;
    }

    private void getSecurityToken(String protocol) {
        try {
            long now = Calendar.getInstance().getTimeInMillis();
            Map<String, Object> runMap = Common.toMap(this.runtime);
            if (Common.stringIsEmpty(this.securityToken)) {
                this.requestToken(protocol, now, runMap);
            } else if (this.expiredDate <= Common.getTimestamp()) {
                this.requestToken(protocol, now, runMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Authentication failed", e);
        }
    }

    private void requestToken(String protocol, long now, Map<String, Object> runMap) {
        String username = "ver=1&auth_mode=accessKey&sign_method=sha256&access_key=" + this.accessKey + "&timestamp=" + now;
        String password = Common.getSHA256(username + this.accessSecret);
        OkHttpRequest okHttpRequest = new OkHttpRequest();
        okHttpRequest.protocol = protocol;
        okHttpRequest.query.put("username", username);
        okHttpRequest.query.put("password", password);
        okHttpRequest.query.put("grant_type", "password");
        okHttpRequest.pathname = "/v2/quecauth/accessKeyAuthrize/accessKeyLogin";
        okHttpRequest.headers.put("host", this.endpoint);
        String response = HttpClientUtil.doAction(okHttpRequest, runMap);
        TokenInfo tokenInfo = (TokenInfo)Common.toJavaBean(response, TokenInfo.class);
        if (tokenInfo.getCode() != 200) {
            throw new RuntimeException("Authentication failed.code:" + tokenInfo.getCode() + "error:" + tokenInfo.getMsg());
        }
        this.securityToken = tokenInfo.getAccess_token();
        this.refreshDate = now;
        this.expiredDate = now + tokenInfo.getExpires_in() * 1000L;
        this.tokenType = tokenInfo.getToken_type();
    }
}

