/*
 * Decompiled with CFR 0.152.
 */
package com.quec.client;

import com.quec.until.TrueHostnameVerifier;
import com.quec.until.X509TrustManagerImp;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class OkHttpClientBuilder {
    private OkHttpClient.Builder builder = new OkHttpClient().newBuilder();

    public OkHttpClientBuilder connectTimeout(Map<String, Object> map) {
        long timeout;
        Object object = map.get("connectTimeout");
        try {
            timeout = Long.parseLong(String.valueOf(object));
        }
        catch (Exception var6) {
            return this;
        }
        this.builder.connectTimeout(timeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public OkHttpClientBuilder readTimeout(Map<String, Object> map) {
        long timeout;
        Object object = map.get("readTimeout");
        try {
            timeout = Long.parseLong(String.valueOf(object));
        }
        catch (Exception var6) {
            return this;
        }
        this.builder.readTimeout(timeout, TimeUnit.MILLISECONDS);
        return this;
    }

    public OkHttpClientBuilder connectionPool(Map<String, Object> map) {
        int maxIdleConnections;
        Object maxIdleConns = map.get("maxIdleConns");
        try {
            maxIdleConnections = Integer.parseInt(String.valueOf(maxIdleConns));
        }
        catch (Exception var5) {
            maxIdleConnections = 5;
        }
        ConnectionPool connectionPool = new ConnectionPool(maxIdleConnections, 10000L, TimeUnit.MILLISECONDS);
        this.builder.connectionPool(connectionPool);
        return this;
    }

    public OkHttpClientBuilder certificate(Map<String, Object> map) {
        try {
            if (Boolean.parseBoolean(String.valueOf(map.get("ignoreSSL")))) {
                X509TrustManagerImp compositeX509TrustManager = new X509TrustManagerImp();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{compositeX509TrustManager}, new SecureRandom());
                this.builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)compositeX509TrustManager).hostnameVerifier((HostnameVerifier)new TrueHostnameVerifier());
            }
            return this;
        }
        catch (Exception var4) {
            throw new RuntimeException(var4.getMessage(), var4);
        }
    }

    public OkHttpClientBuilder proxy(Map<String, Object> map) {
        try {
            if (null != map.get("httpProxy") || null != map.get("httpsProxy")) {
                Object urlString = null == map.get("httpProxy") ? map.get("httpsProxy") : map.get("httpProxy");
                URL url = new URL(String.valueOf(urlString));
                this.builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), url.getPort())));
            }
            return this;
        }
        catch (Exception var4) {
            throw new RuntimeException(var4.getMessage(), var4);
        }
    }

    public OkHttpClientBuilder proxyAuthenticator(Map<String, Object> map) {
        try {
            URL proxyUrl;
            String userInfo;
            Object httpsProxy = map.get("httpsProxy");
            if (httpsProxy != null && null != (userInfo = (proxyUrl = new URL(String.valueOf(httpsProxy))).getUserInfo())) {
                String[] userMessage = userInfo.split(":");
                final String credential = Credentials.basic((String)userMessage[0], (String)userMessage[1]);
                Authenticator authenticator = new Authenticator(){

                    public Request authenticate(Route route, Response response) throws IOException {
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
                this.builder.proxyAuthenticator(authenticator);
            }
            return this;
        }
        catch (Exception var8) {
            throw new RuntimeException(var8.getMessage(), var8);
        }
    }

    public OkHttpClient buildOkHttpClient() {
        return this.builder.build();
    }
}

