/*
 * Decompiled with CFR 0.152.
 */
package com.qq.e.comm.net;

import com.qq.e.comm.net.NetworkCallBack;
import com.qq.e.comm.net.NetworkClient;
import com.qq.e.comm.net.rr.Request;
import com.qq.e.comm.net.rr.Response;
import com.qq.e.comm.util.GDTLogger;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NetworkClientImpl
implements NetworkClient {
    private static final NetworkClient a = new NetworkClientImpl();
    private final ExecutorService b;
    private PriorityBlockingQueue<Runnable> c = new PriorityBlockingQueue(15);

    private NetworkClientImpl() {
        this.b = new ThreadPoolExecutor(5, 10, 180L, TimeUnit.SECONDS, this.c);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpURLConnection followRedirect(HttpURLConnection httpURLConnection) throws IOException {
        String string = null;
        if (httpURLConnection == null) {
            return string;
        }
        int n2 = 0;
        int n3 = httpURLConnection.getConnectTimeout();
        int n4 = httpURLConnection.getReadTimeout();
        try {
            string = httpURLConnection.getRequestProperty("User-Agent");
        }
        catch (Exception exception) {
            string = null;
        }
        while (n2 < 3) {
            httpURLConnection.connect();
            int n5 = httpURLConnection.getResponseCode();
            if (n5 == 302 || n5 == 301 || n5 == 303) {
                String string2 = httpURLConnection.getHeaderField("location");
                httpURLConnection.disconnect();
                httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
                httpURLConnection.setConnectTimeout(n3);
                httpURLConnection.setReadTimeout(n4);
                if (string != null) {
                    httpURLConnection.setRequestProperty("User-Agent", string);
                }
                ++n2;
                continue;
            }
            break;
        }
        if (n2 != 3) return httpURLConnection;
        throw new IOException("HttpURLConnection exceed max redirect " + 3 + " " + httpURLConnection.getURL());
    }

    public static NetworkClient getInstance() {
        return a;
    }

    @Override
    public Future<Response> submit(Request request) {
        return this.submit(request, NetworkClient.Priority.Mid);
    }

    @Override
    public Future<Response> submit(Request object, NetworkClient.Priority priority) {
        object = new NetFutureTask<Response>(new TaskCallable((Request)object), priority);
        this.b.execute((Runnable)object);
        GDTLogger.d("QueueSize:" + this.c.size());
        return object;
    }

    @Override
    public void submit(Request request, NetworkCallBack networkCallBack) {
        this.submit(request, NetworkClient.Priority.Mid, networkCallBack);
    }

    @Override
    public void submit(Request request, NetworkClient.Priority priority, NetworkCallBack networkCallBack) {
        this.submit(request, priority, networkCallBack, this.b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void submit(Request request, NetworkClient.Priority priority, NetworkCallBack networkCallBack, Executor executor) {
        if (executor == null) {
            GDTLogger.e("Submit failed for no executor");
            return;
        }
        executor.execute(new NetFutureTask<Response>(new TaskCallable(request, networkCallBack), priority));
        GDTLogger.d("QueueSize:" + this.c.size());
    }

    private static class NetFutureTask<T>
    extends FutureTask<T>
    implements Comparable<NetFutureTask<T>> {
        private final NetworkClient.Priority a;

        public NetFutureTask(Callable<T> callable, NetworkClient.Priority priority) {
            super(callable);
            this.a = priority;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(NetFutureTask<T> netFutureTask) {
            if (netFutureTask != null) return this.a.value() - netFutureTask.a.value();
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = false;
            if (object == null) {
                return bl;
            }
            boolean bl2 = bl;
            if (object.getClass() != this.getClass()) return bl2;
            bl2 = bl;
            if (this.compareTo((NetFutureTask)object) != 0) return bl2;
            return true;
        }

        public int hashCode() {
            return this.a.value();
        }
    }

    private static class TaskCallable
    implements Callable<Response> {
        private Request a;
        private NetworkCallBack b;

        public TaskCallable(Request request) {
            this(request, null);
        }

        public TaskCallable(Request request, NetworkCallBack networkCallBack) {
            this.a = request;
            this.b = networkCallBack;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void a(HttpURLConnection httpURLConnection) {
            for (Map.Entry<String, String> entry : this.a.getHeaders().entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            httpURLConnection.setRequestProperty("User-Agent", "GDTADNetClient-[" + System.getProperty("http.agent") + "]");
            if (this.a.getConnectionTimeOut() > 0) {
                httpURLConnection.setConnectTimeout(this.a.getConnectionTimeOut());
            } else {
                httpURLConnection.setConnectTimeout(30000);
            }
            if (this.a.getSocketTimeOut() > 0) {
                httpURLConnection.setReadTimeout(this.a.getSocketTimeOut());
                return;
            }
            httpURLConnection.setReadTimeout(30000);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Response call() throws Exception {
            byte[] byArray;
            Object object;
            try {
                object = new URL(this.a.getUrlWithParas());
                object = (HttpURLConnection)((URL)object).openConnection();
                this.a((HttpURLConnection)object);
                switch (this.a.getMethod()) {
                    case POST: {
                        ((URLConnection)object).setDoOutput(true);
                        ((HttpURLConnection)object).setChunkedStreamingMode(0);
                        byArray = this.a.getPostData();
                        if (byArray == null || byArray.length <= 0) break;
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((URLConnection)object).getOutputStream());
                        ((OutputStream)bufferedOutputStream).write(byArray);
                        ((OutputStream)bufferedOutputStream).flush();
                        ((OutputStream)bufferedOutputStream).close();
                    }
                }
                object = NetworkClientImpl.followRedirect((HttpURLConnection)object);
                object = this.a.initResponse((HttpURLConnection)object);
                byArray = null;
            }
            catch (Exception exception) {
                object = null;
            }
            if (byArray == null) {
                if (this.b != null) {
                    this.b.onResponse(this.a, (Response)object);
                }
                if (!this.a.isAutoClose()) return object;
                object.close();
                return object;
            }
            if (this.b == null) throw byArray;
            GDTLogger.w("NetworkClientException", (Throwable)byArray);
            this.b.onException((Exception)byArray);
            if (object == null) return object;
            object.close();
            return object;
        }
    }
}

