/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@StatelessCheck
public class FallThroughCheck
extends AbstractCheck {
    public static final String MSG_FALL_THROUGH = "fall.through";
    public static final String MSG_FALL_THROUGH_LAST = "fall.through.last";
    private boolean checkLastCaseGroup;
    private Pattern reliefPattern = Pattern.compile("fallthru|falls? ?through");

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{33};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    public void setReliefPattern(Pattern pattern) {
        this.reliefPattern = pattern;
    }

    public void setCheckLastCaseGroup(boolean value) {
        this.checkLastCaseGroup = value;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST slist;
        boolean isLastGroup;
        DetailAST nextGroup = ast.getNextSibling();
        boolean bl = isLastGroup = nextGroup.getType() != 33;
        if (!(isLastGroup && !this.checkLastCaseGroup || (slist = ast.findFirstToken(7)) == null || this.isTerminated(slist, true, true) || this.hasFallThroughComment(ast, nextGroup))) {
            if (isLastGroup) {
                this.log(ast, MSG_FALL_THROUGH_LAST, new Object[0]);
            } else {
                this.log(nextGroup, MSG_FALL_THROUGH, new Object[0]);
            }
        }
    }

    private boolean isTerminated(DetailAST ast, boolean useBreak, boolean useContinue) {
        boolean terminated;
        switch (ast.getType()) {
            case 88: 
            case 90: {
                terminated = true;
                break;
            }
            case 86: {
                terminated = useBreak;
                break;
            }
            case 87: {
                terminated = useContinue;
                break;
            }
            case 7: {
                terminated = this.checkSlist(ast, useBreak, useContinue);
                break;
            }
            case 83: {
                terminated = this.checkIf(ast, useBreak, useContinue);
                break;
            }
            case 84: 
            case 85: 
            case 91: {
                terminated = this.checkLoop(ast);
                break;
            }
            case 95: {
                terminated = this.checkTry(ast, useBreak, useContinue);
                break;
            }
            case 89: {
                terminated = this.checkSwitch(ast, useContinue);
                break;
            }
            case 67: {
                terminated = this.checkSynchronized(ast, useBreak, useContinue);
                break;
            }
            default: {
                terminated = false;
            }
        }
        return terminated;
    }

    private boolean checkSlist(DetailAST slistAst, boolean useBreak, boolean useContinue) {
        DetailAST lastStmt = slistAst.getLastChild();
        if (lastStmt.getType() == 73) {
            lastStmt = lastStmt.getPreviousSibling();
        }
        return lastStmt != null && this.isTerminated(lastStmt, useBreak, useContinue);
    }

    private boolean checkIf(DetailAST ast, boolean useBreak, boolean useContinue) {
        DetailAST thenStmt = ast.findFirstToken(77).getNextSibling();
        DetailAST elseStmt = thenStmt.getNextSibling();
        boolean isTerminated = this.isTerminated(thenStmt, useBreak, useContinue);
        if (isTerminated && elseStmt != null) {
            isTerminated = this.isTerminated(elseStmt.getFirstChild(), useBreak, useContinue);
        } else if (elseStmt == null) {
            isTerminated = false;
        }
        return isTerminated;
    }

    private boolean checkLoop(DetailAST ast) {
        DetailAST loopBody;
        if (ast.getType() == 85) {
            DetailAST lparen = ast.findFirstToken(175);
            loopBody = lparen.getPreviousSibling();
        } else {
            DetailAST rparen = ast.findFirstToken(77);
            loopBody = rparen.getNextSibling();
        }
        return this.isTerminated(loopBody, false, false);
    }

    private boolean checkTry(DetailAST ast, boolean useBreak, boolean useContinue) {
        DetailAST finalStmt = ast.getLastChild();
        boolean isTerminated = false;
        if (finalStmt.getType() == 97) {
            isTerminated = this.isTerminated(finalStmt.findFirstToken(7), useBreak, useContinue);
        }
        if (!isTerminated) {
            DetailAST firstChild = ast.getFirstChild();
            if (firstChild.getType() == 176) {
                firstChild = firstChild.getNextSibling();
            }
            isTerminated = this.isTerminated(firstChild, useBreak, useContinue);
            for (DetailAST catchStmt = ast.findFirstToken(96); catchStmt != null && isTerminated && catchStmt.getType() == 96; catchStmt = catchStmt.getNextSibling()) {
                DetailAST catchBody = catchStmt.findFirstToken(7);
                isTerminated = this.isTerminated(catchBody, useBreak, useContinue);
            }
        }
        return isTerminated;
    }

    private boolean checkSwitch(DetailAST literalSwitchAst, boolean useContinue) {
        boolean isTerminated;
        DetailAST caseGroup = literalSwitchAst.findFirstToken(33);
        boolean bl = isTerminated = caseGroup != null;
        while (isTerminated && caseGroup.getType() != 73) {
            DetailAST caseBody = caseGroup.findFirstToken(7);
            isTerminated = caseBody != null && this.isTerminated(caseBody, false, useContinue);
            caseGroup = caseGroup.getNextSibling();
        }
        return isTerminated;
    }

    private boolean checkSynchronized(DetailAST synchronizedAst, boolean useBreak, boolean useContinue) {
        return this.isTerminated(synchronizedAst.findFirstToken(7), useBreak, useContinue);
    }

    private boolean hasFallThroughComment(DetailAST currentCase, DetailAST nextCase) {
        boolean allThroughComment = false;
        int endLineNo = nextCase.getLineNo();
        int endColNo = nextCase.getColumnNo();
        String[] lines = this.getLines();
        String linePart = lines[endLineNo - 1].substring(0, endColNo);
        if (this.matchesComment(this.reliefPattern, linePart, endLineNo)) {
            allThroughComment = true;
        } else {
            int startLineNo = currentCase.getLineNo();
            for (int i = endLineNo - 2; i > startLineNo - 1; --i) {
                if (CommonUtils.isBlank(lines[i])) continue;
                allThroughComment = this.matchesComment(this.reliefPattern, lines[i], i + 1);
                break;
            }
        }
        return allThroughComment;
    }

    private boolean matchesComment(Pattern pattern, String line, int lineNo) {
        Matcher matcher = pattern.matcher(line);
        boolean matches = false;
        if (matcher.find()) {
            matches = this.getFileContents().hasIntersectionWithComment(lineNo, matcher.start(), lineNo, matcher.end());
        }
        return matches;
    }
}

