/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class LocalizedMessage
implements Comparable<LocalizedMessage>,
Serializable {
    private static final long serialVersionUID = 5675176836184862150L;
    private static final Map<String, ResourceBundle> BUNDLE_CACHE = Collections.synchronizedMap(new HashMap());
    private static final SeverityLevel DEFAULT_SEVERITY = SeverityLevel.ERROR;
    private static Locale sLocale = Locale.getDefault();
    private final int lineNo;
    private final int columnNo;
    private final int columnCharIndex;
    private final int tokenType;
    private final SeverityLevel severityLevel;
    private final String moduleId;
    private final String key;
    private final Object[] args;
    private final String bundle;
    private final Class<?> sourceClass;
    private final String customMessage;

    public LocalizedMessage(int lineNo, int columnNo, int columnCharIndex, int tokenType, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this.lineNo = lineNo;
        this.columnNo = columnNo;
        this.columnCharIndex = columnCharIndex;
        this.tokenType = tokenType;
        this.key = key;
        this.args = args == null ? null : Arrays.copyOf(args, args.length);
        this.bundle = bundle;
        this.severityLevel = severityLevel;
        this.moduleId = moduleId;
        this.sourceClass = sourceClass;
        this.customMessage = customMessage;
    }

    public LocalizedMessage(int lineNo, int columnNo, int tokenType, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, columnNo, columnNo, tokenType, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, int columnNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, columnNo, 0, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, int columnNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, columnNo, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, String bundle, String key, Object[] args, SeverityLevel severityLevel, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, 0, bundle, key, args, severityLevel, moduleId, sourceClass, customMessage);
    }

    public LocalizedMessage(int lineNo, String bundle, String key, Object[] args, String moduleId, Class<?> sourceClass, String customMessage) {
        this(lineNo, 0, bundle, key, args, DEFAULT_SEVERITY, moduleId, sourceClass, customMessage);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LocalizedMessage localizedMessage = (LocalizedMessage)object;
        return Objects.equals(this.lineNo, localizedMessage.lineNo) && Objects.equals(this.columnNo, localizedMessage.columnNo) && Objects.equals(this.columnCharIndex, localizedMessage.columnCharIndex) && Objects.equals(this.tokenType, localizedMessage.tokenType) && Objects.equals((Object)this.severityLevel, (Object)localizedMessage.severityLevel) && Objects.equals(this.moduleId, localizedMessage.moduleId) && Objects.equals(this.key, localizedMessage.key) && Objects.equals(this.bundle, localizedMessage.bundle) && Objects.equals(this.sourceClass, localizedMessage.sourceClass) && Objects.equals(this.customMessage, localizedMessage.customMessage) && Arrays.equals(this.args, localizedMessage.args);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lineNo, this.columnNo, this.columnCharIndex, this.tokenType, this.severityLevel, this.moduleId, this.key, this.bundle, this.sourceClass, this.customMessage, Arrays.hashCode(this.args)});
    }

    public static void clearCache() {
        BUNDLE_CACHE.clear();
    }

    public String getMessage() {
        String message = this.getCustomMessage();
        if (message == null) {
            try {
                ResourceBundle resourceBundle = this.getBundle(this.bundle);
                String pattern = resourceBundle.getString(this.key);
                MessageFormat formatter = new MessageFormat(pattern, Locale.ROOT);
                message = formatter.format(this.args);
            }
            catch (MissingResourceException ignored) {
                MessageFormat formatter = new MessageFormat(this.key, Locale.ROOT);
                message = formatter.format(this.args);
            }
        }
        return message;
    }

    private String getCustomMessage() {
        String message = null;
        if (this.customMessage != null) {
            MessageFormat formatter = new MessageFormat(this.customMessage, Locale.ROOT);
            message = formatter.format(this.args);
        }
        return message;
    }

    private ResourceBundle getBundle(String bundleName) {
        return BUNDLE_CACHE.computeIfAbsent(bundleName, name -> ResourceBundle.getBundle(name, sLocale, this.sourceClass.getClassLoader(), new Utf8Control()));
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public int getColumnCharIndex() {
        return this.columnCharIndex;
    }

    public int getTokenType() {
        return this.tokenType;
    }

    public SeverityLevel getSeverityLevel() {
        return this.severityLevel;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getKey() {
        return this.key;
    }

    public String getSourceName() {
        return this.sourceClass.getName();
    }

    public static void setLocale(Locale locale) {
        LocalizedMessage.clearCache();
        sLocale = Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) ? Locale.ROOT : locale;
    }

    @Override
    public int compareTo(LocalizedMessage other) {
        int result = this.lineNo == other.lineNo ? (this.columnNo == other.columnNo ? (Objects.equals(this.moduleId, other.moduleId) ? this.getMessage().compareTo(other.getMessage()) : (this.moduleId == null ? -1 : (other.moduleId == null ? 1 : this.moduleId.compareTo(other.moduleId)))) : Integer.compare(this.columnNo, other.columnNo)) : Integer.compare(this.lineNo, other.lineNo);
        return result;
    }

    public static class Utf8Control
    extends ResourceBundle.Control {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String aBaseName, Locale aLocale, String aFormat, ClassLoader aLoader, boolean aReload) throws IOException {
            String bundleName = this.toBundleName(aBaseName, aLocale);
            String resourceName = this.toResourceName(bundleName, "properties");
            InputStream stream = null;
            if (aReload) {
                URLConnection connection;
                URL url = aLoader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = aLoader.getResourceAsStream(resourceName);
            }
            PropertyResourceBundle resourceBundle = null;
            if (stream != null) {
                InputStreamReader streamReader = new InputStreamReader(stream, StandardCharsets.UTF_8.name());
                try {
                    resourceBundle = new PropertyResourceBundle(streamReader);
                }
                finally {
                    stream.close();
                }
            }
            return resourceBundle;
        }
    }
}

