/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

@StatelessCheck
public class EmptyLineSeparatorCheck
extends AbstractCheck {
    public static final String MSG_SHOULD_BE_SEPARATED = "empty.line.separator";
    public static final String MSG_MULTIPLE_LINES = "empty.line.separator.multiple.lines";
    public static final String MSG_MULTIPLE_LINES_AFTER = "empty.line.separator.multiple.lines.after";
    public static final String MSG_MULTIPLE_LINES_INSIDE = "empty.line.separator.multiple.lines.inside";
    private boolean allowNoEmptyLineBetweenFields;
    private boolean allowMultipleEmptyLines = true;
    private boolean allowMultipleEmptyLinesInsideClassMembers = true;

    public final void setAllowNoEmptyLineBetweenFields(boolean allow) {
        this.allowNoEmptyLineBetweenFields = allow;
    }

    public void setAllowMultipleEmptyLines(boolean allow) {
        this.allowMultipleEmptyLines = allow;
    }

    public void setAllowMultipleEmptyLinesInsideClassMembers(boolean allow) {
        this.allowMultipleEmptyLinesInsideClassMembers = allow;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16, 30, 152, 14, 15, 154, 12, 11, 9, 8, 10, 199, 203};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.checkComments(ast);
        if (this.hasMultipleLinesBefore(ast)) {
            this.log(ast, MSG_MULTIPLE_LINES, ast.getText());
        }
        if (!this.allowMultipleEmptyLinesInsideClassMembers) {
            this.processMultipleLinesInside(ast);
        }
        if (ast.getType() == 16) {
            this.checkCommentInModifiers(ast);
        }
        DetailAST nextToken = ast.getNextSibling();
        while (EmptyLineSeparatorCheck.isComment(nextToken)) {
            nextToken = nextToken.getNextSibling();
        }
        if (nextToken != null) {
            this.checkToken(ast, nextToken);
        }
    }

    private void checkToken(DetailAST ast, DetailAST nextToken) {
        int astType = ast.getType();
        switch (astType) {
            case 10: {
                this.processVariableDef(ast, nextToken);
                break;
            }
            case 30: 
            case 152: {
                this.processImport(ast, nextToken);
                break;
            }
            case 16: {
                this.processPackage(ast, nextToken);
                break;
            }
            default: {
                if (nextToken.getType() == 73) {
                    if (!this.hasNotAllowedTwoEmptyLinesBefore(nextToken)) break;
                    this.log(ast, MSG_MULTIPLE_LINES_AFTER, ast.getText());
                    break;
                }
                if (this.hasEmptyLineAfter(ast)) break;
                this.log(nextToken, MSG_SHOULD_BE_SEPARATED, nextToken.getText());
            }
        }
    }

    private void checkCommentInModifiers(DetailAST packageDef) {
        Optional<DetailAST> comment = EmptyLineSeparatorCheck.findCommentUnder(packageDef);
        if (comment.isPresent()) {
            this.log(comment.get(), MSG_SHOULD_BE_SEPARATED, comment.get().getText());
        }
    }

    private void processMultipleLinesInside(DetailAST ast) {
        int astType = ast.getType();
        if (EmptyLineSeparatorCheck.isClassMemberBlock(astType)) {
            List<Integer> emptyLines = this.getEmptyLines(ast);
            List<Integer> emptyLinesToLog = EmptyLineSeparatorCheck.getEmptyLinesToLog(emptyLines);
            for (Integer lineNo : emptyLinesToLog) {
                this.log(lineNo + 1, MSG_MULTIPLE_LINES_INSIDE, new Object[0]);
            }
        }
    }

    private static boolean isClassMemberBlock(int astType) {
        return TokenUtil.isOfType(astType, 12, 11, 9, 8, 203);
    }

    private List<Integer> getEmptyLines(DetailAST ast) {
        DetailAST lastToken = ast.getLastChild().getLastChild();
        int lastTokenLineNo = 0;
        if (lastToken != null) {
            lastTokenLineNo = lastToken.getLineNo() - 2;
        }
        ArrayList<Integer> emptyLines = new ArrayList<Integer>();
        FileContents fileContents = this.getFileContents();
        for (int lineNo = ast.getLineNo(); lineNo <= lastTokenLineNo; ++lineNo) {
            if (!fileContents.lineIsBlank(lineNo)) continue;
            emptyLines.add(lineNo);
        }
        return emptyLines;
    }

    private static List<Integer> getEmptyLinesToLog(List<Integer> emptyLines) {
        ArrayList<Integer> emptyLinesToLog = new ArrayList<Integer>();
        if (emptyLines.size() >= 2) {
            int previousEmptyLineNo = emptyLines.get(0);
            for (int emptyLineNo : emptyLines) {
                if (previousEmptyLineNo + 1 == emptyLineNo) {
                    emptyLinesToLog.add(emptyLineNo);
                }
                previousEmptyLineNo = emptyLineNo;
            }
        }
        return emptyLinesToLog;
    }

    private boolean hasMultipleLinesBefore(DetailAST ast) {
        boolean result = false;
        if ((ast.getType() != 10 || EmptyLineSeparatorCheck.isTypeField(ast)) && this.hasNotAllowedTwoEmptyLinesBefore(ast)) {
            result = true;
        }
        return result;
    }

    private void processPackage(DetailAST ast, DetailAST nextToken) {
        if (ast.getLineNo() > 1 && !this.hasEmptyLineBefore(ast)) {
            if (this.getFileContents().getFileName().endsWith("package-info.java")) {
                if (!ast.getFirstChild().hasChildren() && !EmptyLineSeparatorCheck.isPrecededByJavadoc(ast)) {
                    this.log(ast, MSG_SHOULD_BE_SEPARATED, ast.getText());
                }
            } else {
                this.log(ast, MSG_SHOULD_BE_SEPARATED, ast.getText());
            }
        }
        if (!this.hasEmptyLineAfter(ast)) {
            this.log(nextToken, MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
    }

    private void processImport(DetailAST ast, DetailAST nextToken) {
        if (!TokenUtil.isOfType(nextToken, 30, 152) && !this.hasEmptyLineAfter(ast)) {
            this.log(nextToken, MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
    }

    private void processVariableDef(DetailAST ast, DetailAST nextToken) {
        if (EmptyLineSeparatorCheck.isTypeField(ast) && !this.hasEmptyLineAfter(ast) && this.isViolatingEmptyLineBetweenFieldsPolicy(nextToken)) {
            this.log(nextToken, MSG_SHOULD_BE_SEPARATED, nextToken.getText());
        }
    }

    private boolean isViolatingEmptyLineBetweenFieldsPolicy(DetailAST detailAST) {
        return detailAST.getType() != 73 && (!this.allowNoEmptyLineBetweenFields || !TokenUtil.isOfType(detailAST, 74, 10));
    }

    private boolean hasNotAllowedTwoEmptyLinesBefore(DetailAST token) {
        return !this.allowMultipleEmptyLines && this.hasEmptyLineBefore(token) && this.isPrePreviousLineEmpty(token);
    }

    private void checkComments(DetailAST token) {
        if (!this.allowMultipleEmptyLines) {
            if (TokenUtil.isOfType(token, 16, 30, 152, 12)) {
                DetailAST previousNode = token.getPreviousSibling();
                while (this.isCommentInBeginningOfLine(previousNode)) {
                    if (this.hasEmptyLineBefore(previousNode) && this.isPrePreviousLineEmpty(previousNode)) {
                        this.log(previousNode, MSG_MULTIPLE_LINES, previousNode.getText());
                    }
                    previousNode = previousNode.getPreviousSibling();
                }
            } else {
                this.checkCommentsInsideToken(token);
            }
        }
    }

    private void checkCommentsInsideToken(DetailAST token) {
        LinkedList<DetailAST> childNodes = new LinkedList<DetailAST>();
        for (DetailAST childNode = token.getLastChild(); childNode != null; childNode = childNode.getPreviousSibling()) {
            if (childNode.getType() == 5) {
                for (DetailAST node = token.getFirstChild().getLastChild(); node != null; node = node.getPreviousSibling()) {
                    if (!this.isCommentInBeginningOfLine(node)) continue;
                    childNodes.add(node);
                }
                continue;
            }
            if (!this.isCommentInBeginningOfLine(childNode)) continue;
            childNodes.add(childNode);
        }
        for (DetailAST node : childNodes) {
            if (!this.hasEmptyLineBefore(node) || !this.isPrePreviousLineEmpty(node)) continue;
            this.log(node, MSG_MULTIPLE_LINES, node.getText());
        }
    }

    private boolean isPrePreviousLineEmpty(DetailAST token) {
        boolean result = false;
        int lineNo = token.getLineNo();
        int number = 3;
        if (lineNo >= 3) {
            String prePreviousLine = this.getLines()[lineNo - 3];
            result = CommonUtil.isBlank(prePreviousLine);
        }
        return result;
    }

    private boolean hasEmptyLineAfter(DetailAST token) {
        DetailAST nextToken;
        DetailAST lastToken = token.getLastChild().getLastChild();
        if (lastToken == null) {
            lastToken = token.getLastChild();
        }
        if (EmptyLineSeparatorCheck.isComment(nextToken = token.getNextSibling())) {
            nextToken = nextToken.getNextSibling();
        }
        int nextBegin = nextToken.getLineNo();
        int currentEnd = lastToken.getLineNo();
        return this.hasEmptyLine(currentEnd + 1, nextBegin - 1);
    }

    private static Optional<DetailAST> findCommentUnder(DetailAST packageDef) {
        return Optional.ofNullable(packageDef.getNextSibling()).map(sibling -> sibling.findFirstToken(5)).map(DetailAST::getFirstChild).filter(EmptyLineSeparatorCheck::isComment).filter(comment -> comment.getLineNo() == packageDef.getLineNo() + 1);
    }

    private boolean hasEmptyLine(int startLine, int endLine) {
        boolean result = false;
        FileContents fileContents = this.getFileContents();
        for (int line = startLine; line <= endLine; ++line) {
            if (!fileContents.lineIsBlank(line - 1)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean hasEmptyLineBefore(DetailAST token) {
        boolean result = false;
        int lineNo = token.getLineNo();
        if (lineNo != 1) {
            String lineBefore = this.getLines()[lineNo - 2];
            result = CommonUtil.isBlank(lineBefore);
        }
        return result;
    }

    private boolean isCommentInBeginningOfLine(DetailAST comment) {
        boolean result = false;
        if (comment != null) {
            String lineWithComment = this.getLines()[comment.getLineNo() - 1].trim();
            result = lineWithComment.startsWith("//") || lineWithComment.startsWith("/*");
        }
        return result;
    }

    private static boolean isPrecededByJavadoc(DetailAST token) {
        boolean result = false;
        DetailAST previous = token.getPreviousSibling();
        if (previous.getType() == 145 && JavadocUtil.isJavadocComment(previous.getFirstChild().getText())) {
            result = true;
        }
        return result;
    }

    private static boolean isComment(DetailAST ast) {
        return TokenUtil.isOfType(ast, 144, 145);
    }

    private static boolean isTypeField(DetailAST variableDef) {
        return TokenUtil.isOfType(variableDef.getParent().getParent(), 14, 199);
    }
}

