/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import java.util.HashMap;
import java.util.Map;

public class EqualsHashCodeCheck
extends AbstractCheck {
    public static final String MSG_KEY_HASHCODE = "equals.noHashCode";
    public static final String MSG_KEY_EQUALS = "equals.noEquals";
    private final Map<DetailAST, DetailAST> objBlockWithEquals = new HashMap<DetailAST, DetailAST>();
    private final Map<DetailAST, DetailAST> objBlockWithHashCode = new HashMap<DetailAST, DetailAST>();

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.objBlockWithEquals.clear();
        this.objBlockWithHashCode.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (EqualsHashCodeCheck.isEqualsMethod(ast)) {
            this.objBlockWithEquals.put(ast.getParent(), ast);
        } else if (EqualsHashCodeCheck.isHashCodeMethod(ast)) {
            this.objBlockWithHashCode.put(ast.getParent(), ast);
        }
    }

    private static boolean isEqualsMethod(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST parameters = ast.findFirstToken(20);
        return CheckUtils.isEqualsMethod(ast) && modifiers.branchContains(62) && EqualsHashCodeCheck.isObjectParam(parameters.getFirstChild()) && (ast.branchContains(7) || modifiers.branchContains(66));
    }

    private static boolean isHashCodeMethod(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST type = ast.findFirstToken(13);
        DetailAST methodName = ast.findFirstToken(58);
        DetailAST parameters = ast.findFirstToken(20);
        return type.getFirstChild().getType() == 54 && "hashCode".equals(methodName.getText()) && modifiers.branchContains(62) && !modifiers.branchContains(64) && parameters.getFirstChild() == null && (ast.branchContains(7) || modifiers.branchContains(66));
    }

    private static boolean isObjectParam(DetailAST paramNode) {
        DetailAST typeNode = paramNode.findFirstToken(13);
        FullIdent fullIdent = FullIdent.createFullIdentBelow(typeNode);
        String name = fullIdent.getText();
        return "Object".equals(name) || "java.lang.Object".equals(name);
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        this.objBlockWithEquals.entrySet().stream().filter(detailASTDetailASTEntry -> this.objBlockWithHashCode.remove(detailASTDetailASTEntry.getKey()) == null).forEach(detailASTDetailASTEntry -> {
            DetailAST equalsAST = (DetailAST)((Object)((Object)detailASTDetailASTEntry.getValue()));
            this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), MSG_KEY_HASHCODE, new Object[0]);
        });
        this.objBlockWithHashCode.forEach((key, equalsAST) -> this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), MSG_KEY_EQUALS, new Object[0]));
        this.objBlockWithEquals.clear();
        this.objBlockWithHashCode.clear();
    }
}

