/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Flushables;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;

final class PropertyCacheFile {
    public static final String CONFIG_HASH_KEY = "configuration*?";
    public static final String EXTERNAL_RESOURCE_KEY_PREFIX = "module-resource*?:";
    private final Properties details = new Properties();
    private final Configuration config;
    private final String fileName;
    private String configHash;

    PropertyCacheFile(Configuration config, String fileName) {
        if (config == null) {
            throw new IllegalArgumentException("config can not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        this.config = config;
        this.fileName = fileName;
    }

    public void load() throws IOException {
        block4: {
            block3: {
                FileInputStream inStream;
                block2: {
                    this.configHash = PropertyCacheFile.getHashCodeBasedOnObjectContent(this.config);
                    if (!new File(this.fileName).exists()) break block3;
                    inStream = null;
                    try {
                        inStream = new FileInputStream(this.fileName);
                        this.details.load(inStream);
                        String cachedConfigHash = this.details.getProperty(CONFIG_HASH_KEY);
                        if (this.configHash.equals(cachedConfigHash)) break block2;
                        this.reset();
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(inStream);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly((InputStream)inStream);
                break block4;
            }
            this.reset();
        }
    }

    public void persist() throws IOException {
        Path directory = Paths.get(this.fileName, new String[0]).getParent();
        if (directory != null) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileName);
            this.details.store(out, null);
        }
        catch (Throwable throwable) {
            PropertyCacheFile.flushAndCloseOutStream(out);
            throw throwable;
        }
        PropertyCacheFile.flushAndCloseOutStream(out);
    }

    public void reset() {
        this.details.clear();
        this.details.setProperty(CONFIG_HASH_KEY, this.configHash);
    }

    private static void flushAndCloseOutStream(OutputStream stream) throws IOException {
        if (stream != null) {
            Flushables.flush((Flushable)stream, (boolean)false);
        }
        Closeables.close((Closeable)stream, (boolean)false);
    }

    public boolean isInCache(String uncheckedFileName, long timestamp) {
        String lastChecked = this.details.getProperty(uncheckedFileName);
        return lastChecked != null && lastChecked.equals(Long.toString(timestamp));
    }

    public void put(String checkedFileName, long timestamp) {
        this.details.setProperty(checkedFileName, Long.toString(timestamp));
    }

    public String get(String name) {
        return this.details.getProperty(name);
    }

    public void remove(String checkedFileName) {
        this.details.remove(checkedFileName);
    }

    private static String getHashCodeBasedOnObjectContent(Serializable object) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(outputStream);
                oos.writeObject(object);
            }
            catch (Throwable throwable) {
                PropertyCacheFile.flushAndCloseOutStream(oos);
                throw throwable;
            }
            PropertyCacheFile.flushAndCloseOutStream(oos);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(outputStream.toByteArray());
            return DatatypeConverter.printHexBinary((byte[])digest.digest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Unable to calculate hashcode.", ex);
        }
    }

    public void putExternalResources(Set<String> locations) {
        Set<ExternalResource> resources = PropertyCacheFile.loadExternalResources(locations);
        if (this.areExternalResourcesChanged(resources)) {
            this.reset();
        }
        this.fillCacheWithExternalResources(resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ExternalResource> loadExternalResources(Set<String> resourceLocations) {
        HashSet<ExternalResource> resources = new HashSet<ExternalResource>();
        for (String location : resourceLocations) {
            String contentHashSum = null;
            try {
                byte[] content = PropertyCacheFile.loadExternalResource(location);
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent((Serializable)content);
            }
            catch (CheckstyleException ex) {
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent(ex);
            }
            finally {
                resources.add(new ExternalResource(EXTERNAL_RESOURCE_KEY_PREFIX + location, contentHashSum));
            }
        }
        return resources;
    }

    private static byte[] loadExternalResource(String location) throws CheckstyleException {
        byte[] content;
        URI uri = CommonUtils.getUriByFilename(location);
        try {
            content = ByteStreams.toByteArray((InputStream)new BufferedInputStream(uri.toURL().openStream()));
        }
        catch (IOException ex) {
            throw new CheckstyleException("Unable to load external resource file " + location, ex);
        }
        return content;
    }

    private boolean areExternalResourcesChanged(Set<ExternalResource> resources) {
        return resources.stream().filter(resource -> {
            boolean changed = false;
            if (this.isResourceLocationInCache(((ExternalResource)resource).location)) {
                String contentHashSum = ((ExternalResource)resource).contentHashSum;
                String cachedHashSum = this.details.getProperty(((ExternalResource)resource).location);
                if (!cachedHashSum.equals(contentHashSum)) {
                    changed = true;
                }
            } else {
                changed = true;
            }
            return changed;
        }).findFirst().isPresent();
    }

    private void fillCacheWithExternalResources(Set<ExternalResource> externalResources) {
        externalResources.stream().filter(resource -> !this.isResourceLocationInCache(((ExternalResource)resource).location)).forEach(resource -> this.details.setProperty(((ExternalResource)resource).location, ((ExternalResource)resource).contentHashSum));
    }

    private boolean isResourceLocationInCache(String location) {
        String cachedHashSum = this.details.getProperty(location);
        return cachedHashSum != null;
    }

    private static class ExternalResource {
        private final String location;
        private final String contentHashSum;

        ExternalResource(String location, String contentHashSum) {
            this.location = location;
            this.contentHashSum = contentHashSum;
        }
    }
}

