/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.ArrayUtils;

public class OneTopLevelClassCheck
extends AbstractCheck {
    public static final String MSG_KEY = "one.top.level.class";
    private boolean publicTypeFound;
    private final SortedMap<Integer, String> lineNumberTypeMap = new TreeMap<Integer, String>();

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.publicTypeFound = false;
        this.lineNumberTypeMap.clear();
        for (DetailAST currentNode = rootAST; currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getType() != 14 && currentNode.getType() != 154 && currentNode.getType() != 15) continue;
            if (OneTopLevelClassCheck.isPublic(currentNode)) {
                this.publicTypeFound = true;
                continue;
            }
            String typeName = currentNode.findFirstToken(58).getText();
            this.lineNumberTypeMap.put(currentNode.getLineNo(), typeName);
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (!this.lineNumberTypeMap.isEmpty()) {
            if (!this.publicTypeFound) {
                this.lineNumberTypeMap.remove(this.lineNumberTypeMap.firstKey());
            }
            for (Map.Entry<Integer, String> entry : this.lineNumberTypeMap.entrySet()) {
                this.log((int)entry.getKey(), MSG_KEY, entry.getValue());
            }
        }
    }

    private static boolean isPublic(DetailAST typeDef) {
        DetailAST modifiers = typeDef.findFirstToken(5);
        return modifiers.findFirstToken(62) != null;
    }
}

