/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class SuppressWarningsCheck
extends AbstractCheck {
    public static final String MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED = "suppressed.warning.not.allowed";
    private static final String SUPPRESS_WARNINGS = "SuppressWarnings";
    private static final String FQ_SUPPRESS_WARNINGS = "java.lang.SuppressWarnings";
    private String format = "^$|^\\s+$";
    private Pattern regexp = Pattern.compile(this.format);

    public final void setFormat(String format) {
        this.format = format;
        this.regexp = CommonUtils.createPattern(format);
    }

    @Override
    public final int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public final int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157, 161, 155, 21, 10, 9, 8};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST annotation = SuppressWarningsCheck.getSuppressWarnings(ast);
        if (annotation == null) {
            return;
        }
        DetailAST warningHolder = SuppressWarningsCheck.findWarningsHolder(annotation);
        DetailAST token = warningHolder.findFirstToken(160);
        DetailAST warning = token == null ? warningHolder.findFirstToken(28) : token.findFirstToken(28);
        if (warning == null) {
            this.logMatch(warningHolder.getLineNo(), warningHolder.getColumnNo(), "");
            return;
        }
        while (warning != null) {
            if (warning.getType() == 28) {
                DetailAST fChild = warning.getFirstChild();
                switch (fChild.getType()) {
                    case 139: {
                        String warningText = SuppressWarningsCheck.removeQuotes(warning.getFirstChild().getText());
                        this.logMatch(warning.getLineNo(), warning.getColumnNo(), warningText);
                        break;
                    }
                    case 109: {
                        this.walkConditional(fChild);
                        break;
                    }
                    case 58: 
                    case 59: {
                        break;
                    }
                }
            }
            warning = warning.getNextSibling();
        }
    }

    private static DetailAST getSuppressWarnings(DetailAST ast) {
        DetailAST annotation = AnnotationUtility.getAnnotation(ast, SUPPRESS_WARNINGS);
        if (annotation == null) {
            return AnnotationUtility.getAnnotation(ast, FQ_SUPPRESS_WARNINGS);
        }
        return annotation;
    }

    private void logMatch(int lineNo, int colNum, String warningText) {
        Matcher matcher = this.regexp.matcher(warningText);
        if (matcher.matches()) {
            this.log(lineNo, colNum, MSG_KEY_SUPPRESSED_WARNING_NOT_ALLOWED, warningText);
        }
    }

    private static DetailAST findWarningsHolder(DetailAST annotation) {
        DetailAST annValuePair = annotation.findFirstToken(160);
        DetailAST annArrayInit = annValuePair == null ? annotation.findFirstToken(162) : annValuePair.findFirstToken(162);
        if (annArrayInit != null) {
            return annArrayInit;
        }
        return annotation;
    }

    private static String removeQuotes(String warning) {
        return warning.substring(1, warning.length() - 1);
    }

    private void walkConditional(DetailAST cond) {
        if (cond.getType() != 109) {
            String warningText = SuppressWarningsCheck.removeQuotes(cond.getText());
            this.logMatch(cond.getLineNo(), cond.getColumnNo(), warningText);
            return;
        }
        this.walkConditional(SuppressWarningsCheck.getCondLeft(cond));
        this.walkConditional(SuppressWarningsCheck.getCondRight(cond));
    }

    private static DetailAST getCondLeft(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getPreviousSibling();
    }

    private static DetailAST getCondRight(DetailAST cond) {
        DetailAST colon = cond.findFirstToken(82);
        return colon.getNextSibling();
    }
}

