/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileText
extends AbstractList<String> {
    private static final int READ_BUFFER_SIZE = 1024;
    private static final Pattern LINE_TERMINATOR = Utils.getPattern("\\n|\\r\\n?");
    private final File mFile;
    private final Charset mCharset;
    private final String mFullText;
    private final String[] mLines;
    private int[] mLineBreaks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileText(File aFile, String aCharsetName) throws IOException {
        String l;
        CharsetDecoder decoder;
        this.mFile = aFile;
        try {
            this.mCharset = Charset.forName(aCharsetName);
            decoder = this.mCharset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (UnsupportedCharsetException ex) {
            String message = "Unsupported charset: " + aCharsetName;
            UnsupportedEncodingException ex2 = new UnsupportedEncodingException(message);
            ex2.initCause(ex);
            throw ex2;
        }
        char[] chars = new char[1024];
        StringBuilder buf = new StringBuilder();
        FileInputStream stream = new FileInputStream(aFile);
        InputStreamReader reader = new InputStreamReader((InputStream)stream, decoder);
        try {
            int len;
            while ((len = reader.read(chars)) >= 0) {
                buf.append(chars, 0, len);
            }
        }
        finally {
            Utils.closeQuietly(reader);
        }
        this.mFullText = buf.toString();
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(this.mFullText));
        while (null != (l = br.readLine())) {
            lines.add(l);
        }
        this.mLines = lines.toArray(new String[lines.size()]);
    }

    private FileText(File aFile, List<String> aLines) {
        StringBuilder buf = new StringBuilder();
        for (String line : aLines) {
            buf.append(line).append('\n');
        }
        buf.trimToSize();
        this.mFile = aFile;
        this.mCharset = null;
        this.mFullText = buf.toString();
        this.mLines = aLines.toArray(new String[aLines.size()]);
    }

    public static FileText fromLines(File aFile, List<String> aLines) {
        return aLines instanceof FileText ? (FileText)aLines : new FileText(aFile, aLines);
    }

    public File getFile() {
        return this.mFile;
    }

    public Charset getCharset() {
        return this.mCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBytes() throws IOException {
        if (this.mFile == null) {
            return null;
        }
        if (this.mFile.length() > Integer.MAX_VALUE) {
            throw new IOException("File too large.");
        }
        byte[] bytes = new byte[(int)this.mFile.length() + 1];
        FileInputStream stream = new FileInputStream(this.mFile);
        try {
            int fill = 0;
            while (true) {
                int len;
                if (fill >= bytes.length) {
                    byte[] newBytes = new byte[bytes.length * 2 + 1];
                    System.arraycopy(bytes, 0, newBytes, 0, fill);
                    bytes = newBytes;
                }
                if ((len = stream.read(bytes, fill, bytes.length - fill)) == -1) break;
                fill += len;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, fill).asReadOnlyBuffer();
            return byteBuffer;
        }
        finally {
            Utils.closeQuietly(stream);
        }
    }

    public CharSequence getFullText() {
        return this.mFullText;
    }

    public String[] toLinesArray() {
        return (String[])this.mLines.clone();
    }

    private int[] lineBreaks() {
        if (this.mLineBreaks == null) {
            int[] lineBreaks = new int[this.size() + 1];
            lineBreaks[0] = 0;
            int lineNo = 1;
            Matcher matcher = LINE_TERMINATOR.matcher(this.mFullText);
            while (matcher.find()) {
                lineBreaks[lineNo++] = matcher.end();
            }
            if (lineNo < lineBreaks.length) {
                lineBreaks[lineNo++] = this.mFullText.length();
            }
            if (lineNo != lineBreaks.length) {
                throw new ConcurrentModificationException("Text changed.");
            }
            this.mLineBreaks = lineBreaks;
        }
        return this.mLineBreaks;
    }

    public LineColumn lineColumn(int aPos) {
        int[] lineBreaks = this.lineBreaks();
        int lineNo = Arrays.binarySearch(lineBreaks, aPos);
        if (lineNo < 0) {
            lineNo = -lineNo - 2;
        }
        int startOfLine = lineBreaks[lineNo];
        int columnNo = aPos - startOfLine;
        return new LineColumn(lineNo + 1, columnNo);
    }

    @Override
    public String get(int aLineNo) {
        return this.mLines[aLineNo];
    }

    @Override
    public int size() {
        return this.mLines.length;
    }
}

