/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.NativeImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class MacroOption {
    private static final String macroOptionPrefix = "--";
    private final String optionName;
    private final Path optionDirectory;
    final MacroOptionKind kind;
    private final Map<String, String> properties;

    Path getOptionDirectory() {
        return this.optionDirectory;
    }

    String getOptionName() {
        return this.optionName;
    }

    String getDescription(boolean commandLineStyle) {
        StringBuilder sb = new StringBuilder();
        if (commandLineStyle) {
            sb.append(macroOptionPrefix);
        }
        sb.append(this.kind.toString()).append(":").append(this.getOptionName());
        return sb.toString();
    }

    private static MacroOption create(Path macroOptionDirectory) {
        try {
            return new MacroOption(macroOptionDirectory);
        }
        catch (Exception e) {
            return null;
        }
    }

    private MacroOption(Path optionDirectory) {
        this.kind = MacroOptionKind.fromSubdir(optionDirectory.getParent().getFileName().toString());
        this.optionName = optionDirectory.getFileName().toString();
        this.optionDirectory = optionDirectory;
        this.properties = NativeImage.loadProperties(optionDirectory.resolve("native-image.properties"));
    }

    public String toString() {
        return this.getDescription(false);
    }

    static final class Registry {
        private final Map<MacroOptionKind, Map<String, MacroOption>> supported = new HashMap<MacroOptionKind, Map<String, MacroOption>>();
        private final LinkedHashSet<EnabledOption> enabled = new LinkedHashSet();

        private static Map<MacroOptionKind, Map<String, MacroOption>> collectMacroOptions(Path rootDir) throws IOException {
            HashMap<MacroOptionKind, Map<String, MacroOption>> result = new HashMap<MacroOptionKind, Map<String, MacroOption>>();
            for (MacroOptionKind kind : MacroOptionKind.values()) {
                Path optionsDir = rootDir.resolve(kind.subdir);
                Map<Object, Object> collectedOptions = Collections.emptyMap();
                if (Files.isDirectory(optionsDir, new LinkOption[0])) {
                    collectedOptions = Files.list(optionsDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(optionDir -> Files.isReadable(optionDir.resolve("native-image.properties"))).map(x$0 -> MacroOption.create(x$0)).filter(Objects::nonNull).collect(Collectors.toMap(MacroOption::getOptionName, Function.identity()));
                }
                result.put(kind, collectedOptions);
            }
            return result;
        }

        Registry() {
            for (MacroOptionKind kind : MacroOptionKind.values()) {
                this.supported.put(kind, new HashMap());
            }
        }

        void addMacroOptionRoot(Path rootDir) {
            try {
                Registry.collectMacroOptions(rootDir).forEach((optionKind, optionMap) -> this.supported.get(optionKind).putAll((Map<String, MacroOption>)optionMap));
            }
            catch (IOException e) {
                throw new InvalidMacroException("Error while discovering supported MacroOptions in " + rootDir + ": " + e.getMessage());
            }
        }

        Set<String> getAvailableOptions(MacroOptionKind forKind) {
            return this.supported.get((Object)forKind).keySet();
        }

        void showOptions(MacroOptionKind forKind, boolean commandLineStyle, Consumer<String> lineOut) {
            ArrayList<String> optionsToShow = new ArrayList<String>();
            for (MacroOptionKind kind : MacroOptionKind.values()) {
                if (forKind != null && !kind.equals((Object)forKind) || forKind == null && kind == MacroOptionKind.Macro) continue;
                for (MacroOption option : this.supported.get((Object)kind).values()) {
                    if (option.kind.subdir.isEmpty()) continue;
                    String linePrefix = "    ";
                    if (commandLineStyle) {
                        linePrefix = linePrefix + MacroOption.macroOptionPrefix;
                    }
                    optionsToShow.add(linePrefix + option);
                }
            }
            if (!optionsToShow.isEmpty()) {
                StringBuilder sb = new StringBuilder().append("Available ");
                if (forKind != null) {
                    sb.append(forKind.toString()).append(' ');
                } else {
                    sb.append("macro-");
                }
                lineOut.accept(sb.append("options are:").toString());
                optionsToShow.forEach(lineOut);
            }
        }

        MacroOption getMacroOption(MacroOptionKind kindPart, String optionName) {
            return this.supported.get((Object)kindPart).get(optionName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean enableOption(String optionString, HashSet<MacroOption> addedCheck, MacroOption context, Consumer<EnabledOption> enabler) {
            MacroOptionKind kindPart;
            String specString;
            if (context == null) {
                if (!optionString.startsWith(MacroOption.macroOptionPrefix)) return false;
                specString = optionString.substring(MacroOption.macroOptionPrefix.length());
            } else {
                specString = optionString;
            }
            String[] specParts = specString.split(":", 2);
            if (specParts.length != 2) {
                if (context != null) throw new VerboseInvalidMacroException("Invalid option specification: " + optionString, context);
                return false;
            }
            try {
                kindPart = MacroOptionKind.fromString(specParts[0]);
            }
            catch (Exception e) {
                if (context != null) throw new VerboseInvalidMacroException("Unknown kind in option specification: " + optionString, context);
                return false;
            }
            String specNameParts = specParts[1];
            if (specNameParts.isEmpty()) {
                throw new VerboseInvalidMacroException("Empty option specification: " + optionString, kindPart, context);
            }
            if (specNameParts.equals("all")) {
                if (!kindPart.allowAll) {
                    throw new VerboseInvalidMacroException("Empty option specification: " + (Object)((Object)kindPart) + " does no support 'all'", kindPart, context);
                }
                for (String optionName : this.getAvailableOptions(kindPart)) {
                    MacroOption option = this.getMacroOption(kindPart, optionName);
                    if (Boolean.parseBoolean(option.properties.getOrDefault("ExcludeFromAll", "false"))) continue;
                    this.enableResolved(option, null, addedCheck, context, enabler);
                }
                return true;
            }
            String[] parts = specNameParts.split("=", 2);
            String optionName = parts[0];
            MacroOption option = this.getMacroOption(kindPart, optionName);
            if (option == null) {
                throw new VerboseInvalidMacroException("Unknown name in option specification: " + (Object)((Object)kindPart) + ":" + optionName, kindPart, context);
            }
            String optionArg = parts.length == 2 ? parts[1] : null;
            this.enableResolved(option, optionArg, addedCheck, context, enabler);
            return true;
        }

        private void enableResolved(MacroOption option, String optionArg, HashSet<MacroOption> addedCheck, MacroOption context, Consumer<EnabledOption> enabler) {
            if (addedCheck.contains(option)) {
                return;
            }
            addedCheck.add(option);
            EnabledOption enabledOption = new EnabledOption(option, optionArg);
            String requires = enabledOption.getProperty("Requires", "");
            if (!requires.isEmpty()) {
                for (String specString : requires.split(" ")) {
                    this.enableOption(specString, addedCheck, option, enabler);
                }
            }
            MacroOption truffleOption = this.getMacroOption(MacroOptionKind.Macro, "truffle");
            if (option.kind.equals((Object)MacroOptionKind.Language) && !addedCheck.contains(truffleOption)) {
                this.enableResolved(truffleOption, null, addedCheck, context, enabler);
            }
            enabler.accept(enabledOption);
            this.enabled.add(enabledOption);
        }

        LinkedHashSet<EnabledOption> getEnabledOptions(MacroOptionKind kind) {
            return this.enabled.stream().filter(eo -> kind.equals((Object)((EnabledOption)eo).option.kind)).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        Stream<EnabledOption> getEnabledOptionsStream(MacroOptionKind kind, MacroOptionKind ... otherKinds) {
            EnumSet<MacroOptionKind[]> kindSet = EnumSet.of(kind, otherKinds);
            return this.enabled.stream().filter(eo -> kindSet.contains((Object)((EnabledOption)eo).option.kind));
        }

        LinkedHashSet<EnabledOption> getEnabledOptions() {
            return this.enabled;
        }

        EnabledOption getEnabledOption(MacroOption option) {
            return this.enabled.stream().filter(eo -> eo.getOption().equals(option)).findFirst().orElse(null);
        }
    }

    static final class EnabledOption {
        private final MacroOption option;
        private final String optionArg;

        private EnabledOption(MacroOption option, String optionArg) {
            this.option = Objects.requireNonNull(option);
            this.optionArg = optionArg;
        }

        private String resolvePropertyValue(String val) {
            return NativeImage.resolvePropertyValue(val, this.optionArg, this.getOption().optionDirectory.toString());
        }

        String getProperty(String key, String defaultVal) {
            String val = (String)this.option.properties.get(key);
            if (val == null) {
                return defaultVal;
            }
            return this.resolvePropertyValue(val);
        }

        String getProperty(String key) {
            return this.getProperty(key, null);
        }

        boolean forEachPropertyValue(String propertyKey, Consumer<String> target) {
            return this.forEachPropertyValue(propertyKey, target, " ");
        }

        boolean forEachPropertyValue(String propertyKey, Consumer<String> target, String separatorRegex) {
            return NativeImage.forEachPropertyValue((String)this.option.properties.get(propertyKey), target, this::resolvePropertyValue, separatorRegex);
        }

        MacroOption getOption() {
            return this.option;
        }
    }

    static final class AddedTwiceException
    extends RuntimeException {
        private final MacroOption option;
        private final MacroOption context;

        AddedTwiceException(MacroOption option, MacroOption context) {
            this.option = option;
            this.context = context;
        }

        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            if (this.context != null) {
                sb.append("MacroOption ").append(this.context.getDescription(false));
                if (this.option.equals(this.context)) {
                    sb.append(" cannot require itself");
                } else {
                    sb.append(" requires ").append(this.option.getDescription(false)).append(" more than once");
                }
            } else {
                sb.append("Command line option ").append(this.option.getDescription(true));
                sb.append(" used more than once");
            }
            return sb.toString();
        }
    }

    static final class VerboseInvalidMacroException
    extends RuntimeException {
        private final MacroOptionKind forKind;
        private final MacroOption context;

        VerboseInvalidMacroException(String arg0, MacroOption context) {
            this(arg0, null, context);
        }

        VerboseInvalidMacroException(String arg0, MacroOptionKind forKind, MacroOption context) {
            super(arg0);
            this.forKind = forKind;
            this.context = context;
        }

        public String getMessage(Registry registry) {
            StringBuilder sb = new StringBuilder();
            String message = super.getMessage();
            if (this.context != null) {
                sb.append(this.context.getDescription(false) + " contains ");
                if (!message.isEmpty()) {
                    sb.append(Character.toLowerCase(message.charAt(0)));
                    sb.append(message.substring(1));
                }
            } else {
                sb.append(message);
            }
            Consumer<String> lineOut = s -> sb.append("\n" + s);
            registry.showOptions(this.forKind, this.context == null, lineOut);
            return sb.toString();
        }
    }

    static final class InvalidMacroException
    extends RuntimeException {
        InvalidMacroException(String arg0) {
            super(arg0);
        }
    }

    static enum MacroOptionKind {
        Language("languages", true),
        Tool("tools", true),
        Macro("macros", false);

        final String subdir;
        final boolean allowAll;

        private MacroOptionKind(String subdir, boolean allowAll) {
            this.subdir = subdir;
            this.allowAll = allowAll;
        }

        static MacroOptionKind fromSubdir(String subdir) {
            for (MacroOptionKind kind : MacroOptionKind.values()) {
                if (!kind.subdir.equals(subdir)) continue;
                return kind;
            }
            throw new InvalidMacroException("No MacroOptionKind for subDir: " + subdir);
        }

        static MacroOptionKind fromString(String kindName) {
            for (MacroOptionKind kind : MacroOptionKind.values()) {
                if (!kind.toString().equals(kindName)) continue;
                return kind;
            }
            throw new InvalidMacroException("No MacroOptionKind for kindName: " + kindName);
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

