/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.AbstractHttp2StreamFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2PushPromiseFrame;
import io.netty.util.internal.ObjectUtil;

public class DefaultHttp2PushPromiseFrame
extends AbstractHttp2StreamFrame
implements Http2PushPromiseFrame {
    private final Http2Headers headers;
    private final boolean endStream;
    private final int padding;
    private final int promisedStreamId;

    public DefaultHttp2PushPromiseFrame(Http2Headers headers, int promisedStreamId) {
        this(headers, false, promisedStreamId);
    }

    public DefaultHttp2PushPromiseFrame(Http2Headers headers, boolean endStream, int promisedStreamId) {
        this(headers, endStream, 0, promisedStreamId);
    }

    public DefaultHttp2PushPromiseFrame(Http2Headers headers, boolean endStream, int padding, int promisedStreamId) {
        this.headers = (Http2Headers)ObjectUtil.checkNotNull((Object)headers, (String)"headers");
        this.endStream = endStream;
        Http2CodecUtil.verifyPadding((int)padding);
        this.padding = padding;
        this.promisedStreamId = promisedStreamId;
    }

    public DefaultHttp2PushPromiseFrame stream(Http2FrameStream stream) {
        super.stream(stream);
        return this;
    }

    public String name() {
        return "PUSH_PROMISE";
    }

    public Http2Headers headers() {
        return this.headers;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public int padding() {
        return this.padding;
    }

    @Override
    public int promisedStreamId() {
        return this.promisedStreamId;
    }

    public String toString() {
        return "DefaultHttp2PushPromiseFrame(streamId=" + this.stream().id() + ", headers=" + this.headers + ", endStream=" + this.endStream + ", padding=" + this.padding + ", promisedStreamId=" + this.promisedStreamId + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttp2PushPromiseFrame)) {
            return false;
        }
        DefaultHttp2PushPromiseFrame other = (DefaultHttp2PushPromiseFrame)o;
        return super.equals((Object)other) && this.headers.equals(other.headers) && this.endStream == other.endStream && this.padding == other.padding && this.promisedStreamId == other.promisedStreamId;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.headers.hashCode();
        hash = hash * 31 + (this.endStream ? 0 : 1);
        hash = hash * 31 + this.padding;
        hash = hash * 31 + this.promisedStreamId;
        return hash;
    }
}

