/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.stats.status;

import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.stats.status.StatusCategory;
import com.netflix.zuul.stats.status.ZuulStatusCategoryGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusCategoryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StatusCategoryUtils.class);

    public static StatusCategory getStatusCategory(ZuulMessage msg) {
        return StatusCategoryUtils.getStatusCategory(msg.getContext());
    }

    public static StatusCategory getStatusCategory(SessionContext ctx) {
        return (StatusCategory)ctx.get("status_category");
    }

    public static void setStatusCategory(SessionContext ctx, StatusCategory statusCategory) {
        ctx.set("status_category", statusCategory);
    }

    public static StatusCategory getOriginStatusCategory(SessionContext ctx) {
        return (StatusCategory)ctx.get("origin_status_category");
    }

    public static boolean isResponseHttpErrorStatus(HttpResponseMessage response) {
        boolean isHttpError = false;
        if (response != null) {
            int status = response.getStatus();
            isHttpError = StatusCategoryUtils.isResponseHttpErrorStatus(status);
        }
        return isHttpError;
    }

    public static boolean isResponseHttpErrorStatus(int status) {
        return status < 100 || status >= 500;
    }

    public static void storeStatusCategoryIfNotAlreadyFailure(SessionContext context, StatusCategory statusCategory) {
        StatusCategory nfs;
        if (statusCategory != null && ((nfs = (StatusCategory)context.get("status_category")) == null || nfs.getGroup().getId() == ZuulStatusCategoryGroup.SUCCESS.getId())) {
            context.set("status_category", statusCategory);
        }
    }
}

