/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpRequest;

@ChannelHandler.Sharable
public class Http2StreamHeaderCleaner
extends ChannelInboundHandlerAdapter {
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            for (String name : req.headers().names()) {
                if (!name.startsWith("x-http2-")) continue;
                req.headers().remove(name);
            }
        }
        super.channelRead(ctx, msg);
    }
}

