/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server.http2;

import com.netflix.config.DynamicBooleanProperty;
import com.netflix.zuul.netty.ssl.SslContextFactory;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import javax.net.ssl.SSLException;

public class Http2Configuration {
    private static final DynamicBooleanProperty HTTP2_DISABLED = new DynamicBooleanProperty("zuul.server.http2.disabled", false);

    public static SslContext configureSSL(SslContextFactory sslContextFactory, int port) {
        SslContext sslContext;
        SslContextBuilder builder = sslContextFactory.createBuilderForServer();
        String[] supportedProtocol = HTTP2_DISABLED.get() ? new String[]{"http/1.1"} : new String[]{"h2", "http/1.1"};
        ApplicationProtocolConfig apn = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocol);
        try {
            sslContext = builder.applicationProtocolConfig(apn).build();
        }
        catch (SSLException e) {
            throw new RuntimeException("Error configuring SslContext with ALPN!", e);
        }
        sslContextFactory.enableSessionTickets(sslContext);
        sslContextFactory.configureOpenSslStatsMetrics(sslContext, Integer.toString(port));
        return sslContext;
    }
}

