/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import java.util.concurrent.Callable;
import java.util.function.BiConsumer;

public class MethodBinding<T> {
    private final BiConsumer<Runnable, T> boundMethod;
    private final Callable<T> bindingContextExtractor;
    public static MethodBinding<?> NO_OP_BINDING = new MethodBinding<Object>((r, t) -> {}, () -> null);

    public MethodBinding(BiConsumer<Runnable, T> boundMethod, Callable<T> bindingContextExtractor) {
        this.boundMethod = boundMethod;
        this.bindingContextExtractor = bindingContextExtractor;
    }

    public void bind(Runnable method) throws Exception {
        T bindingContext = this.bindingContextExtractor.call();
        if (bindingContext == null) {
            method.run();
        } else {
            this.boundMethod.accept(method, (Runnable)bindingContext);
        }
    }
}

