/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.server;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.config.ChainedDynamicProperty;
import com.netflix.config.DynamicBooleanProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.discovery.EurekaClient;
import com.netflix.netty.common.accesslog.AccessLogPublisher;
import com.netflix.netty.common.channel.config.ChannelConfig;
import com.netflix.netty.common.channel.config.ChannelConfigValue;
import com.netflix.netty.common.channel.config.CommonChannelConfigKeys;
import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import com.netflix.netty.common.proxyprotocol.StripUntrustedProxyHeadersHandler;
import com.netflix.netty.common.ssl.ServerSslConfig;
import com.netflix.netty.common.status.ServerStatusManager;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.BasicCounter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.RequestCompleteHandler;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.netty.ratelimiting.NullChannelHandlerProvider;
import com.netflix.zuul.netty.server.ClientConnectionsShutdown;
import com.netflix.zuul.netty.server.DirectMemoryMonitor;
import com.netflix.zuul.netty.server.Server;
import com.netflix.zuul.netty.server.ServerTimeout;
import com.netflix.zuul.netty.server.ZuulDependencyKeys;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServerStartup {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseServerStartup.class);
    protected final ServerStatusManager serverStatusManager;
    protected final Registry registry;
    protected final DirectMemoryMonitor directMemoryMonitor;
    protected final EventLoopGroupMetrics eventLoopGroupMetrics;
    protected final EurekaClient discoveryClient;
    protected final ApplicationInfoManager applicationInfoManager;
    protected final AccessLogPublisher accessLogPublisher;
    protected final SessionContextDecorator sessionCtxDecorator;
    protected final RequestCompleteHandler reqCompleteHandler;
    protected final FilterLoader filterLoader;
    protected final FilterUsageNotifier usageNotifier;
    private Map<Integer, ChannelInitializer> portsToChannelInitializers;
    private ClientConnectionsShutdown clientConnectionsShutdown;
    private Server server;

    @Inject
    public BaseServerStartup(ServerStatusManager serverStatusManager, FilterLoader filterLoader, SessionContextDecorator sessionCtxDecorator, FilterUsageNotifier usageNotifier, RequestCompleteHandler reqCompleteHandler, Registry registry, DirectMemoryMonitor directMemoryMonitor, EventLoopGroupMetrics eventLoopGroupMetrics, EurekaClient discoveryClient, ApplicationInfoManager applicationInfoManager, AccessLogPublisher accessLogPublisher) {
        this.serverStatusManager = serverStatusManager;
        this.registry = registry;
        this.directMemoryMonitor = directMemoryMonitor;
        this.eventLoopGroupMetrics = eventLoopGroupMetrics;
        this.discoveryClient = discoveryClient;
        this.applicationInfoManager = applicationInfoManager;
        this.accessLogPublisher = accessLogPublisher;
        this.sessionCtxDecorator = sessionCtxDecorator;
        this.reqCompleteHandler = reqCompleteHandler;
        this.filterLoader = filterLoader;
        this.usageNotifier = usageNotifier;
    }

    public Server server() {
        return this.server;
    }

    @PostConstruct
    public void init() throws Exception {
        DefaultChannelGroup clientChannels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.clientConnectionsShutdown = new ClientConnectionsShutdown((ChannelGroup)clientChannels, (EventExecutor)GlobalEventExecutor.INSTANCE, this.discoveryClient);
        this.portsToChannelInitializers = this.choosePortsAndChannels((ChannelGroup)clientChannels);
        this.directMemoryMonitor.init();
        this.server = new Server(this.portsToChannelInitializers, this.serverStatusManager, this.clientConnectionsShutdown, this.eventLoopGroupMetrics);
    }

    protected abstract Map<Integer, ChannelInitializer> choosePortsAndChannels(ChannelGroup var1);

    protected ChannelConfig defaultChannelDependencies(String portName) {
        ChannelConfig channelDependencies = new ChannelConfig();
        this.addChannelDependencies(channelDependencies, portName);
        return channelDependencies;
    }

    protected void addChannelDependencies(ChannelConfig channelDeps, String portName) {
        channelDeps.set(ZuulDependencyKeys.registry, this.registry);
        channelDeps.set(ZuulDependencyKeys.applicationInfoManager, this.applicationInfoManager);
        channelDeps.set(ZuulDependencyKeys.serverStatusManager, this.serverStatusManager);
        channelDeps.set(ZuulDependencyKeys.accessLogPublisher, this.accessLogPublisher);
        channelDeps.set(ZuulDependencyKeys.sessionCtxDecorator, this.sessionCtxDecorator);
        channelDeps.set(ZuulDependencyKeys.requestCompleteHandler, this.reqCompleteHandler);
        BasicCounter httpRequestReadTimeoutCounter = new BasicCounter(MonitorConfig.builder((String)"server.http.request.read.timeout").build());
        DefaultMonitorRegistry.getInstance().register((Monitor)httpRequestReadTimeoutCounter);
        channelDeps.set(ZuulDependencyKeys.httpRequestReadTimeoutCounter, httpRequestReadTimeoutCounter);
        channelDeps.set(ZuulDependencyKeys.filterLoader, this.filterLoader);
        channelDeps.set(ZuulDependencyKeys.filterUsageNotifier, this.usageNotifier);
        channelDeps.set(ZuulDependencyKeys.eventLoopGroupMetrics, this.eventLoopGroupMetrics);
        channelDeps.set(ZuulDependencyKeys.sslClientCertCheckChannelHandlerProvider, new NullChannelHandlerProvider());
        channelDeps.set(ZuulDependencyKeys.rateLimitingChannelHandlerProvider, new NullChannelHandlerProvider());
    }

    public static int chooseIntChannelProperty(String portName, String propertySuffix, int defaultValue) {
        String globalPropertyName = "server." + propertySuffix;
        String portPropertyName = "server." + portName + "." + propertySuffix;
        Integer value = new DynamicIntProperty(portPropertyName, -999).get();
        if (value == -999 && (value = Integer.valueOf(new DynamicIntProperty(globalPropertyName, -999).get())) == -999) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean chooseBooleanChannelProperty(String portName, String propertySuffix, boolean defaultValue) {
        String globalPropertyName = "server." + propertySuffix;
        String portPropertyName = "server." + portName + "." + propertySuffix;
        Boolean value = new ChainedDynamicProperty.DynamicBooleanPropertyThatSupportsNull(portPropertyName, null).get();
        if (value == null && (value = new DynamicBooleanProperty(globalPropertyName, defaultValue).getDynamicProperty().getBoolean()) == null) {
            value = defaultValue;
        }
        return value;
    }

    public static ChannelConfig defaultChannelConfig(String portName) {
        ChannelConfig config = new ChannelConfig();
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxConnections, BaseServerStartup.chooseIntChannelProperty(portName, "connection.max", 20000)));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnection, BaseServerStartup.chooseIntChannelProperty(portName, "connection.max.requests", 20000)));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnectionInBrownout, BaseServerStartup.chooseIntChannelProperty(portName, "connection.max.requests.brownout", CommonChannelConfigKeys.maxRequestsPerConnectionInBrownout.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.connectionExpiry, BaseServerStartup.chooseIntChannelProperty(portName, "connection.expiry", CommonChannelConfigKeys.connectionExpiry.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.httpRequestReadTimeout, BaseServerStartup.chooseIntChannelProperty(portName, "http.request.read.timeout", 5000)));
        int connectionIdleTimeout = BaseServerStartup.chooseIntChannelProperty(portName, "connection.idle.timeout", 65000);
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.idleTimeout, connectionIdleTimeout));
        config.add(new ChannelConfigValue<ServerTimeout>(CommonChannelConfigKeys.serverTimeout, new ServerTimeout(connectionIdleTimeout)));
        config.add(new ChannelConfigValue<StripUntrustedProxyHeadersHandler.AllowWhen>(CommonChannelConfigKeys.allowProxyHeadersWhen, StripUntrustedProxyHeadersHandler.AllowWhen.NEVER));
        config.set(CommonChannelConfigKeys.withProxyProtocol, true);
        config.set(CommonChannelConfigKeys.preferProxyProtocolForClientIp, true);
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.connCloseDelay, BaseServerStartup.chooseIntChannelProperty(portName, "connection.close.delay", 10)));
        return config;
    }

    public static void addHttp2DefaultConfig(ChannelConfig config, String portName) {
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxConcurrentStreams, BaseServerStartup.chooseIntChannelProperty(portName, "http2.max.concurrent.streams", CommonChannelConfigKeys.maxConcurrentStreams.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.initialWindowSize, BaseServerStartup.chooseIntChannelProperty(portName, "http2.initialwindowsize", CommonChannelConfigKeys.initialWindowSize.defaultValue())));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxHttp2HeaderTableSize, BaseServerStartup.chooseIntChannelProperty(portName, "http2.maxheadertablesize", 65536)));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxHttp2HeaderListSize, BaseServerStartup.chooseIntChannelProperty(portName, "http2.maxheaderlistsize", 32768)));
        config.add(new ChannelConfigValue<Integer>(CommonChannelConfigKeys.maxRequestsPerConnection, BaseServerStartup.chooseIntChannelProperty(portName, "connection.max.requests", 4000)));
    }

    protected void logPortConfigured(int port, ServerSslConfig serverSslConfig) {
        String msg = "Configured port: " + port;
        if (serverSslConfig != null) {
            msg = msg + " with SSL config: " + serverSslConfig.toString();
        }
        LOG.warn(msg);
    }
}

