/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.insights;

import com.netflix.config.CachedDynamicLongProperty;
import com.netflix.netty.common.HttpLifecycleChannelHandler;
import com.netflix.netty.common.metrics.HttpMetricsChannelHandler;
import com.netflix.netty.common.metrics.ServerChannelMetrics;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.ChannelUtils;
import com.netflix.zuul.netty.server.ClientRequestReceiver;
import com.netflix.zuul.niws.RequestAttempts;
import com.netflix.zuul.passport.CurrentPassport;
import com.netflix.zuul.passport.PassportState;
import com.netflix.zuul.passport.StartAndEnd;
import com.netflix.zuul.stats.status.StatusCategoryUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PassportLoggingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PassportLoggingHandler.class);
    private static final CachedDynamicLongProperty WARN_REQ_PROCESSING_TIME_NS = new CachedDynamicLongProperty("zuul.passport.log.request.time.threshold", 1000000000L);
    private static final CachedDynamicLongProperty WARN_RESP_PROCESSING_TIME_NS = new CachedDynamicLongProperty("zuul.passport.log.response.time.threshold", 1000000000L);
    private final Counter incompleteProxySessionCounter;

    public PassportLoggingHandler(Registry spectatorRegistry) {
        this.incompleteProxySessionCounter = spectatorRegistry.counter("server.http.session.incomplete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            super.userEventTriggered(ctx, evt);
        }
        finally {
            if (evt instanceof HttpLifecycleChannelHandler.CompleteEvent) {
                try {
                    this.logPassport(ctx.channel());
                }
                catch (Exception e) {
                    LOG.error("Error logging passport info after request completed!", (Throwable)e);
                }
            }
        }
    }

    private void logPassport(Channel channel) {
        CurrentPassport passport = CurrentPassport.fromChannel(channel);
        HttpRequestMessage request = ClientRequestReceiver.getRequestFromChannel(channel);
        HttpResponseMessage response = ClientRequestReceiver.getResponseFromChannel(channel);
        SessionContext ctx = request == null ? null : request.getContext();
        String topLevelRequestId = this.getRequestId(channel, ctx);
        if (LOG.isDebugEnabled()) {
            LOG.debug("State after complete. , current-server-conns = " + ServerChannelMetrics.currentConnectionCountFromChannel(channel) + ", current-http-reqs = " + HttpMetricsChannelHandler.getInflightRequestCountFromChannel(channel) + ", status = " + (response == null ? this.getRequestId(channel, ctx) : Integer.valueOf(response.getStatus())) + ", nfstatus = " + String.valueOf(StatusCategoryUtils.getStatusCategory(ctx)) + ", toplevelid = " + topLevelRequestId + ", req = " + request.getInfoForLogging() + ", passport = " + String.valueOf(passport));
        }
        if (LOG.isInfoEnabled()) {
            StartAndEnd inRespToOutResp;
            StartAndEnd inReqToOutResp;
            if (passport.wasProxyAttempt() && passport.findStateBackwards(PassportState.OUT_RESP_LAST_CONTENT_SENDING) == null) {
                this.incompleteProxySessionCounter.increment();
                LOG.info("Incorrect final state! toplevelid = " + topLevelRequestId + ", " + ChannelUtils.channelInfoForLogging(channel));
            }
            if (!passport.wasProxyAttempt() && ctx != null && !this.isHealthcheckRequest(request)) {
                RequestAttempts attempts = RequestAttempts.getFromSessionContext(ctx);
                LOG.debug("State after complete. , context-error = " + String.valueOf(ctx.getError()) + ", current-http-reqs = " + HttpMetricsChannelHandler.getInflightRequestCountFromChannel(channel) + ", toplevelid = " + topLevelRequestId + ", req = " + request.getInfoForLogging() + ", attempts = " + String.valueOf(attempts) + ", passport = " + String.valueOf(passport));
            }
            if (passport.calculateTimeBetween(inReqToOutResp = passport.findFirstStartAndLastEndStates(PassportState.IN_REQ_HEADERS_RECEIVED, PassportState.OUT_REQ_LAST_CONTENT_SENT)) > WARN_REQ_PROCESSING_TIME_NS.get()) {
                LOG.info("Request processing took longer than threshold! toplevelid = " + topLevelRequestId + ", " + ChannelUtils.channelInfoForLogging(channel));
            }
            if (passport.calculateTimeBetween(inRespToOutResp = passport.findLastStartAndFirstEndStates(PassportState.IN_RESP_HEADERS_RECEIVED, PassportState.OUT_RESP_LAST_CONTENT_SENT)) > WARN_RESP_PROCESSING_TIME_NS.get()) {
                LOG.info("Response processing took longer than threshold! toplevelid = " + topLevelRequestId + ", " + ChannelUtils.channelInfoForLogging(channel));
            }
        }
    }

    protected boolean isHealthcheckRequest(HttpRequestMessage req) {
        return req.getPath().equals("/healthcheck");
    }

    protected String getRequestId(Channel channel, SessionContext ctx) {
        return ctx == null ? "-" : ctx.getUUID();
    }
}

