/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.filter;

import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.spectator.impl.Preconditions;
import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.FilterUsageNotifier;
import com.netflix.zuul.context.Debug;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.exception.ZuulException;
import com.netflix.zuul.filters.FilterError;
import com.netflix.zuul.filters.FilterSyncType;
import com.netflix.zuul.filters.FilterType;
import com.netflix.zuul.filters.SyncZuulFilter;
import com.netflix.zuul.filters.ZuulFilter;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.netty.filter.FilterRunner;
import com.netflix.zuul.netty.server.MethodBinding;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observer;
import rx.schedulers.Schedulers;

@ThreadSafe
public abstract class BaseZuulFilterRunner<I extends ZuulMessage, O extends ZuulMessage>
implements FilterRunner<I, O> {
    private final FilterUsageNotifier usageNotifier;
    private final FilterRunner<O, ? extends ZuulMessage> nextStage;
    private final String RUNNING_FILTER_IDX_SESSION_CTX_KEY;
    private final String AWAITING_BODY_FLAG_SESSION_CTX_KEY;
    private static final Logger LOG = LoggerFactory.getLogger(BaseZuulFilterRunner.class);
    private static final CachedDynamicIntProperty FILTER_EXCESSIVE_EXEC_TIME = new CachedDynamicIntProperty("zuul.filters.excessive.execTime", 500);

    protected BaseZuulFilterRunner(FilterType filterType, FilterUsageNotifier usageNotifier, FilterRunner<O, ?> nextStage) {
        this.usageNotifier = (FilterUsageNotifier)Preconditions.checkNotNull((Object)usageNotifier, (String)"filter usage notifier");
        this.nextStage = nextStage;
        this.RUNNING_FILTER_IDX_SESSION_CTX_KEY = (Object)((Object)filterType) + "RunningFilterIndex";
        this.AWAITING_BODY_FLAG_SESSION_CTX_KEY = (Object)((Object)filterType) + "IsAwaitingBody";
    }

    public static final ChannelHandlerContext getChannelHandlerContext(ZuulMessage mesg) {
        return (ChannelHandlerContext)com.google.common.base.Preconditions.checkNotNull(mesg.getContext().get("_netty_server_channel_handler_context"), (Object)"channel handler context");
    }

    public FilterRunner<O, ? extends ZuulMessage> getNextStage() {
        return this.nextStage;
    }

    protected final AtomicInteger initRunningFilterIndex(I zuulMesg) {
        AtomicInteger idx = new AtomicInteger(0);
        zuulMesg.getContext().put(this.RUNNING_FILTER_IDX_SESSION_CTX_KEY, idx);
        return idx;
    }

    protected final AtomicInteger getRunningFilterIndex(I zuulMesg) {
        SessionContext ctx = zuulMesg.getContext();
        return (AtomicInteger)Preconditions.checkNotNull(ctx.get(this.RUNNING_FILTER_IDX_SESSION_CTX_KEY), (String)"runningFilterIndex");
    }

    protected final boolean isFilterAwaitingBody(I zuulMesg) {
        return zuulMesg.getContext().containsKey(this.AWAITING_BODY_FLAG_SESSION_CTX_KEY);
    }

    protected final void setFilterAwaitingBody(I zuulMesg, boolean flag) {
        if (flag) {
            zuulMesg.getContext().put(this.AWAITING_BODY_FLAG_SESSION_CTX_KEY, Boolean.TRUE);
        } else {
            zuulMesg.getContext().remove(this.AWAITING_BODY_FLAG_SESSION_CTX_KEY);
        }
    }

    protected final void invokeNextStage(O zuulMesg, HttpContent chunk) {
        if (this.nextStage != null) {
            this.nextStage.filter(zuulMesg, chunk);
        } else {
            BaseZuulFilterRunner.getChannelHandlerContext(zuulMesg).fireChannelRead((Object)chunk);
        }
    }

    protected final void invokeNextStage(O zuulMesg) {
        if (this.nextStage != null) {
            this.nextStage.filter(zuulMesg);
        } else {
            BaseZuulFilterRunner.getChannelHandlerContext(zuulMesg).fireChannelRead(zuulMesg);
        }
    }

    protected final O filter(ZuulFilter<I, O> filter, I inMesg) {
        long startTime = System.currentTimeMillis();
        ZuulMessage snapshot = inMesg.getContext().debugRouting() ? inMesg.clone() : null;
        FilterChainResumer resumer = null;
        try {
            ExecutionStatus filterRunStatus = null;
            if (filter.filterType() == FilterType.INBOUND && inMesg.getContext().shouldSendErrorResponse()) {
                filterRunStatus = ExecutionStatus.SKIPPED;
            }
            if (this.shouldSkipFilter(inMesg, filter)) {
                filterRunStatus = ExecutionStatus.SKIPPED;
            }
            if (filter.isDisabled()) {
                filterRunStatus = ExecutionStatus.DISABLED;
            }
            if (filterRunStatus != null) {
                this.recordFilterCompletion(filterRunStatus, filter, startTime, (ZuulMessage)inMesg, snapshot);
                return filter.getDefaultOutput(inMesg);
            }
            if (!this.isMessageBodyReadyForFilter(filter, inMesg)) {
                this.setFilterAwaitingBody(inMesg, true);
                LOG.debug("Filter {} waiting for body, UUID {}", (Object)filter.filterName(), (Object)inMesg.getContext().getUUID());
                return null;
            }
            this.setFilterAwaitingBody(inMesg, false);
            if (snapshot != null) {
                Debug.addRoutingDebug(inMesg.getContext(), "Filter " + filter.filterType().toString() + " " + filter.filterOrder() + " " + filter.filterName());
            }
            inMesg.runBufferedBodyContentThroughFilter(filter);
            if (filter.getSyncType() == FilterSyncType.SYNC) {
                SyncZuulFilter syncFilter = (SyncZuulFilter)filter;
                Object outMesg = syncFilter.apply(inMesg);
                this.recordFilterCompletion(ExecutionStatus.SUCCESS, filter, startTime, (ZuulMessage)inMesg, snapshot);
                return outMesg != null ? outMesg : filter.getDefaultOutput(inMesg);
            }
            filter.incrementConcurrency();
            resumer = new FilterChainResumer(this, inMesg, filter, snapshot, startTime);
            filter.applyAsync(inMesg).observeOn(Schedulers.from((Executor)BaseZuulFilterRunner.getChannelHandlerContext(inMesg).executor())).doOnUnsubscribe(resumer::decrementConcurrency).subscribe((Observer)resumer);
            return null;
        }
        catch (Throwable t) {
            if (resumer != null) {
                resumer.decrementConcurrency();
            }
            O outMesg = this.handleFilterException(inMesg, filter, t);
            outMesg.finishBufferedBodyIfIncomplete();
            this.recordFilterCompletion(ExecutionStatus.FAILED, filter, startTime, (ZuulMessage)inMesg, snapshot);
            return outMesg;
        }
    }

    protected final boolean shouldSkipFilter(I inMesg, ZuulFilter<I, O> filter) {
        if (filter.filterType() == FilterType.ENDPOINT) {
            return false;
        }
        SessionContext zuulCtx = inMesg.getContext();
        if (zuulCtx.shouldStopFilterProcessing() && !filter.overrideStopFilterProcessing()) {
            return true;
        }
        if (zuulCtx.isCancelled()) {
            return true;
        }
        return !filter.shouldFilter(inMesg);
    }

    private boolean isMessageBodyReadyForFilter(ZuulFilter filter, I inMesg) {
        return !filter.needsBodyBuffered(inMesg) || inMesg.hasCompleteBody();
    }

    protected O handleFilterException(I inMesg, ZuulFilter<I, O> filter, Throwable ex) {
        inMesg.getContext().setError(ex);
        if (filter.filterType() == FilterType.ENDPOINT) {
            inMesg.getContext().setShouldSendErrorResponse(true);
        }
        this.recordFilterError(inMesg, filter, ex);
        return filter.getDefaultOutput(inMesg);
    }

    protected void recordFilterError(I inMesg, ZuulFilter<I, O> filter, Throwable t) {
        String errorMsg = "Filter Exception: filter=" + filter.filterName() + ", request-info=" + inMesg.getInfoForLogging() + ", msg=" + String.valueOf(t.getMessage());
        if (t instanceof ZuulException && !((ZuulException)t).shouldLogAsError()) {
            LOG.warn(errorMsg);
        } else {
            LOG.error(errorMsg, t);
        }
        SessionContext zuulCtx = inMesg.getContext();
        zuulCtx.getFilterErrors().add(new FilterError(filter.filterName(), filter.filterType().toString(), t));
        if (zuulCtx.debugRouting()) {
            Debug.addRoutingDebug(zuulCtx, "Running Filter failed " + filter.filterName() + " type:" + (Object)((Object)filter.filterType()) + " order:" + filter.filterOrder() + " " + t.getMessage());
        }
    }

    protected void recordFilterCompletion(ExecutionStatus status, ZuulFilter<I, O> filter, long startTime, ZuulMessage zuulMesg, ZuulMessage startSnapshot) {
        SessionContext zuulCtx = zuulMesg.getContext();
        long execTime = System.currentTimeMillis() - startTime;
        if (execTime >= (long)FILTER_EXCESSIVE_EXEC_TIME.get()) {
            LOG.warn("Filter {} took {} ms to complete! status = {}", new Object[]{filter.filterName(), execTime, status.name()});
        }
        switch (status) {
            case FAILED: {
                zuulCtx.addFilterExecutionSummary(filter.filterName(), ExecutionStatus.FAILED.name(), execTime);
                break;
            }
            case SUCCESS: {
                zuulCtx.addFilterExecutionSummary(filter.filterName(), ExecutionStatus.SUCCESS.name(), execTime);
                if (startSnapshot == null) break;
                Debug.addRoutingDebug(zuulCtx, "Filter {" + filter.filterName() + " TYPE:" + filter.filterType().toString() + " ORDER:" + filter.filterOrder() + "} Execution time = " + execTime + "ms");
                Debug.compareContextState(filter.filterName(), zuulCtx, startSnapshot.getContext());
                break;
            }
        }
        LOG.debug("Filter {} completed with status {}, UUID {}", new Object[]{filter.filterName(), status.name(), zuulMesg.getContext().getUUID()});
        this.usageNotifier.notify(filter, status);
    }

    protected void handleException(ZuulMessage zuulMesg, String filterName, Exception ex) {
        HttpRequestInfo zuulReq = null;
        if (zuulMesg instanceof HttpRequestMessage) {
            zuulReq = (HttpRequestMessage)zuulMesg;
        } else if (zuulMesg instanceof HttpResponseMessage) {
            zuulReq = ((HttpResponseMessage)zuulMesg).getInboundRequest();
        }
        String path = zuulReq != null ? zuulReq.getPathAndQuery() : "-";
        String method = zuulReq != null ? zuulReq.getMethod() : "-";
        String errMesg = "Error with filter: " + filterName + ", path: " + path + ", method: " + method;
        LOG.error(errMesg, (Throwable)ex);
        BaseZuulFilterRunner.getChannelHandlerContext(zuulMesg).fireExceptionCaught((Throwable)ex);
    }

    protected abstract void resume(O var1);

    protected MethodBinding<?> methodBinding(ZuulMessage zuulMesg) {
        return MethodBinding.NO_OP_BINDING;
    }

    protected void resumeInBindingContext(O zuulMesg, String filterName) {
        try {
            this.methodBinding((ZuulMessage)zuulMesg).bind(() -> this.resume(zuulMesg));
        }
        catch (Exception ex) {
            this.handleException((ZuulMessage)zuulMesg, filterName, ex);
        }
    }

    private final class FilterChainResumer
    implements Observer<O> {
        private final I inMesg;
        private final ZuulFilter<I, O> filter;
        private ZuulMessage snapshot;
        private final long startTime;
        private AtomicBoolean concurrencyDecremented;
        final /* synthetic */ BaseZuulFilterRunner this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public FilterChainResumer(I filter, ZuulFilter<I, O> snapshot, ZuulMessage startTime, long l2) {
            void inMesg;
            this.this$0 = (BaseZuulFilterRunner)l;
            this.inMesg = (ZuulMessage)Preconditions.checkNotNull((Object)inMesg, (String)"input message");
            this.filter = (ZuulFilter)Preconditions.checkNotNull(filter, (String)"filter");
            this.snapshot = snapshot;
            this.startTime = (long)startTime;
            this.concurrencyDecremented = new AtomicBoolean(false);
        }

        void decrementConcurrency() {
            if (this.concurrencyDecremented.compareAndSet(false, true)) {
                this.filter.decrementConcurrency();
            }
        }

        public void onNext(O outMesg) {
            try {
                this.this$0.recordFilterCompletion(ExecutionStatus.SUCCESS, this.filter, this.startTime, (ZuulMessage)this.inMesg, this.snapshot);
                if (outMesg == null) {
                    outMesg = this.filter.getDefaultOutput(this.inMesg);
                }
                this.this$0.resumeInBindingContext(outMesg, this.filter.filterName());
            }
            catch (Exception e) {
                this.decrementConcurrency();
                this.this$0.handleException((ZuulMessage)this.inMesg, this.filter.filterName(), e);
            }
        }

        public void onError(Throwable ex) {
            try {
                this.decrementConcurrency();
                this.this$0.recordFilterCompletion(ExecutionStatus.FAILED, this.filter, this.startTime, (ZuulMessage)this.inMesg, this.snapshot);
                Object outMesg = this.this$0.handleFilterException(this.inMesg, this.filter, ex);
                this.this$0.resumeInBindingContext(outMesg, this.filter.filterName());
            }
            catch (Exception e) {
                this.this$0.handleException((ZuulMessage)this.inMesg, this.filter.filterName(), e);
            }
        }

        public void onCompleted() {
            this.decrementConcurrency();
        }
    }
}

