/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.config.CachedDynamicBooleanProperty;
import com.netflix.config.CachedDynamicIntProperty;
import com.netflix.zuul.netty.connectionpool.ConnectionPoolConfig;

public class ConnectionPoolConfigImpl
implements ConnectionPoolConfig {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final int DEFAULT_CONNECT_TIMEOUT = 500;
    private static final int DEFAULT_IDLE_TIMEOUT = 60000;
    private static final int DEFAULT_MAX_CONNS_PER_HOST = 50;
    private final String originName;
    private final IClientConfig clientConfig;
    private final CachedDynamicIntProperty MAX_REQUESTS_PER_CONNECTION;
    private final CachedDynamicIntProperty PER_SERVER_WATERLINE;
    private final CachedDynamicBooleanProperty SOCKET_KEEP_ALIVE;
    private final CachedDynamicBooleanProperty TCP_NO_DELAY;
    private final CachedDynamicIntProperty WRITE_BUFFER_HIGH_WATER_MARK;
    private final CachedDynamicIntProperty WRITE_BUFFER_LOW_WATER_MARK;
    private final CachedDynamicBooleanProperty AUTO_READ;

    public ConnectionPoolConfigImpl(String originName, IClientConfig clientConfig) {
        this.originName = originName;
        this.clientConfig = clientConfig;
        this.MAX_REQUESTS_PER_CONNECTION = new CachedDynamicIntProperty(originName + ".netty.client.maxRequestsPerConnection", 1000);
        this.PER_SERVER_WATERLINE = new CachedDynamicIntProperty(originName + ".netty.client.perServerWaterline", 4);
        this.SOCKET_KEEP_ALIVE = new CachedDynamicBooleanProperty(originName + ".netty.client.TcpKeepAlive", false);
        this.TCP_NO_DELAY = new CachedDynamicBooleanProperty(originName + ".netty.client.TcpNoDelay", false);
        this.WRITE_BUFFER_HIGH_WATER_MARK = new CachedDynamicIntProperty(originName + ".netty.client.WriteBufferHighWaterMark", 32768);
        this.WRITE_BUFFER_LOW_WATER_MARK = new CachedDynamicIntProperty(originName + ".netty.client.WriteBufferLowWaterMark", 8192);
        this.AUTO_READ = new CachedDynamicBooleanProperty(originName + ".netty.client.AutoRead", false);
    }

    @Override
    public String getOriginName() {
        return this.originName;
    }

    @Override
    public int getConnectTimeout() {
        return this.clientConfig.getPropertyAsInteger(IClientConfigKey.Keys.ConnectTimeout, 500);
    }

    @Override
    public int getMaxRequestsPerConnection() {
        return this.MAX_REQUESTS_PER_CONNECTION.get();
    }

    @Override
    public int maxConnectionsPerHost() {
        return this.clientConfig.getPropertyAsInteger(IClientConfigKey.Keys.MaxConnectionsPerHost, 50);
    }

    @Override
    public int perServerWaterline() {
        return this.PER_SERVER_WATERLINE.get();
    }

    @Override
    public int getIdleTimeout() {
        return this.clientConfig.getPropertyAsInteger(IClientConfigKey.Keys.ConnIdleEvictTimeMilliSeconds, 60000);
    }

    @Override
    public boolean getTcpKeepAlive() {
        return this.SOCKET_KEEP_ALIVE.get();
    }

    @Override
    public boolean getTcpNoDelay() {
        return this.TCP_NO_DELAY.get();
    }

    @Override
    public int getTcpReceiveBufferSize() {
        return this.clientConfig.getPropertyAsInteger(IClientConfigKey.Keys.ReceiveBufferSize, 32768);
    }

    @Override
    public int getTcpSendBufferSize() {
        return this.clientConfig.getPropertyAsInteger(IClientConfigKey.Keys.SendBufferSize, 32768);
    }

    @Override
    public int getNettyWriteBufferHighWaterMark() {
        return this.WRITE_BUFFER_HIGH_WATER_MARK.get();
    }

    @Override
    public int getNettyWriteBufferLowWaterMark() {
        return this.WRITE_BUFFER_LOW_WATER_MARK.get();
    }

    @Override
    public boolean getNettyAutoRead() {
        return this.AUTO_READ.get();
    }

    @Override
    public boolean isSecure() {
        return this.clientConfig.getPropertyAsBoolean(IClientConfigKey.Keys.IsSecure, false);
    }

    @Override
    public boolean useIPAddrForServer() {
        return this.clientConfig.getPropertyAsBoolean(IClientConfigKey.Keys.UseIPAddrForServer, true);
    }
}

