/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty.connectionpool;

import com.netflix.zuul.netty.connectionpool.PooledConnection;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientTimeoutHandler
extends CombinedChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTimeoutHandler.class);
    public static final AttributeKey<Integer> ORIGIN_RESPONSE_READ_TIMEOUT = AttributeKey.newInstance((String)"originResponseReadTimeout");

    public ClientTimeoutHandler() {
        super((ChannelInboundHandler)new InboundHandler(), (ChannelOutboundHandler)new OutboundHandler());
    }

    private static class OutboundHandler
    extends ChannelOutboundHandlerAdapter {
        private OutboundHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            try {
                Integer timeout = (Integer)ctx.channel().attr(ORIGIN_RESPONSE_READ_TIMEOUT).get();
                if (timeout != null && msg instanceof LastHttpContent) {
                    promise.addListener(e -> {
                        LOG.debug("[{}] Adding read timeout handler: {}", (Object)ctx.channel().id(), (Object)timeout);
                        PooledConnection.getFromChannel(ctx.channel()).startReadTimeoutHandler(timeout);
                    });
                }
            }
            finally {
                super.write(ctx, msg, promise);
            }
        }
    }

    private static class InboundHandler
    extends ChannelInboundHandlerAdapter {
        private InboundHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            try {
                if (msg instanceof LastHttpContent) {
                    LOG.debug("[{}] Removing read timeout handler", (Object)ctx.channel().id());
                    PooledConnection.getFromChannel(ctx.channel()).removeReadTimeoutHandler();
                }
            }
            finally {
                super.channelRead(ctx, msg);
            }
        }
    }
}

