/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.netty;

import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.exception.ErrorType;
import com.netflix.zuul.exception.OutboundErrorType;
import com.netflix.zuul.exception.OutboundException;
import com.netflix.zuul.netty.connectionpool.OriginConnectException;
import com.netflix.zuul.niws.RequestAttempts;
import com.netflix.zuul.origins.OriginConcurrencyExceededException;
import io.netty.channel.unix.Errors;
import io.netty.handler.timeout.ReadTimeoutException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRequestAttemptFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NettyRequestAttemptFactory.class);

    public ErrorType mapNettyToOutboundErrorType(Throwable t) {
        if (t instanceof ReadTimeoutException) {
            return OutboundErrorType.READ_TIMEOUT;
        }
        if (t instanceof OriginConcurrencyExceededException) {
            return OutboundErrorType.ORIGIN_CONCURRENCY_EXCEEDED;
        }
        if (t instanceof OriginConnectException) {
            return ((OriginConnectException)t).getErrorType();
        }
        if (t instanceof OutboundException) {
            return ((OutboundException)t).getOutboundErrorType();
        }
        if (t instanceof Errors.NativeIoException && Errors.ERRNO_ECONNRESET_NEGATIVE == ((Errors.NativeIoException)t).expectedErr()) {
            LOG.warn("ERRNO_ECONNRESET_NEGATIVE mapped to RESET_CONNECTION", t);
            return OutboundErrorType.RESET_CONNECTION;
        }
        if (t instanceof ClosedChannelException) {
            return OutboundErrorType.RESET_CONNECTION;
        }
        Throwable cause = t.getCause();
        if (cause instanceof IllegalStateException && cause.getMessage().contains("server")) {
            LOG.warn("IllegalStateException mapped to NO_AVAILABLE_SERVERS", cause);
            return OutboundErrorType.NO_AVAILABLE_SERVERS;
        }
        return OutboundErrorType.OTHER;
    }

    public OutboundException mapNettyToOutboundException(Throwable t, SessionContext context) {
        if (t instanceof OutboundException) {
            return (OutboundException)t;
        }
        ErrorType errorType = this.mapNettyToOutboundErrorType(t);
        RequestAttempts attempts = RequestAttempts.getFromSessionContext(context);
        if (errorType == OutboundErrorType.OTHER) {
            return new OutboundException(errorType, attempts, t);
        }
        return new OutboundException(errorType, attempts);
    }
}

