/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.netty.common.metrics.HttpBodySizeRecordingChannelHandler;
import com.netflix.util.UUIDFactory;
import com.netflix.util.concurrent.ConcurrentUUIDFactory;
import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.context.SessionContextDecorator;
import com.netflix.zuul.niws.RequestAttempts;
import com.netflix.zuul.origins.OriginManager;
import com.netflix.zuul.passport.CurrentPassport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ZuulSessionContextDecorator
implements SessionContextDecorator {
    private static final UUIDFactory UUID_FACTORY = new ConcurrentUUIDFactory();
    private final OriginManager originManager;

    @Inject
    public ZuulSessionContextDecorator(OriginManager originManager) {
        this.originManager = originManager;
    }

    @Override
    public SessionContext decorate(SessionContext ctx) {
        ChannelHandlerContext nettyCtx = (ChannelHandlerContext)ctx.get("_netty_server_channel_handler_context");
        if (nettyCtx == null) {
            return null;
        }
        Channel channel = nettyCtx.channel();
        ctx.put("origin_manager", this.originManager);
        ctx.put("request_attempts", new RequestAttempts());
        ctx.set("request_body_size", HttpBodySizeRecordingChannelHandler.getCurrentInboundBodySize(channel));
        ctx.set("response_body_size", HttpBodySizeRecordingChannelHandler.getCurrentOutboundBodySize(channel));
        CurrentPassport passport = CurrentPassport.fromChannel(channel);
        ctx.set("_passport", passport);
        ctx.setUUID(UUID_FACTORY.generateRandomUuid().toString());
        return ctx;
    }
}

