/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.context;

import com.netflix.zuul.context.SessionContext;
import com.netflix.zuul.message.Header;
import com.netflix.zuul.message.Headers;
import com.netflix.zuul.message.ZuulMessage;
import com.netflix.zuul.message.http.HttpQueryParams;
import com.netflix.zuul.message.http.HttpRequestInfo;
import com.netflix.zuul.message.http.HttpRequestMessage;
import com.netflix.zuul.message.http.HttpRequestMessageImpl;
import com.netflix.zuul.message.http.HttpResponseInfo;
import com.netflix.zuul.message.http.HttpResponseMessage;
import com.netflix.zuul.message.http.HttpResponseMessageImpl;
import com.netflix.zuul.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class Debug {
    private static final Logger LOG = LoggerFactory.getLogger(Debug.class);

    public static void setDebugRequest(SessionContext ctx, boolean bDebug) {
        ctx.setDebugRequest(bDebug);
    }

    public static void setDebugRequestHeadersOnly(SessionContext ctx, boolean bHeadersOnly) {
        ctx.setDebugRequestHeadersOnly(bHeadersOnly);
    }

    public static boolean debugRequestHeadersOnly(SessionContext ctx) {
        return ctx.debugRequestHeadersOnly();
    }

    public static void setDebugRouting(SessionContext ctx, boolean bDebug) {
        ctx.setDebugRouting(bDebug);
    }

    public static boolean debugRequest(SessionContext ctx) {
        return ctx.debugRequest();
    }

    public static boolean debugRouting(SessionContext ctx) {
        return ctx.debugRouting();
    }

    public static void addRoutingDebug(SessionContext ctx, String line) {
        List<String> rd = Debug.getRoutingDebug(ctx);
        rd.add(line);
    }

    public static void addRequestDebugForMessage(SessionContext ctx, ZuulMessage message, String prefix) {
        for (Header header : message.getHeaders().entries()) {
            Debug.addRequestDebug(ctx, prefix + " " + header.getKey() + " " + header.getValue());
        }
        if (message.hasBody()) {
            String bodyStr = message.getBodyAsText();
            Debug.addRequestDebug(ctx, prefix + " " + bodyStr);
        }
    }

    public static List<String> getRoutingDebug(SessionContext ctx) {
        ArrayList rd = (ArrayList)ctx.get("routingDebug");
        if (rd == null) {
            rd = new ArrayList();
            ctx.set("routingDebug", rd);
        }
        return rd;
    }

    public static void addRequestDebug(SessionContext ctx, String line) {
        List<String> rd = Debug.getRequestDebug(ctx);
        rd.add(line);
    }

    public static List<String> getRequestDebug(SessionContext ctx) {
        ArrayList rd = (ArrayList)ctx.get("requestDebug");
        if (rd == null) {
            rd = new ArrayList();
            ctx.set("requestDebug", rd);
        }
        return rd;
    }

    public static void compareContextState(String filterName, SessionContext context, SessionContext copy) {
        Iterator it = context.keySet().iterator();
        String key = (String)it.next();
        while (key != null) {
            if (!key.equals("routingDebug") && !key.equals("requestDebug")) {
                Object newValue = context.get(key);
                Object oldValue = copy.get(key);
                if (oldValue == null && newValue != null) {
                    Debug.addRoutingDebug(context, "{" + filterName + "} added " + key + "=" + newValue.toString());
                } else if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                    Debug.addRoutingDebug(context, "{" + filterName + "} changed " + key + "=" + newValue.toString());
                }
            }
            if (it.hasNext()) {
                key = (String)it.next();
                continue;
            }
            key = null;
        }
    }

    public static Observable<Boolean> writeDebugRequest(SessionContext context, HttpRequestInfo request, boolean isInbound) {
        Observable<Boolean> obs = null;
        if (Debug.debugRequest(context)) {
            String prefix = isInbound ? "REQUEST_INBOUND" : "REQUEST_OUTBOUND";
            String arrow = ">";
            Debug.addRequestDebug(context, String.format("%s:: %s LINE: %s %s %s", prefix, arrow, request.getMethod().toUpperCase(), request.getPathAndQuery(), request.getProtocol()));
            obs = Debug.writeDebugMessage(context, request, prefix, arrow);
        }
        if (obs == null) {
            obs = Observable.just((Object)Boolean.FALSE);
        }
        return obs;
    }

    public static Observable<Boolean> writeDebugResponse(SessionContext context, HttpResponseInfo response, boolean isInbound) {
        Observable<Boolean> obs = null;
        if (Debug.debugRequest(context)) {
            String prefix = isInbound ? "RESPONSE_INBOUND" : "RESPONSE_OUTBOUND";
            String arrow = "<";
            Debug.addRequestDebug(context, String.format("%s:: %s STATUS: %s", prefix, arrow, response.getStatus()));
            obs = Debug.writeDebugMessage(context, response, prefix, arrow);
        }
        if (obs == null) {
            obs = Observable.just((Object)Boolean.FALSE);
        }
        return obs;
    }

    public static Observable<Boolean> writeDebugMessage(SessionContext context, ZuulMessage msg, String prefix, String arrow) {
        Observable obs = null;
        for (Header header : msg.getHeaders().entries()) {
            Debug.addRequestDebug(context, String.format("%s:: %s HDR: %s:%s", prefix, arrow, header.getKey(), header.getValue()));
        }
        if (msg.hasBody() && !Debug.debugRequestHeadersOnly(context)) {
            String body = msg.getBodyAsText();
            Debug.addRequestDebug(context, String.format("%s:: %s BODY: %s", prefix, arrow, body));
        }
        if (obs == null) {
            obs = Observable.just((Object)Boolean.FALSE);
        }
        return obs;
    }

    public static String bodyToText(byte[] bodyBytes, Headers headers) {
        try {
            if (HttpUtils.isGzipped(headers)) {
                GZIPInputStream gzIn = new GZIPInputStream(new ByteArrayInputStream(bodyBytes));
                bodyBytes = IOUtils.toByteArray((InputStream)gzIn);
            }
            return IOUtils.toString((byte[])bodyBytes, (String)"UTF-8");
        }
        catch (IOException e) {
            LOG.error("Error reading message body for debugging.", (Throwable)e);
            return "ERROR READING MESSAGE BODY!";
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class UnitTest {
        private SessionContext ctx;
        private Headers headers;
        private HttpQueryParams params;
        private HttpRequestMessage request;
        private HttpResponseMessage response;

        @Before
        public void setup() {
            this.ctx = new SessionContext();
            this.headers = new Headers();
            this.headers.add("lah", "deda");
            this.params = new HttpQueryParams();
            this.params.add("k1", "v1");
            this.request = new HttpRequestMessageImpl(this.ctx, "HTTP/1.1", "post", "/some/where", this.params, this.headers, "9.9.9.9", "https", 80, "localhost");
            this.request.setBodyAsText("some text");
            this.request.storeInboundRequest();
            this.response = new HttpResponseMessageImpl(this.ctx, this.headers, this.request, 200);
            this.response.setBodyAsText("response text");
        }

        @Test
        public void testRequestDebug() {
            Assert.assertFalse((boolean)Debug.debugRouting(this.ctx));
            Assert.assertFalse((boolean)Debug.debugRequest(this.ctx));
            Debug.setDebugRouting(this.ctx, true);
            Debug.setDebugRequest(this.ctx, true);
            Assert.assertTrue((boolean)Debug.debugRouting(this.ctx));
            Assert.assertTrue((boolean)Debug.debugRequest(this.ctx));
            Debug.addRoutingDebug(this.ctx, "test1");
            Assert.assertTrue((boolean)Debug.getRoutingDebug(this.ctx).contains("test1"));
            Debug.addRequestDebug(this.ctx, "test2");
            Assert.assertTrue((boolean)Debug.getRequestDebug(this.ctx).contains("test2"));
        }

        @Test
        public void testWriteInboundRequestDebug() {
            this.ctx.setDebugRequest(true);
            this.ctx.setDebugRequestHeadersOnly(true);
            Debug.writeDebugRequest(this.ctx, this.request, true).toBlocking().single();
            List<String> debugLines = Debug.getRequestDebug(this.ctx);
            Assert.assertEquals((long)3L, (long)debugLines.size());
            Assert.assertEquals((Object)"REQUEST_INBOUND:: > LINE: POST /some/where?k1=v1 HTTP/1.1", (Object)debugLines.get(0));
            Assert.assertEquals((Object)"REQUEST_INBOUND:: > HDR: Content-Length:13", (Object)debugLines.get(1));
            Assert.assertEquals((Object)"REQUEST_INBOUND:: > HDR: lah:deda", (Object)debugLines.get(2));
        }

        @Test
        public void testWriteOutboundRequestDebug() {
            this.ctx.setDebugRequest(true);
            this.ctx.setDebugRequestHeadersOnly(true);
            Debug.writeDebugRequest(this.ctx, this.request, false).toBlocking().single();
            List<String> debugLines = Debug.getRequestDebug(this.ctx);
            Assert.assertEquals((long)3L, (long)debugLines.size());
            Assert.assertEquals((Object)"REQUEST_OUTBOUND:: > LINE: POST /some/where?k1=v1 HTTP/1.1", (Object)debugLines.get(0));
            Assert.assertEquals((Object)"REQUEST_OUTBOUND:: > HDR: Content-Length:13", (Object)debugLines.get(1));
            Assert.assertEquals((Object)"REQUEST_OUTBOUND:: > HDR: lah:deda", (Object)debugLines.get(2));
        }

        @Test
        public void testWriteRequestDebug_WithBody() {
            this.ctx.setDebugRequest(true);
            this.ctx.setDebugRequestHeadersOnly(false);
            Debug.writeDebugRequest(this.ctx, this.request, true).toBlocking().single();
            List<String> debugLines = Debug.getRequestDebug(this.ctx);
            Assert.assertEquals((long)4L, (long)debugLines.size());
            Assert.assertEquals((Object)"REQUEST_INBOUND:: > LINE: POST /some/where?k1=v1 HTTP/1.1", (Object)debugLines.get(0));
            Assert.assertEquals((Object)"REQUEST_INBOUND:: > HDR: Content-Length:13", (Object)debugLines.get(1));
            Assert.assertEquals((Object)"REQUEST_INBOUND:: > HDR: lah:deda", (Object)debugLines.get(2));
            Assert.assertEquals((Object)"REQUEST_INBOUND:: > BODY: some text", (Object)debugLines.get(3));
        }

        @Test
        public void testWriteInboundResponseDebug() {
            this.ctx.setDebugRequest(true);
            this.ctx.setDebugRequestHeadersOnly(true);
            Debug.writeDebugResponse(this.ctx, this.response, true).toBlocking().single();
            List<String> debugLines = Debug.getRequestDebug(this.ctx);
            Assert.assertEquals((long)3L, (long)debugLines.size());
            Assert.assertEquals((Object)"RESPONSE_INBOUND:: < STATUS: 200", (Object)debugLines.get(0));
            Assert.assertEquals((Object)"RESPONSE_INBOUND:: < HDR: Content-Length:13", (Object)debugLines.get(1));
            Assert.assertEquals((Object)"RESPONSE_INBOUND:: < HDR: lah:deda", (Object)debugLines.get(2));
        }

        @Test
        public void testWriteOutboundResponseDebug() {
            this.ctx.setDebugRequest(true);
            this.ctx.setDebugRequestHeadersOnly(true);
            Debug.writeDebugResponse(this.ctx, this.response, false).toBlocking().single();
            List<String> debugLines = Debug.getRequestDebug(this.ctx);
            Assert.assertEquals((long)3L, (long)debugLines.size());
            Assert.assertEquals((Object)"RESPONSE_OUTBOUND:: < STATUS: 200", (Object)debugLines.get(0));
            Assert.assertEquals((Object)"RESPONSE_OUTBOUND:: < HDR: Content-Length:13", (Object)debugLines.get(1));
            Assert.assertEquals((Object)"RESPONSE_OUTBOUND:: < HDR: lah:deda", (Object)debugLines.get(2));
        }

        @Test
        public void testWriteResponseDebug_WithBody() {
            this.ctx.setDebugRequest(true);
            this.ctx.setDebugRequestHeadersOnly(false);
            Debug.writeDebugResponse(this.ctx, this.response, true).toBlocking().single();
            List<String> debugLines = Debug.getRequestDebug(this.ctx);
            Assert.assertEquals((long)4L, (long)debugLines.size());
            Assert.assertEquals((Object)"RESPONSE_INBOUND:: < STATUS: 200", (Object)debugLines.get(0));
            Assert.assertEquals((Object)"RESPONSE_INBOUND:: < HDR: Content-Length:13", (Object)debugLines.get(1));
            Assert.assertEquals((Object)"RESPONSE_INBOUND:: < HDR: lah:deda", (Object)debugLines.get(2));
            Assert.assertEquals((Object)"RESPONSE_INBOUND:: < BODY: response text", (Object)debugLines.get(3));
        }
    }
}

