/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.status;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryClient;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ServerStatusManager {
    private final ApplicationInfoManager applicationInfoManager;
    private final DiscoveryClient discoveryClient;

    @Inject
    public ServerStatusManager(ApplicationInfoManager applicationInfoManager, DiscoveryClient discoveryClient) {
        this.applicationInfoManager = applicationInfoManager;
        this.discoveryClient = discoveryClient;
    }

    public InstanceInfo.InstanceStatus status() {
        InstanceInfo.InstanceStatus local = this.localStatus();
        InstanceInfo.InstanceStatus remote = this.remoteStatus();
        if (local == InstanceInfo.InstanceStatus.UP && remote != InstanceInfo.InstanceStatus.UNKNOWN) {
            return remote;
        }
        return local;
    }

    public InstanceInfo.InstanceStatus localStatus() {
        return this.applicationInfoManager.getInfo().getStatus();
    }

    public InstanceInfo.InstanceStatus remoteStatus() {
        return this.discoveryClient.getInstanceRemoteStatus();
    }

    public void localStatus(InstanceInfo.InstanceStatus status) {
        this.applicationInfoManager.setInstanceStatus(status);
    }

    public int health() {
        throw new UnsupportedOperationException();
    }
}

