/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.ssl;

import io.netty.handler.ssl.ClientAuth;
import java.security.cert.Certificate;
import javax.security.cert.X509Certificate;

public class SslHandshakeInfo {
    private final String protocol;
    private final String cipherSuite;
    private final ClientAuth clientAuthRequirement;
    private final Certificate serverCertificate;
    private final X509Certificate clientCertificate;
    private final boolean isOfIntermediary;

    public SslHandshakeInfo(boolean isOfIntermediary, String protocol, String cipherSuite, Certificate serverCertificate) {
        this.protocol = protocol;
        this.cipherSuite = cipherSuite;
        this.isOfIntermediary = isOfIntermediary;
        this.serverCertificate = serverCertificate;
        this.clientAuthRequirement = ClientAuth.NONE;
        this.clientCertificate = null;
    }

    public SslHandshakeInfo(boolean isOfIntermediary, String protocol, String cipherSuite, ClientAuth clientAuthRequirement, Certificate serverCertificate, X509Certificate clientCertificate) {
        this.protocol = protocol;
        this.cipherSuite = cipherSuite;
        this.clientAuthRequirement = clientAuthRequirement;
        this.serverCertificate = serverCertificate;
        this.clientCertificate = clientCertificate;
        this.isOfIntermediary = isOfIntermediary;
    }

    public boolean isOfIntermediary() {
        return this.isOfIntermediary;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getCipherSuite() {
        return this.cipherSuite;
    }

    public ClientAuth getClientAuthRequirement() {
        return this.clientAuthRequirement;
    }

    public Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    public X509Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    public String toString() {
        return "SslHandshakeInfo{protocol='" + this.protocol + '\'' + ", cipherSuite='" + this.cipherSuite + '\'' + ", clientAuthRequirement=" + this.clientAuthRequirement + ", serverCertificate=" + this.serverCertificate + ", clientCertificate=" + this.clientCertificate + ", isOfIntermediary=" + this.isOfIntermediary + '}';
    }
}

