/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.ssl;

import com.netflix.config.DynamicLongProperty;
import io.netty.handler.ssl.ClientAuth;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class ServerSslConfig {
    private static final DynamicLongProperty DEFAULT_SESSION_TIMEOUT = new DynamicLongProperty("server.ssl.session.timeout", 1080L);
    private static final String[] DEFAULT_CIPHERS;
    private final String[] protocols;
    private final List<String> ciphers;
    private final File certChainFile;
    private final File keyFile;
    private final ClientAuth clientAuth;
    private final File clientAuthTrustStoreFile;
    private final String clientAuthTrustStorePassword;
    private final File clientAuthTrustStorePasswordFile;
    private final boolean decryptKeyUsingMetatronPolicy;
    private final boolean decryptKeyUsingMetatronBundle;
    private final byte[] metatronPolicy;
    private final long sessionTimeout;
    private final boolean sessionTicketsEnabled;

    public ServerSslConfig(String[] protocols, String[] ciphers, File certChainFile, File keyFile) {
        this(protocols, ciphers, certChainFile, keyFile, null, ClientAuth.NONE, null, (File)null, false);
    }

    public ServerSslConfig(String[] protocols, String[] ciphers, File certChainFile, File keyFile, byte[] metatronPolicy, ClientAuth clientAuth) {
        this(protocols, ciphers, certChainFile, keyFile, metatronPolicy, clientAuth, null, (File)null, true);
    }

    public ServerSslConfig(String[] protocols, String[] ciphers, File certChainFile, File keyFile, byte[] metatronPolicy, ClientAuth clientAuth, File clientAuthTrustStoreFile, File clientAuthTrustStorePasswordFile, boolean sessionTicketsEnabled) {
        this.protocols = protocols;
        this.ciphers = ciphers != null ? Arrays.asList(ciphers) : null;
        this.certChainFile = certChainFile;
        this.keyFile = keyFile;
        this.decryptKeyUsingMetatronPolicy = metatronPolicy != null;
        this.decryptKeyUsingMetatronBundle = false;
        this.metatronPolicy = metatronPolicy;
        this.clientAuth = clientAuth;
        this.clientAuthTrustStoreFile = clientAuthTrustStoreFile;
        this.clientAuthTrustStorePassword = null;
        this.clientAuthTrustStorePasswordFile = clientAuthTrustStorePasswordFile;
        this.sessionTimeout = DEFAULT_SESSION_TIMEOUT.get();
        this.sessionTicketsEnabled = sessionTicketsEnabled;
    }

    public ServerSslConfig(String[] protocols, String[] ciphers, File certChainFile, File keyFile, byte[] metatronPolicy, ClientAuth clientAuth, File clientAuthTrustStoreFile, String clientAuthTrustStorePassword, boolean sessionTicketsEnabled) {
        this.protocols = protocols;
        this.ciphers = Arrays.asList(ciphers);
        this.certChainFile = certChainFile;
        this.keyFile = keyFile;
        this.decryptKeyUsingMetatronPolicy = metatronPolicy != null;
        this.decryptKeyUsingMetatronBundle = false;
        this.metatronPolicy = metatronPolicy;
        this.clientAuth = clientAuth;
        this.clientAuthTrustStoreFile = clientAuthTrustStoreFile;
        this.clientAuthTrustStorePassword = clientAuthTrustStorePassword;
        this.clientAuthTrustStorePasswordFile = null;
        this.sessionTimeout = DEFAULT_SESSION_TIMEOUT.get();
        this.sessionTicketsEnabled = sessionTicketsEnabled;
    }

    public ServerSslConfig(String[] protocols, String[] ciphers, File certChainFile, File keyFile, boolean metatronBundle, ClientAuth clientAuth, File clientAuthTrustStoreFile, String clientAuthTrustStorePassword, boolean sessionTicketsEnabled) {
        this.protocols = protocols;
        this.ciphers = Arrays.asList(ciphers);
        this.certChainFile = certChainFile;
        this.keyFile = keyFile;
        this.decryptKeyUsingMetatronBundle = metatronBundle;
        this.decryptKeyUsingMetatronPolicy = false;
        this.metatronPolicy = null;
        this.clientAuth = clientAuth;
        this.clientAuthTrustStoreFile = clientAuthTrustStoreFile;
        this.clientAuthTrustStorePassword = clientAuthTrustStorePassword;
        this.clientAuthTrustStorePasswordFile = null;
        this.sessionTimeout = DEFAULT_SESSION_TIMEOUT.get();
        this.sessionTicketsEnabled = sessionTicketsEnabled;
    }

    public static String[] getDefaultCiphers() {
        return DEFAULT_CIPHERS;
    }

    public static ServerSslConfig withDefaultCiphers(File certChainFile, File keyFile, String ... protocols) {
        return new ServerSslConfig(protocols, ServerSslConfig.getDefaultCiphers(), certChainFile, keyFile);
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public List<String> getCiphers() {
        return this.ciphers;
    }

    public File getCertChainFile() {
        return this.certChainFile;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public boolean shouldDecryptKeyUsingMetatronPolicy() {
        return this.decryptKeyUsingMetatronPolicy;
    }

    public boolean shouldDecryptKeyUsingMetatronBundle() {
        return this.decryptKeyUsingMetatronBundle;
    }

    public byte[] getMetatronPolicyFile() {
        return this.metatronPolicy;
    }

    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public File getClientAuthTrustStoreFile() {
        return this.clientAuthTrustStoreFile;
    }

    public String getClientAuthTrustStorePassword() {
        return this.clientAuthTrustStorePassword;
    }

    public File getClientAuthTrustStorePasswordFile() {
        return this.clientAuthTrustStorePasswordFile;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean sessionTicketsEnabled() {
        return this.sessionTicketsEnabled;
    }

    public String toString() {
        return "ServerSslConfig{protocols=" + Arrays.toString(this.protocols) + ", ciphers=" + this.ciphers + ", certChainFile=" + this.certChainFile + ", keyFile=" + this.keyFile + ", clientAuth=" + this.clientAuth + ", clientAuthTrustStoreFile=" + this.clientAuthTrustStoreFile + ", decryptKeyUsingMetatronPolicy=" + this.decryptKeyUsingMetatronPolicy + ", decryptKeyUsingMetatronBundle=" + this.decryptKeyUsingMetatronBundle + ", sessionTimeout=" + this.sessionTimeout + ", sessionTicketsEnabled=" + this.sessionTicketsEnabled + '}';
    }

    static {
        try {
            SSLContext context = SSLContext.getDefault();
            SSLSocketFactory sf = context.getSocketFactory();
            DEFAULT_CIPHERS = sf.getSupportedCipherSuites();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

