/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common.proxyprotocol;

import com.netflix.netty.common.SourceAddressChannelHandler;
import com.netflix.netty.common.proxyprotocol.OptionalHAProxyMessageDecoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.util.AttributeKey;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElbProxyProtocolChannelHandler
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "ElbProxyProtocolChannelHandler";
    public static final AttributeKey<HAProxyMessage> ATTR_HAPROXY_MESSAGE = AttributeKey.newInstance((String)"_haproxy_message");
    public static final AttributeKey<HAProxyProtocolVersion> ATTR_HAPROXY_VERSION = AttributeKey.newInstance((String)"_haproxy_version");
    private static final Logger logger = LoggerFactory.getLogger((String)"ElbProxyProtocolChannelHandler");
    private final boolean withProxyProtocol;

    public ElbProxyProtocolChannelHandler(boolean withProxyProtocol) {
        this.withProxyProtocol = withProxyProtocol;
    }

    public void addProxyProtocol(ChannelPipeline pipeline) {
        pipeline.addLast(NAME, (ChannelHandler)this);
        if (this.withProxyProtocol) {
            pipeline.addBefore(NAME, "OptionalHAProxyMessageDecoder", (ChannelHandler)new OptionalHAProxyMessageDecoder());
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.withProxyProtocol && msg instanceof HAProxyMessage && msg != null) {
            List haProxyTLVList;
            String sourceAddress;
            HAProxyMessage hapm = (HAProxyMessage)msg;
            Channel channel = ctx.channel();
            channel.attr(ATTR_HAPROXY_MESSAGE).set((Object)hapm);
            channel.attr(ATTR_HAPROXY_VERSION).set((Object)hapm.protocolVersion());
            String destinationAddress = hapm.destinationAddress();
            if (destinationAddress != null) {
                channel.attr(SourceAddressChannelHandler.ATTR_LOCAL_ADDRESS).set((Object)destinationAddress);
                channel.attr(SourceAddressChannelHandler.ATTR_LOCAL_PORT).set((Object)hapm.destinationPort());
            }
            if ((sourceAddress = hapm.sourceAddress()) != null) {
                channel.attr(SourceAddressChannelHandler.ATTR_SOURCE_ADDRESS).set((Object)sourceAddress);
                channel.attr(SourceAddressChannelHandler.ATTR_SOURCE_PORT).set((Object)hapm.sourcePort());
            }
            if ((haProxyTLVList = hapm.tlvs()) != null) {
                logger.debug("Decoded PPV2 TLV list count: {}, List: {}", (Object)haProxyTLVList.size(), (Object)haProxyTLVList);
                for (int i = 0; i < haProxyTLVList.size(); ++i) {
                    HAProxyTLV haProxyTLV = (HAProxyTLV)haProxyTLVList.get(i);
                    haProxyTLV.release();
                }
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        super.channelRead(ctx, msg);
    }
}

