/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.config.DynamicIntProperty;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class SourceAddressChannelHandler
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<InetSocketAddress> ATTR_SOURCE_INET_ADDR = AttributeKey.newInstance((String)"_source_inet_addr");
    public static final AttributeKey<String> ATTR_SOURCE_ADDRESS = AttributeKey.newInstance((String)"_source_address");
    public static final AttributeKey<Integer> ATTR_SOURCE_PORT = AttributeKey.newInstance((String)"_source_port");
    public static final AttributeKey<InetSocketAddress> ATTR_LOCAL_INET_ADDR = AttributeKey.newInstance((String)"_local_inet_addr");
    public static final AttributeKey<String> ATTR_LOCAL_ADDRESS = AttributeKey.newInstance((String)"_local_address");
    public static final AttributeKey<Integer> ATTR_LOCAL_PORT = AttributeKey.newInstance((String)"_local_port");
    public static final AttributeKey<String> ATTR_SERVER_LOCAL_ADDRESS = AttributeKey.newInstance((String)"_server_local_address");
    public static final AttributeKey<Integer> ATTR_SERVER_LOCAL_PORT = AttributeKey.newInstance((String)"_server_local_port");
    public static final AttributeKey<Boolean> ATTR_TCP_PASSTHROUGH_INBOUND_CONN = AttributeKey.newInstance((String)"_tcp_passthrough_inbound_conn");
    public static final DynamicIntProperty INBOUND_TCP_PASSTHROUGH__PORT = new DynamicIntProperty("zuul.server.port.tcp.passthrough", 7009);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress sourceAddress = this.sourceAddress(ctx.channel());
        ctx.channel().attr(ATTR_SOURCE_INET_ADDR).setIfAbsent((Object)sourceAddress);
        ctx.channel().attr(ATTR_SOURCE_ADDRESS).setIfAbsent((Object)sourceAddress.getAddress().getHostAddress());
        ctx.channel().attr(ATTR_SOURCE_PORT).setIfAbsent((Object)sourceAddress.getPort());
        InetSocketAddress localAddress = this.localAddress(ctx.channel());
        ctx.channel().attr(ATTR_LOCAL_INET_ADDR).setIfAbsent((Object)localAddress);
        ctx.channel().attr(ATTR_LOCAL_ADDRESS).setIfAbsent((Object)localAddress.getAddress().getHostAddress());
        ctx.channel().attr(ATTR_LOCAL_PORT).setIfAbsent((Object)localAddress.getPort());
        ctx.channel().attr(ATTR_SERVER_LOCAL_ADDRESS).setIfAbsent((Object)localAddress.getAddress().getHostAddress());
        ctx.channel().attr(ATTR_SERVER_LOCAL_PORT).setIfAbsent((Object)localAddress.getPort());
        if (INBOUND_TCP_PASSTHROUGH__PORT.get() == ((Integer)ctx.channel().attr(ATTR_SERVER_LOCAL_PORT).get()).intValue()) {
            ctx.channel().attr(ATTR_TCP_PASSTHROUGH_INBOUND_CONN).set((Object)true);
        }
        super.channelActive(ctx);
    }

    private InetSocketAddress sourceAddress(Channel channel) {
        InetSocketAddress inetSocketAddress;
        SocketAddress remoteSocketAddr = channel.remoteAddress();
        if (null != remoteSocketAddr && InetSocketAddress.class.isAssignableFrom(remoteSocketAddr.getClass()) && (inetSocketAddress = (InetSocketAddress)remoteSocketAddr).getAddress() != null) {
            return inetSocketAddress;
        }
        return null;
    }

    private InetSocketAddress localAddress(Channel channel) {
        InetSocketAddress inetSocketAddress;
        SocketAddress localSocketAddress = channel.localAddress();
        if (null != localSocketAddress && InetSocketAddress.class.isAssignableFrom(localSocketAddress.getClass()) && (inetSocketAddress = (InetSocketAddress)localSocketAddress).getAddress() != null) {
            return inetSocketAddress;
        }
        return null;
    }
}

