/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import com.netflix.netty.common.metrics.EventLoopGroupMetrics;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeastConnsEventLoopChooserFactory
implements EventExecutorChooserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LeastConnsEventLoopChooserFactory.class);
    private final EventLoopGroupMetrics groupMetrics;

    public LeastConnsEventLoopChooserFactory(EventLoopGroupMetrics groupMetrics) {
        this.groupMetrics = groupMetrics;
    }

    public EventExecutorChooserFactory.EventExecutorChooser newChooser(EventExecutor[] executors) {
        return new LeastConnsEventExecutorChooser(executors, this.groupMetrics);
    }

    private static class LeastConnsEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final List<EventExecutor> executors;
        private final EventLoopGroupMetrics groupMetrics;

        public LeastConnsEventExecutorChooser(EventExecutor[] executors, EventLoopGroupMetrics groupMetrics) {
            this.executors = Arrays.asList(executors);
            this.groupMetrics = groupMetrics;
        }

        public EventExecutor next() {
            return this.chooseWithLeastConns();
        }

        private EventExecutor chooseWithLeastConns() {
            EventExecutor leastExec = null;
            int leastValue = Integer.MAX_VALUE;
            Map<Thread, Integer> connsPer = this.groupMetrics.connectionsPerEventLoop();
            Collections.shuffle(this.executors, ThreadLocalRandom.current());
            for (EventExecutor executor : this.executors) {
                int value = connsPer.getOrDefault(executor, 0);
                if (value >= leastValue) continue;
                leastValue = value;
                leastExec = executor;
            }
            if (leastExec == null) {
                leastExec = this.executors.get(0);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Chose eventloop: " + String.valueOf(leastExec) + ", leastValue=" + leastValue + ", connsPer=" + String.valueOf(connsPer));
            }
            return leastExec;
        }
    }
}

