/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.netty.common;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;

public enum ConnectionCloseType {
    IMMEDIATE,
    GRACEFUL,
    DELAYED_GRACEFUL;

    private static final AttributeKey<ConnectionCloseType> ATTR_CLOSE_TYPE;

    public static ConnectionCloseType fromChannel(Channel ch) {
        ConnectionCloseType type = (ConnectionCloseType)((Object)ch.attr(ATTR_CLOSE_TYPE).get());
        if (type == null) {
            type = IMMEDIATE;
        }
        return type;
    }

    public static void setForChannel(Channel ch, ConnectionCloseType type) {
        ch.attr(ATTR_CLOSE_TYPE).set((Object)type);
    }

    static {
        ATTR_CLOSE_TYPE = AttributeKey.newInstance((String)"_conn_close_type");
    }
}

