/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DerivedStringProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternListStringProperty
extends DerivedStringProperty<List<Pattern>> {
    private static final Logger LOG = LoggerFactory.getLogger(PatternListStringProperty.class);

    public PatternListStringProperty(String name, String defaultValue) {
        super(name, defaultValue);
    }

    protected List<Pattern> derive(String value) {
        ArrayList<Pattern> ptns = new ArrayList<Pattern>();
        if (value != null) {
            for (String ptnTxt : value.split(",")) {
                try {
                    ptns.add(Pattern.compile(ptnTxt.trim()));
                }
                catch (Exception e) {
                    LOG.error("Error parsing regex pattern list from property! name = " + String.valueOf(this.getName()) + ", value = " + String.valueOf(this.getValue()) + ", pattern = " + String.valueOf(value));
                }
            }
        }
        return ptns;
    }
}

