/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.command;

import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.contrib.javanica.command.CommandAction;
import com.netflix.hystrix.contrib.javanica.command.CommandExecutionAction;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.HystrixCommandFactory;
import com.netflix.hystrix.contrib.javanica.command.MetaHolder;
import com.netflix.hystrix.contrib.javanica.exception.CommandActionExecutionException;
import org.apache.commons.lang3.StringUtils;

public class LazyCommandExecutionAction
implements CommandAction {
    private MetaHolder originalMetaHolder;

    public LazyCommandExecutionAction(MetaHolder metaHolder) {
        this.originalMetaHolder = metaHolder;
    }

    @Override
    public MetaHolder getMetaHolder() {
        return this.originalMetaHolder;
    }

    @Override
    public Object execute(ExecutionType executionType) throws CommandActionExecutionException {
        HystrixInvokable command = HystrixCommandFactory.getInstance().createDelayed(this.createCopy(this.originalMetaHolder, executionType));
        return new CommandExecutionAction(command, this.originalMetaHolder).execute(executionType);
    }

    @Override
    public Object executeWithArgs(ExecutionType executionType, Object[] args) throws CommandActionExecutionException {
        HystrixInvokable command = HystrixCommandFactory.getInstance().createDelayed(this.createCopy(this.originalMetaHolder, executionType, args));
        return new CommandExecutionAction(command, this.originalMetaHolder).execute(executionType);
    }

    @Override
    public String getActionName() {
        return StringUtils.isNotEmpty((CharSequence)this.originalMetaHolder.getHystrixCommand().commandKey()) ? this.originalMetaHolder.getHystrixCommand().commandKey() : this.originalMetaHolder.getDefaultCommandKey();
    }

    private MetaHolder createCopy(MetaHolder source, ExecutionType executionType) {
        return MetaHolder.builder().obj(source.getObj()).method(source.getMethod()).ajcMethod(source.getAjcMethod()).fallbackExecutionType(source.getFallbackExecutionType()).extendedFallback(source.isExtendedFallback()).extendedParentFallback(source.isExtendedParentFallback()).executionType(executionType).args(source.getArgs()).observable(source.isObservable()).observableExecutionMode(source.getObservableExecutionMode()).defaultCollapserKey(source.getDefaultCollapserKey()).defaultCommandKey(source.getDefaultCommandKey()).defaultGroupKey(source.getDefaultGroupKey()).hystrixCollapser(source.getHystrixCollapser()).hystrixCommand(source.getHystrixCommand()).build();
    }

    private MetaHolder createCopy(MetaHolder source, ExecutionType executionType, Object[] args) {
        return MetaHolder.builder().obj(source.getObj()).method(source.getMethod()).executionType(executionType).ajcMethod(source.getAjcMethod()).fallbackExecutionType(source.getFallbackExecutionType()).extendedParentFallback(source.isExtendedParentFallback()).extendedFallback(source.isExtendedFallback()).args(args).observable(source.isObservable()).observableExecutionMode(source.getObservableExecutionMode()).defaultCollapserKey(source.getDefaultCollapserKey()).defaultCommandKey(source.getDefaultCommandKey()).defaultGroupKey(source.getDefaultGroupKey()).hystrixCollapser(source.getHystrixCollapser()).hystrixCommand(source.getHystrixCommand()).build();
    }
}

