/*
 * Copyright (c) 2019, 2025, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License, version 2.0, as published by
 * the Free Software Foundation.
 *
 * This program is designed to work with certain software that is licensed under separate terms, as designated in a particular file or component or in
 * included license documentation. The authors of MySQL hereby grant you an additional permission to link the program and your derivative works with the
 * separately licensed software that they have either included with the program or referenced in the documentation.
 *
 * Without limiting anything contained in the foregoing, this file, which is part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: mysqlx_prepare.proto
// Protobuf Java Version: 4.29.0

public final class MysqlxPrepare {
  private MysqlxPrepare() {}
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 29,
      /* patch= */ 0,
      /* suffix= */ "",
      MysqlxPrepare.class.getName());
  }
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface PrepareOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Prepare.Prepare)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * client-side assigned statement ID, which is going to identify
     * the result of preparation 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return Whether the stmtId field is set.
     */
    boolean hasStmtId();
    /**
     * <pre>
     * * client-side assigned statement ID, which is going to identify
     * the result of preparation 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return The stmtId.
     */
    int getStmtId();

    /**
     * <pre>
     * * defines one of following messages to be prepared:
     * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
     * </pre>
     *
     * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
     * @return Whether the stmt field is set.
     */
    boolean hasStmt();
    /**
     * <pre>
     * * defines one of following messages to be prepared:
     * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
     * </pre>
     *
     * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
     * @return The stmt.
     */
    com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage getStmt();
    /**
     * <pre>
     * * defines one of following messages to be prepared:
     * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
     * </pre>
     *
     * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessageOrBuilder getStmtOrBuilder();
  }
  /**
   * <pre>
   * *
   * Prepare a new statement
   *
   * &#64;startuml
   * client -&gt; server: Prepare
   * alt Success
   * client &lt;- server: Ok
   * else Failure
   * client &lt;- server: Error
   * end
   * &#64;enduml
   *
   * &#64;returns &#64;ref Mysqlx::Ok or &#64;ref Mysqlx::Error
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Prepare.Prepare}
   */
  public static final class Prepare extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Prepare.Prepare)
      PrepareOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Prepare.class.getName());
    }
    // Use Prepare.newBuilder() to construct.
    private Prepare(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Prepare() {
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.Builder.class);
    }

    public interface OneOfMessageOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Prepare.Prepare.OneOfMessage)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      boolean hasType();
      /**
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
       * @return The type.
       */
      com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type getType();

      /**
       * <code>optional .Mysqlx.Crud.Find find = 2;</code>
       * @return Whether the find field is set.
       */
      boolean hasFind();
      /**
       * <code>optional .Mysqlx.Crud.Find find = 2;</code>
       * @return The find.
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.Find getFind();
      /**
       * <code>optional .Mysqlx.Crud.Find find = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getFindOrBuilder();

      /**
       * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
       * @return Whether the insert field is set.
       */
      boolean hasInsert();
      /**
       * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
       * @return The insert.
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.Insert getInsert();
      /**
       * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.InsertOrBuilder getInsertOrBuilder();

      /**
       * <code>optional .Mysqlx.Crud.Update update = 4;</code>
       * @return Whether the update field is set.
       */
      boolean hasUpdate();
      /**
       * <code>optional .Mysqlx.Crud.Update update = 4;</code>
       * @return The update.
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.Update getUpdate();
      /**
       * <code>optional .Mysqlx.Crud.Update update = 4;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOrBuilder getUpdateOrBuilder();

      /**
       * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
       * @return Whether the delete field is set.
       */
      boolean hasDelete();
      /**
       * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
       * @return The delete.
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.Delete getDelete();
      /**
       * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxCrud.DeleteOrBuilder getDeleteOrBuilder();

      /**
       * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
       * @return Whether the stmtExecute field is set.
       */
      boolean hasStmtExecute();
      /**
       * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
       * @return The stmtExecute.
       */
      com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute getStmtExecute();
      /**
       * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOrBuilder getStmtExecuteOrBuilder();
    }
    /**
     * Protobuf type {@code Mysqlx.Prepare.Prepare.OneOfMessage}
     */
    public static final class OneOfMessage extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Prepare.Prepare.OneOfMessage)
        OneOfMessageOrBuilder {
    private static final long serialVersionUID = 0L;
      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          OneOfMessage.class.getName());
      }
      // Use OneOfMessage.newBuilder() to construct.
      private OneOfMessage(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }
      private OneOfMessage() {
        type_ = 0;
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Builder.class);
      }

      /**
       * <pre>
       * Determine which of optional fields was set by the client
       * (Workaround for missing "oneof" keyword in pb2.5)
       * </pre>
       *
       * Protobuf enum {@code Mysqlx.Prepare.Prepare.OneOfMessage.Type}
       */
      public enum Type
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>FIND = 0;</code>
         */
        FIND(0),
        /**
         * <code>INSERT = 1;</code>
         */
        INSERT(1),
        /**
         * <code>UPDATE = 2;</code>
         */
        UPDATE(2),
        /**
         * <code>DELETE = 4;</code>
         */
        DELETE(4),
        /**
         * <code>STMT = 5;</code>
         */
        STMT(5),
        ;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 29,
            /* patch= */ 0,
            /* suffix= */ "",
            Type.class.getName());
        }
        /**
         * <code>FIND = 0;</code>
         */
        public static final int FIND_VALUE = 0;
        /**
         * <code>INSERT = 1;</code>
         */
        public static final int INSERT_VALUE = 1;
        /**
         * <code>UPDATE = 2;</code>
         */
        public static final int UPDATE_VALUE = 2;
        /**
         * <code>DELETE = 4;</code>
         */
        public static final int DELETE_VALUE = 4;
        /**
         * <code>STMT = 5;</code>
         */
        public static final int STMT_VALUE = 5;


        public final int getNumber() {
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Type valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Type forNumber(int value) {
          switch (value) {
            case 0: return FIND;
            case 1: return INSERT;
            case 2: return UPDATE;
            case 4: return DELETE;
            case 5: return STMT;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Type>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            Type> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Type>() {
                public Type findValueByNumber(int number) {
                  return Type.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDescriptor().getEnumTypes().get(0);
        }

        private static final Type[] VALUES = values();

        public static Type valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Type(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:Mysqlx.Prepare.Prepare.OneOfMessage.Type)
      }

      private int bitField0_;
      public static final int TYPE_FIELD_NUMBER = 1;
      private int type_ = 0;
      /**
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
       * @return The type.
       */
      @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type getType() {
        com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type result = com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type.forNumber(type_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type.FIND : result;
      }

      public static final int FIND_FIELD_NUMBER = 2;
      private com.mysql.cj.x.protobuf.MysqlxCrud.Find find_;
      /**
       * <code>optional .Mysqlx.Crud.Find find = 2;</code>
       * @return Whether the find field is set.
       */
      @java.lang.Override
      public boolean hasFind() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .Mysqlx.Crud.Find find = 2;</code>
       * @return The find.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.Find getFind() {
        return find_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance() : find_;
      }
      /**
       * <code>optional .Mysqlx.Crud.Find find = 2;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getFindOrBuilder() {
        return find_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance() : find_;
      }

      public static final int INSERT_FIELD_NUMBER = 3;
      private com.mysql.cj.x.protobuf.MysqlxCrud.Insert insert_;
      /**
       * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
       * @return Whether the insert field is set.
       */
      @java.lang.Override
      public boolean hasInsert() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
       * @return The insert.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.Insert getInsert() {
        return insert_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Insert.getDefaultInstance() : insert_;
      }
      /**
       * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.InsertOrBuilder getInsertOrBuilder() {
        return insert_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Insert.getDefaultInstance() : insert_;
      }

      public static final int UPDATE_FIELD_NUMBER = 4;
      private com.mysql.cj.x.protobuf.MysqlxCrud.Update update_;
      /**
       * <code>optional .Mysqlx.Crud.Update update = 4;</code>
       * @return Whether the update field is set.
       */
      @java.lang.Override
      public boolean hasUpdate() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .Mysqlx.Crud.Update update = 4;</code>
       * @return The update.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.Update getUpdate() {
        return update_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Update.getDefaultInstance() : update_;
      }
      /**
       * <code>optional .Mysqlx.Crud.Update update = 4;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOrBuilder getUpdateOrBuilder() {
        return update_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Update.getDefaultInstance() : update_;
      }

      public static final int DELETE_FIELD_NUMBER = 5;
      private com.mysql.cj.x.protobuf.MysqlxCrud.Delete delete_;
      /**
       * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
       * @return Whether the delete field is set.
       */
      @java.lang.Override
      public boolean hasDelete() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
       * @return The delete.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.Delete getDelete() {
        return delete_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Delete.getDefaultInstance() : delete_;
      }
      /**
       * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCrud.DeleteOrBuilder getDeleteOrBuilder() {
        return delete_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Delete.getDefaultInstance() : delete_;
      }

      public static final int STMT_EXECUTE_FIELD_NUMBER = 6;
      private com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute stmtExecute_;
      /**
       * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
       * @return Whether the stmtExecute field is set.
       */
      @java.lang.Override
      public boolean hasStmtExecute() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
       * @return The stmtExecute.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute getStmtExecute() {
        return stmtExecute_ == null ? com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.getDefaultInstance() : stmtExecute_;
      }
      /**
       * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOrBuilder getStmtExecuteOrBuilder() {
        return stmtExecute_ == null ? com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.getDefaultInstance() : stmtExecute_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasType()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (hasFind()) {
          if (!getFind().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (hasInsert()) {
          if (!getInsert().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (hasUpdate()) {
          if (!getUpdate().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (hasDelete()) {
          if (!getDelete().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (hasStmtExecute()) {
          if (!getStmtExecute().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeEnum(1, type_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getFind());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeMessage(3, getInsert());
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeMessage(4, getUpdate());
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeMessage(5, getDelete());
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          output.writeMessage(6, getStmtExecute());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(1, type_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getFind());
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(3, getInsert());
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(4, getUpdate());
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(5, getDelete());
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(6, getStmtExecute());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage)) {
          return super.equals(obj);
        }
        com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage other = (com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage) obj;

        if (hasType() != other.hasType()) return false;
        if (hasType()) {
          if (type_ != other.type_) return false;
        }
        if (hasFind() != other.hasFind()) return false;
        if (hasFind()) {
          if (!getFind()
              .equals(other.getFind())) return false;
        }
        if (hasInsert() != other.hasInsert()) return false;
        if (hasInsert()) {
          if (!getInsert()
              .equals(other.getInsert())) return false;
        }
        if (hasUpdate() != other.hasUpdate()) return false;
        if (hasUpdate()) {
          if (!getUpdate()
              .equals(other.getUpdate())) return false;
        }
        if (hasDelete() != other.hasDelete()) return false;
        if (hasDelete()) {
          if (!getDelete()
              .equals(other.getDelete())) return false;
        }
        if (hasStmtExecute() != other.hasStmtExecute()) return false;
        if (hasStmtExecute()) {
          if (!getStmtExecute()
              .equals(other.getStmtExecute())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasType()) {
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + type_;
        }
        if (hasFind()) {
          hash = (37 * hash) + FIND_FIELD_NUMBER;
          hash = (53 * hash) + getFind().hashCode();
        }
        if (hasInsert()) {
          hash = (37 * hash) + INSERT_FIELD_NUMBER;
          hash = (53 * hash) + getInsert().hashCode();
        }
        if (hasUpdate()) {
          hash = (37 * hash) + UPDATE_FIELD_NUMBER;
          hash = (53 * hash) + getUpdate().hashCode();
        }
        if (hasDelete()) {
          hash = (37 * hash) + DELETE_FIELD_NUMBER;
          hash = (53 * hash) + getDelete().hashCode();
        }
        if (hasStmtExecute()) {
          hash = (37 * hash) + STMT_EXECUTE_FIELD_NUMBER;
          hash = (53 * hash) + getStmtExecute().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Prepare.Prepare.OneOfMessage}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Prepare.Prepare.OneOfMessage)
          com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessageOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage
                  .alwaysUseFieldBuilders) {
            getFindFieldBuilder();
            getInsertFieldBuilder();
            getUpdateFieldBuilder();
            getDeleteFieldBuilder();
            getStmtExecuteFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          type_ = 0;
          find_ = null;
          if (findBuilder_ != null) {
            findBuilder_.dispose();
            findBuilder_ = null;
          }
          insert_ = null;
          if (insertBuilder_ != null) {
            insertBuilder_.dispose();
            insertBuilder_ = null;
          }
          update_ = null;
          if (updateBuilder_ != null) {
            updateBuilder_.dispose();
            updateBuilder_ = null;
          }
          delete_ = null;
          if (deleteBuilder_ != null) {
            deleteBuilder_.dispose();
            deleteBuilder_ = null;
          }
          stmtExecute_ = null;
          if (stmtExecuteBuilder_ != null) {
            stmtExecuteBuilder_.dispose();
            stmtExecuteBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_descriptor;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDefaultInstance();
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage build() {
          com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage result = new com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.type_ = type_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.find_ = findBuilder_ == null
                ? find_
                : findBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.insert_ = insertBuilder_ == null
                ? insert_
                : insertBuilder_.build();
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.update_ = updateBuilder_ == null
                ? update_
                : updateBuilder_.build();
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.delete_ = deleteBuilder_ == null
                ? delete_
                : deleteBuilder_.build();
            to_bitField0_ |= 0x00000010;
          }
          if (((from_bitField0_ & 0x00000020) != 0)) {
            result.stmtExecute_ = stmtExecuteBuilder_ == null
                ? stmtExecute_
                : stmtExecuteBuilder_.build();
            to_bitField0_ |= 0x00000020;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDefaultInstance()) return this;
          if (other.hasType()) {
            setType(other.getType());
          }
          if (other.hasFind()) {
            mergeFind(other.getFind());
          }
          if (other.hasInsert()) {
            mergeInsert(other.getInsert());
          }
          if (other.hasUpdate()) {
            mergeUpdate(other.getUpdate());
          }
          if (other.hasDelete()) {
            mergeDelete(other.getDelete());
          }
          if (other.hasStmtExecute()) {
            mergeStmtExecute(other.getStmtExecute());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasType()) {
            return false;
          }
          if (hasFind()) {
            if (!getFind().isInitialized()) {
              return false;
            }
          }
          if (hasInsert()) {
            if (!getInsert().isInitialized()) {
              return false;
            }
          }
          if (hasUpdate()) {
            if (!getUpdate().isInitialized()) {
              return false;
            }
          }
          if (hasDelete()) {
            if (!getDelete().isInitialized()) {
              return false;
            }
          }
          if (hasStmtExecute()) {
            if (!getStmtExecute().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8: {
                  int tmpRaw = input.readEnum();
                  com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type tmpValue =
                      com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type.forNumber(tmpRaw);
                  if (tmpValue == null) {
                    mergeUnknownVarintField(1, tmpRaw);
                  } else {
                    type_ = tmpRaw;
                    bitField0_ |= 0x00000001;
                  }
                  break;
                } // case 8
                case 18: {
                  input.readMessage(
                      getFindFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                case 26: {
                  input.readMessage(
                      getInsertFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
                case 34: {
                  input.readMessage(
                      getUpdateFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
                case 42: {
                  input.readMessage(
                      getDeleteFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
                case 50: {
                  input.readMessage(
                      getStmtExecuteFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private int type_ = 0;
        /**
         * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
         * @return Whether the type field is set.
         */
        @java.lang.Override public boolean hasType() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
         * @return The type.
         */
        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type getType() {
          com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type result = com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type.forNumber(type_);
          return result == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type.FIND : result;
        }
        /**
         * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Type value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          type_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage.Type type = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          type_ = 0;
          onChanged();
          return this;
        }

        private com.mysql.cj.x.protobuf.MysqlxCrud.Find find_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder> findBuilder_;
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         * @return Whether the find field is set.
         */
        public boolean hasFind() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         * @return The find.
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Find getFind() {
          if (findBuilder_ == null) {
            return find_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance() : find_;
          } else {
            return findBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         */
        public Builder setFind(com.mysql.cj.x.protobuf.MysqlxCrud.Find value) {
          if (findBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            find_ = value;
          } else {
            findBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         */
        public Builder setFind(
            com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder builderForValue) {
          if (findBuilder_ == null) {
            find_ = builderForValue.build();
          } else {
            findBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         */
        public Builder mergeFind(com.mysql.cj.x.protobuf.MysqlxCrud.Find value) {
          if (findBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              find_ != null &&
              find_ != com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance()) {
              getFindBuilder().mergeFrom(value);
            } else {
              find_ = value;
            }
          } else {
            findBuilder_.mergeFrom(value);
          }
          if (find_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         */
        public Builder clearFind() {
          bitField0_ = (bitField0_ & ~0x00000002);
          find_ = null;
          if (findBuilder_ != null) {
            findBuilder_.dispose();
            findBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder getFindBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getFindFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder getFindOrBuilder() {
          if (findBuilder_ != null) {
            return findBuilder_.getMessageOrBuilder();
          } else {
            return find_ == null ?
                com.mysql.cj.x.protobuf.MysqlxCrud.Find.getDefaultInstance() : find_;
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Find find = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder> 
            getFindFieldBuilder() {
          if (findBuilder_ == null) {
            findBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxCrud.Find, com.mysql.cj.x.protobuf.MysqlxCrud.Find.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.FindOrBuilder>(
                    getFind(),
                    getParentForChildren(),
                    isClean());
            find_ = null;
          }
          return findBuilder_;
        }

        private com.mysql.cj.x.protobuf.MysqlxCrud.Insert insert_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Insert, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.InsertOrBuilder> insertBuilder_;
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         * @return Whether the insert field is set.
         */
        public boolean hasInsert() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         * @return The insert.
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Insert getInsert() {
          if (insertBuilder_ == null) {
            return insert_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Insert.getDefaultInstance() : insert_;
          } else {
            return insertBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         */
        public Builder setInsert(com.mysql.cj.x.protobuf.MysqlxCrud.Insert value) {
          if (insertBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            insert_ = value;
          } else {
            insertBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         */
        public Builder setInsert(
            com.mysql.cj.x.protobuf.MysqlxCrud.Insert.Builder builderForValue) {
          if (insertBuilder_ == null) {
            insert_ = builderForValue.build();
          } else {
            insertBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         */
        public Builder mergeInsert(com.mysql.cj.x.protobuf.MysqlxCrud.Insert value) {
          if (insertBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0) &&
              insert_ != null &&
              insert_ != com.mysql.cj.x.protobuf.MysqlxCrud.Insert.getDefaultInstance()) {
              getInsertBuilder().mergeFrom(value);
            } else {
              insert_ = value;
            }
          } else {
            insertBuilder_.mergeFrom(value);
          }
          if (insert_ != null) {
            bitField0_ |= 0x00000004;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         */
        public Builder clearInsert() {
          bitField0_ = (bitField0_ & ~0x00000004);
          insert_ = null;
          if (insertBuilder_ != null) {
            insertBuilder_.dispose();
            insertBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Insert.Builder getInsertBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getInsertFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.InsertOrBuilder getInsertOrBuilder() {
          if (insertBuilder_ != null) {
            return insertBuilder_.getMessageOrBuilder();
          } else {
            return insert_ == null ?
                com.mysql.cj.x.protobuf.MysqlxCrud.Insert.getDefaultInstance() : insert_;
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Insert insert = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Insert, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.InsertOrBuilder> 
            getInsertFieldBuilder() {
          if (insertBuilder_ == null) {
            insertBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxCrud.Insert, com.mysql.cj.x.protobuf.MysqlxCrud.Insert.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.InsertOrBuilder>(
                    getInsert(),
                    getParentForChildren(),
                    isClean());
            insert_ = null;
          }
          return insertBuilder_;
        }

        private com.mysql.cj.x.protobuf.MysqlxCrud.Update update_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Update, com.mysql.cj.x.protobuf.MysqlxCrud.Update.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOrBuilder> updateBuilder_;
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         * @return Whether the update field is set.
         */
        public boolean hasUpdate() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         * @return The update.
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Update getUpdate() {
          if (updateBuilder_ == null) {
            return update_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Update.getDefaultInstance() : update_;
          } else {
            return updateBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         */
        public Builder setUpdate(com.mysql.cj.x.protobuf.MysqlxCrud.Update value) {
          if (updateBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            update_ = value;
          } else {
            updateBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         */
        public Builder setUpdate(
            com.mysql.cj.x.protobuf.MysqlxCrud.Update.Builder builderForValue) {
          if (updateBuilder_ == null) {
            update_ = builderForValue.build();
          } else {
            updateBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         */
        public Builder mergeUpdate(com.mysql.cj.x.protobuf.MysqlxCrud.Update value) {
          if (updateBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0) &&
              update_ != null &&
              update_ != com.mysql.cj.x.protobuf.MysqlxCrud.Update.getDefaultInstance()) {
              getUpdateBuilder().mergeFrom(value);
            } else {
              update_ = value;
            }
          } else {
            updateBuilder_.mergeFrom(value);
          }
          if (update_ != null) {
            bitField0_ |= 0x00000008;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         */
        public Builder clearUpdate() {
          bitField0_ = (bitField0_ & ~0x00000008);
          update_ = null;
          if (updateBuilder_ != null) {
            updateBuilder_.dispose();
            updateBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Update.Builder getUpdateBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getUpdateFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOrBuilder getUpdateOrBuilder() {
          if (updateBuilder_ != null) {
            return updateBuilder_.getMessageOrBuilder();
          } else {
            return update_ == null ?
                com.mysql.cj.x.protobuf.MysqlxCrud.Update.getDefaultInstance() : update_;
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Update update = 4;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Update, com.mysql.cj.x.protobuf.MysqlxCrud.Update.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOrBuilder> 
            getUpdateFieldBuilder() {
          if (updateBuilder_ == null) {
            updateBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxCrud.Update, com.mysql.cj.x.protobuf.MysqlxCrud.Update.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.UpdateOrBuilder>(
                    getUpdate(),
                    getParentForChildren(),
                    isClean());
            update_ = null;
          }
          return updateBuilder_;
        }

        private com.mysql.cj.x.protobuf.MysqlxCrud.Delete delete_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Delete, com.mysql.cj.x.protobuf.MysqlxCrud.Delete.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.DeleteOrBuilder> deleteBuilder_;
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         * @return Whether the delete field is set.
         */
        public boolean hasDelete() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         * @return The delete.
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Delete getDelete() {
          if (deleteBuilder_ == null) {
            return delete_ == null ? com.mysql.cj.x.protobuf.MysqlxCrud.Delete.getDefaultInstance() : delete_;
          } else {
            return deleteBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         */
        public Builder setDelete(com.mysql.cj.x.protobuf.MysqlxCrud.Delete value) {
          if (deleteBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            delete_ = value;
          } else {
            deleteBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         */
        public Builder setDelete(
            com.mysql.cj.x.protobuf.MysqlxCrud.Delete.Builder builderForValue) {
          if (deleteBuilder_ == null) {
            delete_ = builderForValue.build();
          } else {
            deleteBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000010;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         */
        public Builder mergeDelete(com.mysql.cj.x.protobuf.MysqlxCrud.Delete value) {
          if (deleteBuilder_ == null) {
            if (((bitField0_ & 0x00000010) != 0) &&
              delete_ != null &&
              delete_ != com.mysql.cj.x.protobuf.MysqlxCrud.Delete.getDefaultInstance()) {
              getDeleteBuilder().mergeFrom(value);
            } else {
              delete_ = value;
            }
          } else {
            deleteBuilder_.mergeFrom(value);
          }
          if (delete_ != null) {
            bitField0_ |= 0x00000010;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         */
        public Builder clearDelete() {
          bitField0_ = (bitField0_ & ~0x00000010);
          delete_ = null;
          if (deleteBuilder_ != null) {
            deleteBuilder_.dispose();
            deleteBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.Delete.Builder getDeleteBuilder() {
          bitField0_ |= 0x00000010;
          onChanged();
          return getDeleteFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxCrud.DeleteOrBuilder getDeleteOrBuilder() {
          if (deleteBuilder_ != null) {
            return deleteBuilder_.getMessageOrBuilder();
          } else {
            return delete_ == null ?
                com.mysql.cj.x.protobuf.MysqlxCrud.Delete.getDefaultInstance() : delete_;
          }
        }
        /**
         * <code>optional .Mysqlx.Crud.Delete delete = 5;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxCrud.Delete, com.mysql.cj.x.protobuf.MysqlxCrud.Delete.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.DeleteOrBuilder> 
            getDeleteFieldBuilder() {
          if (deleteBuilder_ == null) {
            deleteBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxCrud.Delete, com.mysql.cj.x.protobuf.MysqlxCrud.Delete.Builder, com.mysql.cj.x.protobuf.MysqlxCrud.DeleteOrBuilder>(
                    getDelete(),
                    getParentForChildren(),
                    isClean());
            delete_ = null;
          }
          return deleteBuilder_;
        }

        private com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute stmtExecute_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.Builder, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOrBuilder> stmtExecuteBuilder_;
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         * @return Whether the stmtExecute field is set.
         */
        public boolean hasStmtExecute() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         * @return The stmtExecute.
         */
        public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute getStmtExecute() {
          if (stmtExecuteBuilder_ == null) {
            return stmtExecute_ == null ? com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.getDefaultInstance() : stmtExecute_;
          } else {
            return stmtExecuteBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         */
        public Builder setStmtExecute(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute value) {
          if (stmtExecuteBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            stmtExecute_ = value;
          } else {
            stmtExecuteBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         */
        public Builder setStmtExecute(
            com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.Builder builderForValue) {
          if (stmtExecuteBuilder_ == null) {
            stmtExecute_ = builderForValue.build();
          } else {
            stmtExecuteBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000020;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         */
        public Builder mergeStmtExecute(com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute value) {
          if (stmtExecuteBuilder_ == null) {
            if (((bitField0_ & 0x00000020) != 0) &&
              stmtExecute_ != null &&
              stmtExecute_ != com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.getDefaultInstance()) {
              getStmtExecuteBuilder().mergeFrom(value);
            } else {
              stmtExecute_ = value;
            }
          } else {
            stmtExecuteBuilder_.mergeFrom(value);
          }
          if (stmtExecute_ != null) {
            bitField0_ |= 0x00000020;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         */
        public Builder clearStmtExecute() {
          bitField0_ = (bitField0_ & ~0x00000020);
          stmtExecute_ = null;
          if (stmtExecuteBuilder_ != null) {
            stmtExecuteBuilder_.dispose();
            stmtExecuteBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.Builder getStmtExecuteBuilder() {
          bitField0_ |= 0x00000020;
          onChanged();
          return getStmtExecuteFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOrBuilder getStmtExecuteOrBuilder() {
          if (stmtExecuteBuilder_ != null) {
            return stmtExecuteBuilder_.getMessageOrBuilder();
          } else {
            return stmtExecute_ == null ?
                com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.getDefaultInstance() : stmtExecute_;
          }
        }
        /**
         * <code>optional .Mysqlx.Sql.StmtExecute stmt_execute = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.Builder, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOrBuilder> 
            getStmtExecuteFieldBuilder() {
          if (stmtExecuteBuilder_ == null) {
            stmtExecuteBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecute.Builder, com.mysql.cj.x.protobuf.MysqlxSql.StmtExecuteOrBuilder>(
                    getStmtExecute(),
                    getParentForChildren(),
                    isClean());
            stmtExecute_ = null;
          }
          return stmtExecuteBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Prepare.Prepare.OneOfMessage)
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Prepare.Prepare.OneOfMessage)
      private static final com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage();
      }

      public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OneOfMessage>
          PARSER = new com.google.protobuf.AbstractParser<OneOfMessage>() {
        @java.lang.Override
        public OneOfMessage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<OneOfMessage> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OneOfMessage> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int STMT_ID_FIELD_NUMBER = 1;
    private int stmtId_ = 0;
    /**
     * <pre>
     * * client-side assigned statement ID, which is going to identify
     * the result of preparation 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return Whether the stmtId field is set.
     */
    @java.lang.Override
    public boolean hasStmtId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * client-side assigned statement ID, which is going to identify
     * the result of preparation 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return The stmtId.
     */
    @java.lang.Override
    public int getStmtId() {
      return stmtId_;
    }

    public static final int STMT_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage stmt_;
    /**
     * <pre>
     * * defines one of following messages to be prepared:
     * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
     * </pre>
     *
     * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
     * @return Whether the stmt field is set.
     */
    @java.lang.Override
    public boolean hasStmt() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * defines one of following messages to be prepared:
     * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
     * </pre>
     *
     * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
     * @return The stmt.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage getStmt() {
      return stmt_ == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDefaultInstance() : stmt_;
    }
    /**
     * <pre>
     * * defines one of following messages to be prepared:
     * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
     * </pre>
     *
     * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessageOrBuilder getStmtOrBuilder() {
      return stmt_ == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDefaultInstance() : stmt_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStmtId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasStmt()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getStmt().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, stmtId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getStmt());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, stmtId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getStmt());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare other = (com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare) obj;

      if (hasStmtId() != other.hasStmtId()) return false;
      if (hasStmtId()) {
        if (getStmtId()
            != other.getStmtId()) return false;
      }
      if (hasStmt() != other.hasStmt()) return false;
      if (hasStmt()) {
        if (!getStmt()
            .equals(other.getStmt())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStmtId()) {
        hash = (37 * hash) + STMT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getStmtId();
      }
      if (hasStmt()) {
        hash = (37 * hash) + STMT_FIELD_NUMBER;
        hash = (53 * hash) + getStmt().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Prepare a new statement
     *
     * &#64;startuml
     * client -&gt; server: Prepare
     * alt Success
     * client &lt;- server: Ok
     * else Failure
     * client &lt;- server: Error
     * end
     * &#64;enduml
     *
     * &#64;returns &#64;ref Mysqlx::Ok or &#64;ref Mysqlx::Error
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Prepare.Prepare}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Prepare.Prepare)
        com.mysql.cj.x.protobuf.MysqlxPrepare.PrepareOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getStmtFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        stmtId_ = 0;
        stmt_ = null;
        if (stmtBuilder_ != null) {
          stmtBuilder_.dispose();
          stmtBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Prepare_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare build() {
        com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare result = new com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.stmtId_ = stmtId_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stmt_ = stmtBuilder_ == null
              ? stmt_
              : stmtBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.getDefaultInstance()) return this;
        if (other.hasStmtId()) {
          setStmtId(other.getStmtId());
        }
        if (other.hasStmt()) {
          mergeStmt(other.getStmt());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasStmtId()) {
          return false;
        }
        if (!hasStmt()) {
          return false;
        }
        if (!getStmt().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                stmtId_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getStmtFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int stmtId_ ;
      /**
       * <pre>
       * * client-side assigned statement ID, which is going to identify
       * the result of preparation 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return Whether the stmtId field is set.
       */
      @java.lang.Override
      public boolean hasStmtId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * client-side assigned statement ID, which is going to identify
       * the result of preparation 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return The stmtId.
       */
      @java.lang.Override
      public int getStmtId() {
        return stmtId_;
      }
      /**
       * <pre>
       * * client-side assigned statement ID, which is going to identify
       * the result of preparation 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @param value The stmtId to set.
       * @return This builder for chaining.
       */
      public Builder setStmtId(int value) {

        stmtId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * client-side assigned statement ID, which is going to identify
       * the result of preparation 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStmtId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stmtId_ = 0;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage stmt_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Builder, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessageOrBuilder> stmtBuilder_;
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       * @return Whether the stmt field is set.
       */
      public boolean hasStmt() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       * @return The stmt.
       */
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage getStmt() {
        if (stmtBuilder_ == null) {
          return stmt_ == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDefaultInstance() : stmt_;
        } else {
          return stmtBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       */
      public Builder setStmt(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage value) {
        if (stmtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stmt_ = value;
        } else {
          stmtBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       */
      public Builder setStmt(
          com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Builder builderForValue) {
        if (stmtBuilder_ == null) {
          stmt_ = builderForValue.build();
        } else {
          stmtBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       */
      public Builder mergeStmt(com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage value) {
        if (stmtBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            stmt_ != null &&
            stmt_ != com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDefaultInstance()) {
            getStmtBuilder().mergeFrom(value);
          } else {
            stmt_ = value;
          }
        } else {
          stmtBuilder_.mergeFrom(value);
        }
        if (stmt_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       */
      public Builder clearStmt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        stmt_ = null;
        if (stmtBuilder_ != null) {
          stmtBuilder_.dispose();
          stmtBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Builder getStmtBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStmtFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessageOrBuilder getStmtOrBuilder() {
        if (stmtBuilder_ != null) {
          return stmtBuilder_.getMessageOrBuilder();
        } else {
          return stmt_ == null ?
              com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.getDefaultInstance() : stmt_;
        }
      }
      /**
       * <pre>
       * * defines one of following messages to be prepared:
       * Crud::Find, Crud::Insert, Crud::Delete, Crud::Upsert, Sql::StmtExecute 
       * </pre>
       *
       * <code>required .Mysqlx.Prepare.Prepare.OneOfMessage stmt = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Builder, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessageOrBuilder> 
          getStmtFieldBuilder() {
        if (stmtBuilder_ == null) {
          stmtBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessage.Builder, com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare.OneOfMessageOrBuilder>(
                  getStmt(),
                  getParentForChildren(),
                  isClean());
          stmt_ = null;
        }
        return stmtBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Prepare.Prepare)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Prepare.Prepare)
    private static final com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare();
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Prepare>
        PARSER = new com.google.protobuf.AbstractParser<Prepare>() {
      @java.lang.Override
      public Prepare parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Prepare> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Prepare> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxPrepare.Prepare getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ExecuteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Prepare.Execute)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return Whether the stmtId field is set.
     */
    boolean hasStmtId();
    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return The stmtId.
     */
    int getStmtId();

    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> 
        getArgsList();
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getArgs(int index);
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    int getArgsCount();
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <pre>
     * * send only type information for
     * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 3 [default = false];</code>
     * @return Whether the compactMetadata field is set.
     */
    boolean hasCompactMetadata();
    /**
     * <pre>
     * * send only type information for
     * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 3 [default = false];</code>
     * @return The compactMetadata.
     */
    boolean getCompactMetadata();
  }
  /**
   * <pre>
   * *
   * Execute already-prepared statement
   *
   * &#64;startuml
   *
   * client -&gt; server: Execute
   * alt Success
   * ... Resultsets...
   * client &lt;- server: StmtExecuteOk
   * else Failure
   * client &lt;- server: Error
   * end
   * &#64;enduml
   * &#64;returns &#64;ref Mysqlx::Ok
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Prepare.Execute}
   */
  public static final class Execute extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Prepare.Execute)
      ExecuteOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Execute.class.getName());
    }
    // Use Execute.newBuilder() to construct.
    private Execute(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Execute() {
      args_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Execute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Execute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.Builder.class);
    }

    private int bitField0_;
    public static final int STMT_ID_FIELD_NUMBER = 1;
    private int stmtId_ = 0;
    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return Whether the stmtId field is set.
     */
    @java.lang.Override
    public boolean hasStmtId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return The stmtId.
     */
    @java.lang.Override
    public int getStmtId() {
      return stmtId_;
    }

    public static final int ARGS_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> args_;
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getArgsList() {
      return args_;
    }
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <pre>
     * * Arguments to bind to the prepared statement 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int COMPACT_METADATA_FIELD_NUMBER = 3;
    private boolean compactMetadata_ = false;
    /**
     * <pre>
     * * send only type information for
     * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 3 [default = false];</code>
     * @return Whether the compactMetadata field is set.
     */
    @java.lang.Override
    public boolean hasCompactMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * send only type information for
     * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
     * </pre>
     *
     * <code>optional bool compact_metadata = 3 [default = false];</code>
     * @return The compactMetadata.
     */
    @java.lang.Override
    public boolean getCompactMetadata() {
      return compactMetadata_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStmtId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getArgsCount(); i++) {
        if (!getArgs(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, stmtId_);
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(2, args_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBool(3, compactMetadata_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, stmtId_);
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, args_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, compactMetadata_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Execute)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxPrepare.Execute other = (com.mysql.cj.x.protobuf.MysqlxPrepare.Execute) obj;

      if (hasStmtId() != other.hasStmtId()) return false;
      if (hasStmtId()) {
        if (getStmtId()
            != other.getStmtId()) return false;
      }
      if (!getArgsList()
          .equals(other.getArgsList())) return false;
      if (hasCompactMetadata() != other.hasCompactMetadata()) return false;
      if (hasCompactMetadata()) {
        if (getCompactMetadata()
            != other.getCompactMetadata()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStmtId()) {
        hash = (37 * hash) + STMT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getStmtId();
      }
      if (getArgsCount() > 0) {
        hash = (37 * hash) + ARGS_FIELD_NUMBER;
        hash = (53 * hash) + getArgsList().hashCode();
      }
      if (hasCompactMetadata()) {
        hash = (37 * hash) + COMPACT_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getCompactMetadata());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxPrepare.Execute prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Execute already-prepared statement
     *
     * &#64;startuml
     *
     * client -&gt; server: Execute
     * alt Success
     * ... Resultsets...
     * client &lt;- server: StmtExecuteOk
     * else Failure
     * client &lt;- server: Error
     * end
     * &#64;enduml
     * &#64;returns &#64;ref Mysqlx::Ok
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Prepare.Execute}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Prepare.Execute)
        com.mysql.cj.x.protobuf.MysqlxPrepare.ExecuteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Execute_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Execute_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        stmtId_ = 0;
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
        } else {
          args_ = null;
          argsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        compactMetadata_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Execute_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Execute getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Execute build() {
        com.mysql.cj.x.protobuf.MysqlxPrepare.Execute result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Execute buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxPrepare.Execute result = new com.mysql.cj.x.protobuf.MysqlxPrepare.Execute(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxPrepare.Execute result) {
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxPrepare.Execute result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.stmtId_ = stmtId_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.compactMetadata_ = compactMetadata_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Execute) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxPrepare.Execute)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxPrepare.Execute other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.getDefaultInstance()) return this;
        if (other.hasStmtId()) {
          setStmtId(other.getStmtId());
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000002);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.hasCompactMetadata()) {
          setCompactMetadata(other.getCompactMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasStmtId()) {
          return false;
        }
        for (int i = 0; i < getArgsCount(); i++) {
          if (!getArgs(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                stmtId_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.parser(),
                        extensionRegistry);
                if (argsBuilder_ == null) {
                  ensureArgsIsMutable();
                  args_.add(m);
                } else {
                  argsBuilder_.addMessage(m);
                }
                break;
              } // case 18
              case 24: {
                compactMetadata_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int stmtId_ ;
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return Whether the stmtId field is set.
       */
      @java.lang.Override
      public boolean hasStmtId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return The stmtId.
       */
      @java.lang.Override
      public int getStmtId() {
        return stmtId_;
      }
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @param value The stmtId to set.
       * @return This builder for chaining.
       */
      public Builder setStmtId(int value) {

        stmtId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStmtId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stmtId_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          args_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any>(args_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> argsBuilder_;

      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <pre>
       * * Arguments to bind to the prepared statement 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private boolean compactMetadata_ ;
      /**
       * <pre>
       * * send only type information for
       * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 3 [default = false];</code>
       * @return Whether the compactMetadata field is set.
       */
      @java.lang.Override
      public boolean hasCompactMetadata() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * * send only type information for
       * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 3 [default = false];</code>
       * @return The compactMetadata.
       */
      @java.lang.Override
      public boolean getCompactMetadata() {
        return compactMetadata_;
      }
      /**
       * <pre>
       * * send only type information for
       * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 3 [default = false];</code>
       * @param value The compactMetadata to set.
       * @return This builder for chaining.
       */
      public Builder setCompactMetadata(boolean value) {

        compactMetadata_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * send only type information for
       * &#64;ref Mysqlx::Resultset::ColumnMetaData, skipping names and others 
       * </pre>
       *
       * <code>optional bool compact_metadata = 3 [default = false];</code>
       * @return This builder for chaining.
       */
      public Builder clearCompactMetadata() {
        bitField0_ = (bitField0_ & ~0x00000004);
        compactMetadata_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Prepare.Execute)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Prepare.Execute)
    private static final com.mysql.cj.x.protobuf.MysqlxPrepare.Execute DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxPrepare.Execute();
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Execute getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Execute>
        PARSER = new com.google.protobuf.AbstractParser<Execute>() {
      @java.lang.Override
      public Execute parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Execute> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Execute> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxPrepare.Execute getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DeallocateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Prepare.Deallocate)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return Whether the stmtId field is set.
     */
    boolean hasStmtId();
    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return The stmtId.
     */
    int getStmtId();
  }
  /**
   * <pre>
   * *
   * Deallocate already-prepared statement
   *
   * &#64;startuml
   * client -&gt; server: Deallocate
   * alt Success
   * client &lt;- server: Ok
   * else Failure
   * client &lt;- server: Error
   * end
   * &#64;enduml
   *
   * &#64;returns &#64;ref Mysqlx::Ok or &#64;ref Mysqlx::Error
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Prepare.Deallocate}
   */
  public static final class Deallocate extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Prepare.Deallocate)
      DeallocateOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Deallocate.class.getName());
    }
    // Use Deallocate.newBuilder() to construct.
    private Deallocate(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Deallocate() {
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Deallocate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Deallocate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate.Builder.class);
    }

    private int bitField0_;
    public static final int STMT_ID_FIELD_NUMBER = 1;
    private int stmtId_ = 0;
    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return Whether the stmtId field is set.
     */
    @java.lang.Override
    public boolean hasStmtId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * client-side assigned statement ID, must be already prepared 
     * </pre>
     *
     * <code>required uint32 stmt_id = 1;</code>
     * @return The stmtId.
     */
    @java.lang.Override
    public int getStmtId() {
      return stmtId_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStmtId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, stmtId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, stmtId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate other = (com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate) obj;

      if (hasStmtId() != other.hasStmtId()) return false;
      if (hasStmtId()) {
        if (getStmtId()
            != other.getStmtId()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStmtId()) {
        hash = (37 * hash) + STMT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getStmtId();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Deallocate already-prepared statement
     *
     * &#64;startuml
     * client -&gt; server: Deallocate
     * alt Success
     * client &lt;- server: Ok
     * else Failure
     * client &lt;- server: Error
     * end
     * &#64;enduml
     *
     * &#64;returns &#64;ref Mysqlx::Ok or &#64;ref Mysqlx::Error
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Prepare.Deallocate}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Prepare.Deallocate)
        com.mysql.cj.x.protobuf.MysqlxPrepare.DeallocateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Deallocate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Deallocate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate.class, com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        stmtId_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.internal_static_Mysqlx_Prepare_Deallocate_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate build() {
        com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate result = new com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.stmtId_ = stmtId_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate.getDefaultInstance()) return this;
        if (other.hasStmtId()) {
          setStmtId(other.getStmtId());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasStmtId()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                stmtId_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int stmtId_ ;
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return Whether the stmtId field is set.
       */
      @java.lang.Override
      public boolean hasStmtId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return The stmtId.
       */
      @java.lang.Override
      public int getStmtId() {
        return stmtId_;
      }
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @param value The stmtId to set.
       * @return This builder for chaining.
       */
      public Builder setStmtId(int value) {

        stmtId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * client-side assigned statement ID, must be already prepared 
       * </pre>
       *
       * <code>required uint32 stmt_id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStmtId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stmtId_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Prepare.Deallocate)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Prepare.Deallocate)
    private static final com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate();
    }

    public static com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Deallocate>
        PARSER = new com.google.protobuf.AbstractParser<Deallocate>() {
      @java.lang.Override
      public Deallocate parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Deallocate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Deallocate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxPrepare.Deallocate getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Prepare_Prepare_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Prepare_Prepare_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Prepare_Execute_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Prepare_Execute_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Prepare_Deallocate_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Prepare_Deallocate_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\024mysqlx_prepare.proto\022\016Mysqlx.Prepare\032\014" +
      "mysqlx.proto\032\020mysqlx_sql.proto\032\021mysqlx_c" +
      "rud.proto\032\026mysqlx_datatypes.proto\"\235\003\n\007Pr" +
      "epare\022\017\n\007stmt_id\030\001 \002(\r\0222\n\004stmt\030\002 \002(\0132$.M" +
      "ysqlx.Prepare.Prepare.OneOfMessage\032\306\002\n\014O" +
      "neOfMessage\0227\n\004type\030\001 \002(\0162).Mysqlx.Prepa" +
      "re.Prepare.OneOfMessage.Type\022\037\n\004find\030\002 \001" +
      "(\0132\021.Mysqlx.Crud.Find\022#\n\006insert\030\003 \001(\0132\023." +
      "Mysqlx.Crud.Insert\022#\n\006update\030\004 \001(\0132\023.Mys" +
      "qlx.Crud.Update\022#\n\006delete\030\005 \001(\0132\023.Mysqlx" +
      ".Crud.Delete\022-\n\014stmt_execute\030\006 \001(\0132\027.Mys" +
      "qlx.Sql.StmtExecute\">\n\004Type\022\010\n\004FIND\020\000\022\n\n" +
      "\006INSERT\020\001\022\n\n\006UPDATE\020\002\022\n\n\006DELETE\020\004\022\010\n\004STM" +
      "T\020\005:\004\210\3520(\"f\n\007Execute\022\017\n\007stmt_id\030\001 \002(\r\022#\n" +
      "\004args\030\002 \003(\0132\025.Mysqlx.Datatypes.Any\022\037\n\020co" +
      "mpact_metadata\030\003 \001(\010:\005false:\004\210\3520)\"#\n\nDea" +
      "llocate\022\017\n\007stmt_id\030\001 \002(\r:\004\210\3520*B\031\n\027com.my" +
      "sql.cj.x.protobuf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.Mysqlx.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxSql.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor(),
        });
    internal_static_Mysqlx_Prepare_Prepare_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Prepare_Prepare_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Prepare_Prepare_descriptor,
        new java.lang.String[] { "StmtId", "Stmt", });
    internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_descriptor =
      internal_static_Mysqlx_Prepare_Prepare_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Prepare_Prepare_OneOfMessage_descriptor,
        new java.lang.String[] { "Type", "Find", "Insert", "Update", "Delete", "StmtExecute", });
    internal_static_Mysqlx_Prepare_Execute_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Prepare_Execute_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Prepare_Execute_descriptor,
        new java.lang.String[] { "StmtId", "Args", "CompactMetadata", });
    internal_static_Mysqlx_Prepare_Deallocate_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Prepare_Deallocate_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Prepare_Deallocate_descriptor,
        new java.lang.String[] { "StmtId", });
    descriptor.resolveAllFeaturesImmutable();
    com.mysql.cj.x.protobuf.Mysqlx.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxSql.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxCrud.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor();
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.clientMessageId);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
