/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.x509.certificate;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import msfpay.cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.util.BigIntegers;
import msfpay.cfca.sm2rsa.common.PKIException;

public final class X509Cert {
    msfpay.cfca.sadk.x509.certificate.X509Cert core = null;
    private static final Map algFormTable = new HashMap();
    private static boolean signAsn1Flag;

    public X509Cert(byte[] certData) throws PKIException {
        try {
            this.core = new msfpay.cfca.sadk.x509.certificate.X509Cert(certData);
        }
        catch (msfpay.cfca.sadk.algorithm.common.PKIException e) {
            throw new PKIException(e.getErrDesc(), e);
        }
    }

    public X509Cert(InputStream is) throws PKIException {
        try {
            this.core = new msfpay.cfca.sadk.x509.certificate.X509Cert(is);
        }
        catch (msfpay.cfca.sadk.algorithm.common.PKIException e) {
            throw new PKIException(e.getErrDesc(), e);
        }
    }

    public byte[] getEncoded() throws PKIException {
        try {
            return this.core.getEncoded();
        }
        catch (msfpay.cfca.sadk.algorithm.common.PKIException e) {
            throw new PKIException(e.getErrDesc(), e);
        }
    }

    public String getIssuerDN() {
        return this.core.getIssuerX500Name().toString();
    }

    public String getDN() {
        X500Name x500SubjectName = this.core.getSubjectX500Name();
        return x500SubjectName.toString();
    }

    public Date getNotBefore() {
        return this.core.getNotBefore();
    }

    public Date getNotAfter() {
        return this.core.getNotAfter();
    }

    public BigInteger getSerialNumber() {
        return this.core.getSerialNumber();
    }

    public String getStringSerialNumber() {
        return this.core.getStringSerialNumber();
    }

    public String getSignatureAlgName() {
        String sigAlg = this.core.getSignatureAlgName();
        String value = (String)algFormTable.get(sigAlg);
        if (value == null) {
            value = sigAlg;
        }
        return value;
    }

    public PublicKey getPublicKey() throws PKIException {
        try {
            return this.core.getPublicKey();
        }
        catch (msfpay.cfca.sadk.algorithm.common.PKIException e) {
            throw new PKIException(e.getErrDesc(), e);
        }
    }

    public boolean verify(PublicKey pubKey) throws PKIException {
        try {
            return this.core.verify(pubKey);
        }
        catch (msfpay.cfca.sadk.algorithm.common.PKIException e) {
            throw new PKIException(e.getErrDesc(), e);
        }
    }

    public byte[] getPublicKeyData() throws PKIException {
        try {
            return this.core.getPublicKeyData();
        }
        catch (msfpay.cfca.sadk.algorithm.common.PKIException e) {
            throw new PKIException(e.getErrDesc(), e);
        }
    }

    public byte[] getTBSCertificate() throws PKIException {
        try {
            return this.core.getTBSCertificate();
        }
        catch (msfpay.cfca.sadk.algorithm.common.PKIException e) {
            throw new PKIException(e.getErrDesc(), e);
        }
    }

    public byte[] getSignature() {
        byte[] signValue = this.core.getSignature();
        String signAlgName = this.getSignatureAlgName();
        if (signAlgName != null && signAlgName.toUpperCase().indexOf("SM2") >= 0) {
            try {
                if (signValue.length == 64) {
                    if (signAsn1Flag) {
                        signValue = ASN1SM2Signature.getInstance(signValue).getEncoded();
                    }
                } else if (!signAsn1Flag) {
                    ASN1SM2Signature sig = ASN1SM2Signature.getInstance(signValue);
                    byte[] value = new byte[64];
                    System.arraycopy(BigIntegers.asUnsignedByteArray(32, sig.getR().getValue()), 0, value, 0, 32);
                    System.arraycopy(BigIntegers.asUnsignedByteArray(32, sig.getS().getValue()), 0, value, 32, 32);
                    signValue = value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return signValue;
    }

    static {
        algFormTable.put("md2WithRSAEncryption", "MD2withRSAEncryption");
        algFormTable.put("md5WithRSAEncryption", "MD5withRSAEncryption");
        algFormTable.put("sha1WithRSAEncryption", "SHA1withRSAEncryption");
        algFormTable.put("sha256WithRSAEncryption", "SHA256withRSAEncryption");
        algFormTable.put("sha512WithRSAEncryption", "SHA512withRSAEncryption");
        algFormTable.put("sm3WithSM2Encryption", "SM3withSM2");
        algFormTable.put("sm3WithSM2Encryption_OLD", "SM3withSM2");
        algFormTable.put("SM3WithSM2", "SM3withSM2");
        algFormTable.put("SM2WithSM3", "SM3withSM2");
        signAsn1Flag = "1".equals(System.getenv("smcert.sign.asn1Flag"));
    }
}

