/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.x509.certificate;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.asn1.parser.ASN1Parser;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERBitString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERNull;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERSequence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.TBSCertificate;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.Time;
import msfpay.cfca.sadk.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import msfpay.cfca.sadk.system.Mechanisms;

public class X509CertGenerator {
    private Mechanism mechanism = null;
    private V3TBSCertificateGenerator tbsCertGen = new V3TBSCertificateGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private String subject = null;
    private String issuer = null;
    private BigInteger serialNumber = null;
    private Date notBefore = null;
    private Date notAfter = null;
    private PublicKey pubKey = null;
    private DERBitString signature = null;
    private TBSCertificate tbsCert = null;
    private Hashtable extensionSet = new Hashtable();

    public void setSerialNumber(String serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
        }
        this.serialNumber = new BigInteger(serialNumber, 16);
        this.tbsCertGen.setSerialNumber(new ASN1Integer(this.serialNumber));
    }

    public void setSerialNumber(BigInteger serialNumber) throws PKIException {
        if (serialNumber == null) {
            throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
        }
        this.serialNumber = serialNumber;
        this.tbsCertGen.setSerialNumber(new ASN1Integer(serialNumber));
    }

    public void setSubject(String subjectDN) throws PKIException {
        if (subjectDN == null || subjectDN.trim().length() == 0) {
            throw new PKIException(PKIException.SUBJECT_NULL, PKIException.SUBJECT_NULL_DES);
        }
        this.subject = subjectDN;
        this.tbsCertGen.setSubject(new X500Name(subjectDN));
    }

    public void setSubject(X500NameStyle style, String subjectDN) throws PKIException {
        if (style == null) {
            throw new PKIException("style is null");
        }
        if (subjectDN == null || subjectDN.trim().length() == 0) {
            throw new PKIException(PKIException.SUBJECT_NULL, PKIException.SUBJECT_NULL_DES);
        }
        this.subject = subjectDN;
        this.tbsCertGen.setSubject(new X500Name(style, subjectDN));
    }

    public void setIssuer(String issuerDN) throws PKIException {
        if (issuerDN == null || issuerDN.trim().length() == 0) {
            throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
        }
        this.issuer = issuerDN;
        this.tbsCertGen.setIssuer(new X500Name(issuerDN));
    }

    public void setIssuer(X500NameStyle style, String issuerDN) throws PKIException {
        if (style == null) {
            throw new PKIException("style is null");
        }
        if (issuerDN == null || issuerDN.trim().length() == 0) {
            throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
        }
        this.issuer = issuerDN;
        this.tbsCertGen.setIssuer(new X500Name(style, issuerDN));
    }

    public void setNotBefore(Date notBefore) throws PKIException {
        if (notBefore == null) {
            throw new PKIException(PKIException.NOT_BEFORE_NULL, PKIException.NOT_BEFORE_NULL_DES);
        }
        this.notBefore = notBefore;
        this.tbsCertGen.setStartDate(new Time(notBefore));
    }

    public void setNotAfter(Date notAfter) throws PKIException {
        if (notAfter == null) {
            throw new PKIException(PKIException.NOT_AFTER_NULL, PKIException.NOT_AFTER_NULL_DES);
        }
        this.notAfter = notAfter;
        this.tbsCertGen.setEndDate(new Time(notAfter));
    }

    public void setPublicKey(PublicKey publicKey) throws PKIException {
        if (publicKey == null) {
            throw new PKIException(PKIException.PUB_KEY_NULL, PKIException.PUB_KEY_NULL_DES);
        }
        this.pubKey = publicKey;
        SubjectPublicKeyInfo spki = null;
        try {
            spki = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSER + PKIException.KEY_SPKI, PKIException.KEY_SPKI_DES, ex);
        }
        this.tbsCertGen.setSubjectPublicKeyInfo(spki);
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
        }
        this.mechanism = Mechanisms.signMechanismFrom(signatureAlgorithm);
        if (this.mechanism == null) {
            throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ": " + signatureAlgorithm);
        }
        ASN1ObjectIdentifier oid = Mechanism.getObjectIdentifier(signatureAlgorithm);
        this.sigAlg = new AlgorithmIdentifier(oid, DERNull.INSTANCE);
        this.tbsCertGen.setSignature(this.sigAlg);
    }

    public void setIssuerUniqueID(byte[] issuerUniqueID) {
        if (issuerUniqueID != null) {
            this.tbsCertGen.setIssuerUniqueID(new DERBitString(issuerUniqueID));
        }
    }

    public void setSubjectUniqueID(byte[] subjectUniqueID) {
        if (subjectUniqueID != null) {
            this.tbsCertGen.setSubjectUniqueID(new DERBitString(subjectUniqueID));
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        ASN1ObjectIdentifier derOID = extension.getExtnId();
        this.extensionSet.put(derOID, extension);
    }

    private Extensions generaterExtensions() {
        if (this.extensionSet != null) {
            Iterator itor = this.extensionSet.entrySet().iterator();
            Vector v = new Vector();
            while (itor.hasNext()) {
                Map.Entry entryt = itor.next();
                v.add(entryt.getValue());
            }
            Extension[] extensionArray = new Extension[v.size()];
            v.toArray(extensionArray);
            return new Extensions(extensionArray);
        }
        return null;
    }

    public byte[] generateX509Cert(PrivateKey privateKey, Session session) throws PKIException {
        if (this.issuer == null || this.issuer.trim().length() == 0) {
            throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
        }
        if (this.subject == null || this.subject.trim().length() == 0) {
            throw new PKIException(PKIException.SUBJECT_NULL, PKIException.SUBJECT_NULL_DES);
        }
        if (this.pubKey == null) {
            throw new PKIException(PKIException.PUB_KEY_NULL, PKIException.PUB_KEY_NULL_DES);
        }
        if (this.sigAlg == null) {
            throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
        }
        if (this.serialNumber == null) {
            throw new PKIException(PKIException.SN_NULL, PKIException.SN_NULL_DES);
        }
        if (this.notBefore == null) {
            throw new PKIException(PKIException.NOT_BEFORE_NULL, PKIException.NOT_BEFORE_NULL_DES);
        }
        if (this.notAfter == null) {
            throw new PKIException(PKIException.NOT_AFTER_NULL, PKIException.NOT_AFTER_NULL_DES);
        }
        this.generateSignature(privateKey, session);
        return this.constructCertificate();
    }

    private void generateSignature(PrivateKey privateKey, Session session) throws PKIException {
        if (this.extensionSet.size() > 0) {
            this.tbsCertGen.setExtensions(this.generaterExtensions());
        }
        this.tbsCert = this.tbsCertGen.generateTBSCertificate();
        byte[] bTBSCert = null;
        try {
            bTBSCert = ASN1Parser.parseDERObj2Bytes(this.tbsCert);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.TBSCERT_BYTES, PKIException.TBSCERT_BYTES_DES, ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, privateKey, bTBSCert);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    private byte[] constructCertificate() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsCert);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] certData = null;
        try {
            certData = ASN1Parser.parseDERObj2Bytes(derSeq);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.CERT_BYTES, PKIException.CERT_BYTES_DES, ex);
        }
        return certData;
    }
}

