/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.util;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import msfpay.cfca.sadk.algorithm.common.Mechanism;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.sm2.SM2PrivateKey;
import msfpay.cfca.sadk.algorithm.sm2.SM2PublicKey;
import msfpay.cfca.sadk.algorithm.util.InitKeyStore;
import msfpay.cfca.sadk.asn1.parser.ASN1Parser;
import msfpay.cfca.sadk.asn1.pkcs.PKCS12;
import msfpay.cfca.sadk.asn1.pkcs.PKCS12_SM2;
import msfpay.cfca.sadk.lib.crypto.Session;
import msfpay.cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import msfpay.cfca.sadk.util.Base64;

public class KeyUtil {
    public static PrivateKey getPrivateKeyFromPFX(InputStream pfxInputStream, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxInputStream);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static PrivateKey getPrivateKeyFromPFX(String pfxFilePath, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxFilePath);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static PrivateKey getPrivateKeyFromPFX(byte[] pfxFileData, String pfxFilePwd) throws PKIException {
        PKCS12 pkcs12 = new PKCS12();
        pkcs12.load(pfxFileData);
        pkcs12.decrypt(pfxFilePwd.toCharArray());
        return pkcs12.getPrivateKey();
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(String sm2FilePath, String sm2FilePwd) throws PKIException {
        FilterInputStream ais = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sm2FilePath);
            byte[] data = new byte[fis.available()];
            fis.read(data);
            boolean isB64 = ASN1Parser.isBase64Compatability(data);
            if (isB64) {
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ais = new ASN1InputStream(bis);
            PKCS12_SM2 sm2Pfx = PKCS12_SM2.getInstance(((ASN1InputStream)ais).readObject());
            SM2PrivateKey sM2PrivateKey = sm2Pfx.getPrivateKey(sm2FilePwd);
            return sM2PrivateKey;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("SM2File Parsed Failure", e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(InputStream sm2InputStream, String sm2FilePwd) throws PKIException {
        FilterInputStream ais = null;
        try {
            byte[] data = new byte[sm2InputStream.available()];
            sm2InputStream.read(data);
            boolean isB64 = ASN1Parser.isBase64Compatability(data);
            if (isB64) {
                data = Base64.decode(data);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            ais = new ASN1InputStream(bis);
            PKCS12_SM2 object = PKCS12_SM2.getInstance(((ASN1InputStream)ais).readObject());
            SM2PrivateKey sM2PrivateKey = object.getPrivateKey(sm2FilePwd);
            return sM2PrivateKey;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("SM2File Parsed Failure", e);
        }
        finally {
            try {
                sm2InputStream.close();
            }
            catch (Exception e) {
                throw new PKIException("SM2File Parsed Failure", e);
            }
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception e) {
                    throw new PKIException("SM2File Parsed Failure", e);
                }
            }
        }
    }

    public static SM2PrivateKey getPrivateKeyFromSM2(byte[] sm2FileData, String sm2FilePwd) throws PKIException {
        FilterInputStream ais = null;
        try {
            boolean isB64 = ASN1Parser.isBase64Compatability(sm2FileData);
            if (isB64) {
                sm2FileData = Base64.decode(sm2FileData);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(sm2FileData);
            ais = new ASN1InputStream(bis);
            PKCS12_SM2 object = PKCS12_SM2.getInstance(((ASN1InputStream)ais).readObject());
            SM2PrivateKey sM2PrivateKey = object.getPrivateKey(sm2FilePwd);
            return sM2PrivateKey;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("SM2File Parsed Failure", e);
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (Exception e) {
                    throw new PKIException("SM2File Parsed Failure", e);
                }
            }
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(String jksFilePath, String jksFilePwd, String alias) throws PKIException {
        try {
            KeyStore ks = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePwd);
            char[] password = jksFilePwd.toCharArray();
            return (PrivateKey)ks.getKey(alias, password);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("JKSFile Parsed Failure", e);
        }
    }

    public static PrivateKey getPrivateKeyFromJKS(InputStream jksInputStream, String jksFilePwd, String alias) throws PKIException {
        try {
            KeyStore ks = InitKeyStore.initJKSKeyStore(jksInputStream, jksFilePwd);
            char[] password = jksFilePwd.toCharArray();
            return (PrivateKey)ks.getKey(alias, password);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("JKSFile Parsed Failure", e);
        }
    }

    public static KeyPair generateKeyPair(Mechanism keypairType, int bitLength, Session session) throws PKIException {
        if ("SM2".equals(keypairType.getMechanismType()) && 256 != bitLength) {
            throw new PKIException("key length must be 256 bits for SM2");
        }
        return session.generateKeyPair(keypairType, bitLength);
    }

    public static Key generateKey(Mechanism symmetricKeyType, Session session) throws PKIException {
        return session.generateKey(symmetricKeyType);
    }

    public static Key generateKey(Mechanism symmetricKeyType, byte[] keyData, Session session) throws PKIException {
        return session.generateKey(symmetricKeyType, keyData);
    }

    public static SM2PublicKey getSM2PublicKey(byte[] pubX, byte[] pubY) {
        return new SM2PublicKey(pubX, pubY);
    }

    public static SM2PrivateKey getSM2PrivateKey(byte[] da, byte[] pubX, byte[] pubY) {
        return new SM2PrivateKey(da, pubX, pubY);
    }
}

