/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.signature.sm2;

import java.security.PublicKey;
import msfpay.cfca.sadk.algorithm.common.PKIException;
import msfpay.cfca.sadk.algorithm.sm2.SM2PublicKey;
import msfpay.cfca.sadk.signature.sm2.SM2Signature;

public class SM2SignUtil {
    public static boolean verify(byte[] sourceData, byte[] userId, byte[] signature, PublicKey pubKey) throws PKIException {
        SM2Signature signer = new SM2Signature();
        if (sourceData == null || signature == null) {
            return false;
        }
        signer.initVerify(pubKey);
        SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
        byte[] z = sm2PubKey.calcZ(userId);
        signer.update(z, 0, z.length);
        return signer.verify(signature, sourceData);
    }

    public static boolean verify(byte[] sourceData, byte[] signature, PublicKey pubKey) throws PKIException {
        SM2Signature signer = new SM2Signature();
        if (sourceData == null || signature == null) {
            return false;
        }
        signer.initVerify(pubKey);
        return signer.verify(signature, sourceData);
    }
}

