/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.util.encoders;

import java.io.IOException;
import java.io.OutputStream;
import msfpay.cfca.sadk.org.bouncycastle.util.encoders.Encoder;

public class HexEncoder
implements Encoder {
    private static final byte[] encodingTable;
    private static final byte[] decodingTable;

    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int value = 0;
        for (int i = off; i < off + length; ++i) {
            value = data[i] & 0xFF;
            out.write(encodingTable[value >>> 4]);
            out.write(encodingTable[value & 0xF]);
        }
        return length * 2;
    }

    private static boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int end;
        int outLen = 0;
        for (end = off + length; end > off && HexEncoder.ignore((char)data[end - 1]); --end) {
        }
        int i = off;
        while (i < end) {
            byte b2;
            while (i < end && HexEncoder.ignore((char)data[i])) {
                ++i;
            }
            byte b1 = decodingTable[data[i++]];
            while (i < end && HexEncoder.ignore((char)data[i])) {
                ++i;
            }
            if ((b1 | (b2 = decodingTable[data[i++]])) < 0) {
                throw new IOException("invalid characters encountered in Hex data");
            }
            out.write(b1 << 4 | b2);
            ++outLen;
        }
        return outLen;
    }

    public int decode(String data, OutputStream out) throws IOException {
        int end;
        int length = 0;
        for (end = data.length(); end > 0 && HexEncoder.ignore(data.charAt(end - 1)); --end) {
        }
        int i = 0;
        while (i < end) {
            byte b2;
            while (i < end && HexEncoder.ignore(data.charAt(i))) {
                ++i;
            }
            byte b1 = decodingTable[data.charAt(i++)];
            while (i < end && HexEncoder.ignore(data.charAt(i))) {
                ++i;
            }
            if ((b1 | (b2 = decodingTable[data.charAt(i++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            out.write(b1 << 4 | b2);
            ++length;
        }
        return length;
    }

    static {
        int i;
        encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        decodingTable = new byte[128];
        for (i = 0; i < decodingTable.length; ++i) {
            HexEncoder.decodingTable[i] = -1;
        }
        for (i = 0; i < encodingTable.length; ++i) {
            HexEncoder.decodingTable[HexEncoder.encodingTable[i]] = (byte)i;
        }
        HexEncoder.decodingTable[65] = decodingTable[97];
        HexEncoder.decodingTable[66] = decodingTable[98];
        HexEncoder.decodingTable[67] = decodingTable[99];
        HexEncoder.decodingTable[68] = decodingTable[100];
        HexEncoder.decodingTable[69] = decodingTable[101];
        HexEncoder.decodingTable[70] = decodingTable[102];
    }
}

