/*
 * Decompiled with CFR 0.152.
 */
package msfpay.cfca.sadk.org.bouncycastle.tsp.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import msfpay.cfca.sadk.org.bouncycastle.asn1.BEROctetString;
import msfpay.cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.Evidence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.TimeStampAndCRL;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import msfpay.cfca.sadk.org.bouncycastle.asn1.cms.TimeStampedData;
import msfpay.cfca.sadk.org.bouncycastle.cms.CMSException;
import msfpay.cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import msfpay.cfca.sadk.org.bouncycastle.tsp.cms.CMSTimeStampedData;
import msfpay.cfca.sadk.org.bouncycastle.tsp.cms.CMSTimeStampedGenerator;
import msfpay.cfca.sadk.org.bouncycastle.util.io.Streams;

public class CMSTimeStampedDataGenerator
extends CMSTimeStampedGenerator {
    public CMSTimeStampedData generate(TimeStampToken timeStamp) throws CMSException {
        return this.generate(timeStamp, (InputStream)null);
    }

    public CMSTimeStampedData generate(TimeStampToken timeStamp, byte[] content) throws CMSException {
        return this.generate(timeStamp, new ByteArrayInputStream(content));
    }

    public CMSTimeStampedData generate(TimeStampToken timeStamp, InputStream content) throws CMSException {
        ByteArrayOutputStream contentOut = new ByteArrayOutputStream();
        if (content != null) {
            try {
                Streams.pipeAll(content, contentOut);
            }
            catch (IOException e) {
                throw new CMSException("exception encapsulating content: " + e.getMessage(), e);
            }
        }
        BEROctetString encContent = null;
        if (contentOut.size() != 0) {
            encContent = new BEROctetString(contentOut.toByteArray());
        }
        TimeStampAndCRL stamp = new TimeStampAndCRL(timeStamp.toCMSSignedData().toASN1Structure());
        DERIA5String asn1DataUri = null;
        if (this.dataUri != null) {
            asn1DataUri = new DERIA5String(this.dataUri.toString());
        }
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(asn1DataUri, this.metaData, encContent, new Evidence(new TimeStampTokenEvidence(stamp)))));
    }
}

